/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.scene3d.scene;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.environment.BaseLight;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.environment.PointLight;
import com.badlogic.gdx.graphics.g3d.environment.SpotLight;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.utils.AnimationController;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Pool;
import net.mgsx.gltf.scene3d.animation.AnimationControllerHack;
import net.mgsx.gltf.scene3d.animation.AnimationsPlayer;
import net.mgsx.gltf.scene3d.lights.DirectionalLightEx;
import net.mgsx.gltf.scene3d.lights.PointLightEx;
import net.mgsx.gltf.scene3d.lights.SpotLightEx;
import net.mgsx.gltf.scene3d.model.ModelInstanceHack;
import net.mgsx.gltf.scene3d.scene.SceneModel;
import net.mgsx.gltf.scene3d.scene.Updatable;

public class Scene
implements RenderableProvider,
Updatable {
    public ModelInstance modelInstance;
    public AnimationController animationController;
    public final ObjectMap<Node, BaseLight> lights = new ObjectMap();
    public final ObjectMap<Node, Camera> cameras = new ObjectMap();
    public final AnimationsPlayer animations;
    private static final Matrix4 transform = new Matrix4();

    public Scene(SceneModel sceneModel) {
        this(new ModelInstanceHack(sceneModel.model));
        for (ObjectMap.Entry entry : sceneModel.cameras) {
            this.cameras.put((Object)this.modelInstance.getNode(((Node)entry.key).id, true), (Object)this.createCamera((Camera)entry.value));
        }
        for (ObjectMap.Entry entry : sceneModel.lights) {
            this.lights.put((Object)this.modelInstance.getNode(((Node)entry.key).id, true), (Object)this.createLight((BaseLight)entry.value));
        }
        this.syncCameras();
        this.syncLights();
    }

    public Camera createCamera(Camera from) {
        PerspectiveCamera copy;
        if (from instanceof PerspectiveCamera) {
            PerspectiveCamera camera = new PerspectiveCamera();
            camera.fieldOfView = ((PerspectiveCamera)from).fieldOfView;
            copy = camera;
        } else if (from instanceof OrthographicCamera) {
            OrthographicCamera camera = new OrthographicCamera();
            camera.zoom = ((OrthographicCamera)from).zoom;
            copy = camera;
        } else {
            throw new GdxRuntimeException("unknown camera type " + from.getClass().getName());
        }
        copy.position.set(from.position);
        copy.direction.set(from.direction);
        copy.up.set(from.up);
        copy.near = from.near;
        copy.far = from.far;
        copy.viewportWidth = from.viewportWidth;
        copy.viewportHeight = from.viewportHeight;
        return copy;
    }

    protected BaseLight createLight(BaseLight from) {
        if (from instanceof DirectionalLight) {
            return new DirectionalLightEx().set((DirectionalLight)from);
        }
        if (from instanceof PointLight) {
            return new PointLightEx().set((PointLight)from);
        }
        if (from instanceof SpotLight) {
            return new SpotLightEx().set((SpotLight)from);
        }
        throw new GdxRuntimeException("unknown light type " + from.getClass().getName());
    }

    public Scene(Model model) {
        this(new ModelInstanceHack(model));
    }

    public Scene(ModelInstance modelInstance) {
        this(modelInstance, modelInstance.animations.size > 0);
    }

    public Scene(ModelInstance modelInstance, boolean animated) {
        this.modelInstance = modelInstance;
        if (animated) {
            this.animationController = new AnimationControllerHack(modelInstance);
        }
        this.animations = new AnimationsPlayer(this);
    }

    public Scene(Model model, boolean animated) {
        this(new ModelInstanceHack(model), animated);
    }

    @Override
    public void update(Camera camera, float delta) {
        this.animations.update(delta);
        this.syncCameras();
        this.syncLights();
    }

    private void syncCameras() {
        for (ObjectMap.Entry e : this.cameras) {
            Node node = (Node)e.key;
            Camera camera = (Camera)e.value;
            transform.set(node.globalTransform).mul(this.modelInstance.transform);
            camera.position.setZero().mul(transform);
            camera.direction.set(0.0f, 0.0f, -1.0f).rot(transform);
            camera.up.set(Vector3.Y).rot(transform);
            camera.update();
        }
    }

    private void syncLights() {
        for (ObjectMap.Entry e : this.lights) {
            Node node = (Node)e.key;
            BaseLight light = (BaseLight)e.value;
            transform.set(node.globalTransform).mul(this.modelInstance.transform);
            if (light instanceof DirectionalLight) {
                ((DirectionalLight)light).direction.set(0.0f, 0.0f, -1.0f).rot(transform);
                continue;
            }
            if (light instanceof PointLight) {
                ((PointLight)light).position.setZero().mul(transform);
                continue;
            }
            if (!(light instanceof SpotLight)) continue;
            ((SpotLight)light).position.setZero().mul(transform);
            ((SpotLight)light).direction.set(0.0f, 0.0f, -1.0f).rot(transform);
        }
    }

    public Camera getCamera(String name) {
        for (ObjectMap.Entry e : this.cameras) {
            if (!name.equals(((Node)e.key).id)) continue;
            return (Camera)e.value;
        }
        return null;
    }

    public BaseLight getLight(String name) {
        for (ObjectMap.Entry e : this.lights) {
            if (!name.equals(((Node)e.key).id)) continue;
            return (BaseLight)e.value;
        }
        return null;
    }

    public int getDirectionalLightCount() {
        int count = 0;
        for (ObjectMap.Entry entry : this.lights) {
            if (!(entry.value instanceof DirectionalLight)) continue;
            ++count;
        }
        return count;
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        this.modelInstance.getRenderables(renderables, pool);
    }
}

