/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.scene3d.lights;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.environment.ShadowMap;
import com.badlogic.gdx.graphics.g3d.utils.TextureDescriptor;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Disposable;
import net.mgsx.gltf.scene3d.lights.DirectionalLightEx;

public class DirectionalShadowLight
extends DirectionalLightEx
implements ShadowMap,
Disposable {
    protected static final float SQRT2 = (float)Math.sqrt(2.0);
    protected FrameBuffer fbo;
    protected Camera cam;
    protected final Vector3 tmpV = new Vector3();
    protected final TextureDescriptor textureDesc;
    protected final Vector3 center = new Vector3();

    public DirectionalShadowLight() {
        this(1024, 1024);
    }

    public DirectionalShadowLight(int shadowMapWidth, int shadowMapHeight) {
        this(shadowMapWidth, shadowMapHeight, 100.0f, 100.0f, 0.0f, 100.0f);
    }

    public DirectionalShadowLight(int shadowMapWidth, int shadowMapHeight, float shadowViewportWidth, float shadowViewportHeight, float shadowNear, float shadowFar) {
        this.fbo = new FrameBuffer(Pixmap.Format.RGBA8888, shadowMapWidth, shadowMapHeight, true);
        this.cam = new OrthographicCamera(shadowViewportWidth, shadowViewportHeight);
        this.cam.near = shadowNear;
        this.cam.far = shadowFar;
        this.textureDesc = new TextureDescriptor();
        this.textureDesc.minFilter = this.textureDesc.magFilter = Texture.TextureFilter.Nearest;
        this.textureDesc.uWrap = this.textureDesc.vWrap = Texture.TextureWrap.ClampToEdge;
    }

    public DirectionalShadowLight setShadowMapSize(int shadowMapWidth, int shadowMapHeight) {
        if (this.fbo == null || this.fbo.getWidth() != shadowMapWidth || this.fbo.getHeight() != shadowMapHeight) {
            if (this.fbo != null) {
                this.fbo.dispose();
            }
            this.fbo = new FrameBuffer(Pixmap.Format.RGBA8888, shadowMapWidth, shadowMapHeight, true);
        }
        return this;
    }

    public DirectionalShadowLight setViewport(float shadowViewportWidth, float shadowViewportHeight, float shadowNear, float shadowFar) {
        this.cam.viewportWidth = shadowViewportWidth;
        this.cam.viewportHeight = shadowViewportHeight;
        this.cam.near = shadowNear;
        this.cam.far = shadowFar;
        return this;
    }

    public DirectionalShadowLight setCenter(Vector3 center) {
        this.center.set(center);
        return this;
    }

    public DirectionalShadowLight setCenter(float x, float y, float z) {
        this.center.set(x, y, z);
        return this;
    }

    public DirectionalShadowLight setBounds(BoundingBox box) {
        float w = box.getWidth();
        float h = box.getHeight();
        float d = box.getDepth();
        float s = Math.max(Math.max(w, h), d);
        h = d = s * SQRT2;
        w = d;
        box.getCenter(this.center);
        return this.setViewport(w, h, 0.0f, d);
    }

    protected void validate() {
        float halfDepth = this.cam.near + 0.5f * (this.cam.far - this.cam.near);
        this.cam.position.set(this.direction).scl(-halfDepth).add(this.center);
        this.cam.direction.set(this.direction).nor();
        this.cam.normalizeUp();
        this.cam.update();
    }

    public void begin() {
        this.validate();
        int w = this.fbo.getWidth();
        int h = this.fbo.getHeight();
        this.fbo.begin();
        Gdx.gl.glViewport(0, 0, w, h);
        Gdx.gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        Gdx.gl.glClear(16640);
        Gdx.gl.glEnable(3089);
        Gdx.gl.glScissor(1, 1, w - 2, h - 2);
    }

    public void end() {
        Gdx.gl.glDisable(3089);
        this.fbo.end();
    }

    public FrameBuffer getFrameBuffer() {
        return this.fbo;
    }

    public Camera getCamera() {
        return this.cam;
    }

    public Matrix4 getProjViewTrans() {
        return this.cam.combined;
    }

    public TextureDescriptor getDepthMap() {
        this.textureDesc.texture = this.fbo.getColorBufferTexture();
        return this.textureDesc;
    }

    public void dispose() {
        if (this.fbo != null) {
            this.fbo.dispose();
        }
        this.fbo = null;
    }

    @Override
    public boolean equals(DirectionalLightEx other) {
        return other instanceof DirectionalShadowLight ? this.equals((DirectionalShadowLight)other) : false;
    }

    public boolean equals(DirectionalShadowLight other) {
        return other != null && other == this;
    }
}

