/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.scene3d.animation;

import com.badlogic.gdx.graphics.g3d.model.Animation;
import com.badlogic.gdx.graphics.g3d.utils.AnimationController;
import com.badlogic.gdx.utils.Array;
import net.mgsx.gltf.scene3d.animation.AnimationControllerHack;
import net.mgsx.gltf.scene3d.scene.Scene;

public class AnimationsPlayer {
    private Scene scene;
    private Array<AnimationController> controllers = new Array();

    public AnimationsPlayer(Scene scene) {
        this.scene = scene;
    }

    public void addAnimations(Array<AnimationController.AnimationDesc> animations) {
        for (AnimationController.AnimationDesc animation : animations) {
            this.addAnimation(animation);
        }
    }

    public void addAnimation(AnimationController.AnimationDesc animation) {
        AnimationControllerHack c = new AnimationControllerHack(this.scene.modelInstance);
        c.calculateTransforms = false;
        c.setAnimationDesc(animation);
        this.controllers.add((Object)c);
    }

    public void clearAnimations() {
        this.controllers.clear();
        if (this.scene.animationController != null) {
            this.scene.animationController.setAnimation(null);
        }
    }

    public void playAll() {
        this.playAll(false);
    }

    public void loopAll() {
        this.playAll(true);
    }

    public void playAll(boolean loop) {
        this.clearAnimations();
        int n = this.scene.modelInstance.animations.size;
        for (int i = 0; i < n; ++i) {
            AnimationControllerHack c = new AnimationControllerHack(this.scene.modelInstance);
            c.calculateTransforms = false;
            c.setAnimation((Animation)this.scene.modelInstance.animations.get(i), loop ? -1 : 1);
            this.controllers.add((Object)c);
        }
    }

    public void stopAll() {
        this.clearAnimations();
    }

    public void update(float delta) {
        if (this.controllers.size > 0) {
            for (AnimationController controller : this.controllers) {
                controller.update(delta);
            }
            this.scene.modelInstance.calculateTransforms();
        } else if (this.scene.animationController != null) {
            this.scene.animationController.update(delta);
        }
    }
}

