/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.scene3d.animation;

import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.model.Animation;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodeAnimation;
import com.badlogic.gdx.graphics.g3d.model.NodeKeyframe;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.graphics.g3d.utils.AnimationController;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Pool;
import net.mgsx.gltf.loaders.shared.animation.Interpolation;
import net.mgsx.gltf.scene3d.animation.NodeAnimationHack;
import net.mgsx.gltf.scene3d.model.CubicQuaternion;
import net.mgsx.gltf.scene3d.model.CubicVector3;
import net.mgsx.gltf.scene3d.model.CubicWeightVector;
import net.mgsx.gltf.scene3d.model.NodePartPlus;
import net.mgsx.gltf.scene3d.model.NodePlus;
import net.mgsx.gltf.scene3d.model.WeightVector;

public class AnimationControllerHack
extends AnimationController {
    private final Pool<Transform> transformPool = new Pool<Transform>(){

        protected Transform newObject() {
            return new Transform();
        }
    };
    private static final ObjectMap<Node, Transform> transforms = new ObjectMap();
    private boolean applying = false;
    public boolean calculateTransforms = true;
    private static final Transform tmpT = new Transform();
    private static final Quaternion q1 = new Quaternion();
    private static final Quaternion q2 = new Quaternion();
    private static final Quaternion q3 = new Quaternion();
    private static final Quaternion q4 = new Quaternion();

    public AnimationControllerHack(ModelInstance target) {
        super(target);
    }

    protected void begin() {
        if (this.applying) {
            throw new GdxRuntimeException("You must call end() after each call to being()");
        }
        this.applying = true;
    }

    protected void apply(Animation animation, float time, float weight) {
        if (!this.applying) {
            throw new GdxRuntimeException("You must call begin() before adding an animation");
        }
        AnimationControllerHack.applyAnimationPlus(transforms, this.transformPool, weight, animation, time);
    }

    protected void end() {
        if (!this.applying) {
            throw new GdxRuntimeException("You must call begin() first");
        }
        for (ObjectMap.Entry entry : transforms.entries()) {
            ((Transform)entry.value).toMatrix4(((Node)entry.key).localTransform);
            this.transformPool.free(entry.value);
        }
        transforms.clear();
        if (this.calculateTransforms) {
            this.target.calculateTransforms();
        }
        this.applying = false;
    }

    protected void applyAnimation(Animation animation, float time) {
        if (this.applying) {
            throw new GdxRuntimeException("Call end() first");
        }
        AnimationControllerHack.applyAnimationPlus(null, (Pool<Transform>)((Pool)null), 1.0f, animation, time);
        if (this.calculateTransforms) {
            this.target.calculateTransforms();
        }
    }

    protected void applyAnimations(Animation anim1, float time1, Animation anim2, float time2, float weight) {
        if (anim2 == null || weight == 0.0f) {
            this.applyAnimation(anim1, time1);
        } else if (anim1 == null || weight == 1.0f) {
            this.applyAnimation(anim2, time2);
        } else {
            if (this.applying) {
                throw new GdxRuntimeException("Call end() first");
            }
            this.begin();
            this.apply(anim1, time1, 1.0f);
            this.apply(anim2, time2, weight);
            this.end();
        }
    }

    private static final <T> int getFirstKeyframeIndexAtTime(Array<NodeKeyframe<T>> arr, float time) {
        int n = arr.size - 1;
        for (int i = 0; i < n; ++i) {
            if (!(time >= ((NodeKeyframe)arr.get((int)i)).keytime) || !(time <= ((NodeKeyframe)arr.get((int)(i + 1))).keytime)) continue;
            return i;
        }
        return n;
    }

    private static final Vector3 getTranslationAtTime(NodeAnimation nodeAnim, float time, Vector3 out) {
        if (nodeAnim.translation == null) {
            return out.set(nodeAnim.node.translation);
        }
        if (nodeAnim.translation.size == 1) {
            return out.set((Vector3)((NodeKeyframe)nodeAnim.translation.get((int)0)).value);
        }
        int index = AnimationControllerHack.getFirstKeyframeIndexAtTime(nodeAnim.translation, time);
        Interpolation interpolation = null;
        if (nodeAnim instanceof NodeAnimationHack) {
            interpolation = ((NodeAnimationHack)nodeAnim).translationMode;
        }
        if (interpolation == Interpolation.STEP) {
            NodeKeyframe firstKeyframe = (NodeKeyframe)nodeAnim.translation.get(index);
            out.set((Vector3)firstKeyframe.value);
        } else if (interpolation == Interpolation.LINEAR) {
            NodeKeyframe firstKeyframe = (NodeKeyframe)nodeAnim.translation.get(index);
            out.set((Vector3)firstKeyframe.value);
            if (++index < nodeAnim.translation.size) {
                NodeKeyframe secondKeyframe = (NodeKeyframe)nodeAnim.translation.get(index);
                float t = (time - firstKeyframe.keytime) / (secondKeyframe.keytime - firstKeyframe.keytime);
                out.lerp((Vector3)secondKeyframe.value, t);
            } else {
                out.set((Vector3)firstKeyframe.value);
            }
        } else if (interpolation == Interpolation.CUBICSPLINE) {
            NodeKeyframe firstKeyframe = (NodeKeyframe)nodeAnim.translation.get(index);
            if (++index < nodeAnim.translation.size) {
                NodeKeyframe secondKeyframe = (NodeKeyframe)nodeAnim.translation.get(index);
                float t = (time - firstKeyframe.keytime) / (secondKeyframe.keytime - firstKeyframe.keytime);
                CubicVector3 firstCV = (CubicVector3)((Object)firstKeyframe.value);
                CubicVector3 secondCV = (CubicVector3)((Object)secondKeyframe.value);
                AnimationControllerHack.cubic(out, t, firstCV, firstCV.tangentOut, secondCV, secondCV.tangentIn);
            } else {
                out.set((Vector3)firstKeyframe.value);
            }
        }
        return out;
    }

    private static void cubic(Vector3 out, float t, Vector3 p0, Vector3 m0, Vector3 p1, Vector3 m1) {
        float t2 = t * t;
        float t3 = t2 * t;
        out.set(p0).scl(2.0f * t3 - 3.0f * t2 + 1.0f).mulAdd(m0, t3 - 2.0f * t2 + t).mulAdd(p1, -2.0f * t3 + 3.0f * t2).mulAdd(m1, t3 - t2);
    }

    private static void cubic(Quaternion out, float t, float delta, Quaternion p0, Quaternion m0, Quaternion p1, Quaternion m1) {
        delta = -delta;
        float t2 = t * t;
        float t3 = t2 * t;
        q1.set(p0).mul(2.0f * t3 - 3.0f * t2 + 1.0f);
        q2.set(m0).mul(delta).mul(t3 - 2.0f * t2 + t);
        q3.set(p1).mul(-2.0f * t3 + 3.0f * t2);
        q4.set(m1).mul(delta).mul(t3 - t2);
        out.set(q1).add(q2).add(q3).add(q4).nor();
    }

    private static void cubic(WeightVector out, float t, WeightVector p0, WeightVector m0, WeightVector p1, WeightVector m1) {
        float t2 = t * t;
        float t3 = t2 * t;
        out.set(p0).scl(2.0f * t3 - 3.0f * t2 + 1.0f).mulAdd(m0, t3 - 2.0f * t2 + t).mulAdd(p1, -2.0f * t3 + 3.0f * t2).mulAdd(m1, t3 - t2);
    }

    private static final Quaternion getRotationAtTime(NodeAnimation nodeAnim, float time, Quaternion out) {
        if (nodeAnim.rotation == null) {
            return out.set(nodeAnim.node.rotation);
        }
        if (nodeAnim.rotation.size == 1) {
            return out.set((Quaternion)((NodeKeyframe)nodeAnim.rotation.get((int)0)).value);
        }
        int index = AnimationControllerHack.getFirstKeyframeIndexAtTime(nodeAnim.rotation, time);
        Interpolation interpolation = null;
        if (nodeAnim instanceof NodeAnimationHack) {
            interpolation = ((NodeAnimationHack)nodeAnim).rotationMode;
        }
        if (interpolation == Interpolation.STEP) {
            NodeKeyframe firstKeyframe = (NodeKeyframe)nodeAnim.rotation.get(index);
            out.set((Quaternion)firstKeyframe.value);
        } else if (interpolation == Interpolation.LINEAR) {
            NodeKeyframe firstKeyframe = (NodeKeyframe)nodeAnim.rotation.get(index);
            out.set((Quaternion)firstKeyframe.value);
            if (++index < nodeAnim.rotation.size) {
                NodeKeyframe secondKeyframe = (NodeKeyframe)nodeAnim.rotation.get(index);
                float t = (time - firstKeyframe.keytime) / (secondKeyframe.keytime - firstKeyframe.keytime);
                out.slerp((Quaternion)secondKeyframe.value, t);
            } else {
                out.set((Quaternion)firstKeyframe.value);
            }
        } else if (interpolation == Interpolation.CUBICSPLINE) {
            NodeKeyframe firstKeyframe = (NodeKeyframe)nodeAnim.rotation.get(index);
            if (++index < nodeAnim.rotation.size) {
                NodeKeyframe secondKeyframe = (NodeKeyframe)nodeAnim.rotation.get(index);
                float t = (time - firstKeyframe.keytime) / (secondKeyframe.keytime - firstKeyframe.keytime);
                CubicQuaternion firstCV = (CubicQuaternion)((Object)firstKeyframe.value);
                CubicQuaternion secondCV = (CubicQuaternion)((Object)secondKeyframe.value);
                AnimationControllerHack.cubic(out, t, secondKeyframe.keytime - firstKeyframe.keytime, firstCV, firstCV.tangentOut, secondCV, secondCV.tangentIn);
            } else {
                out.set((Quaternion)firstKeyframe.value);
            }
        }
        return out;
    }

    private static final Vector3 getScalingAtTime(NodeAnimation nodeAnim, float time, Vector3 out) {
        if (nodeAnim.scaling == null) {
            return out.set(nodeAnim.node.scale);
        }
        if (nodeAnim.scaling.size == 1) {
            return out.set((Vector3)((NodeKeyframe)nodeAnim.scaling.get((int)0)).value);
        }
        int index = AnimationControllerHack.getFirstKeyframeIndexAtTime(nodeAnim.scaling, time);
        Interpolation interpolation = null;
        if (nodeAnim instanceof NodeAnimationHack) {
            interpolation = ((NodeAnimationHack)nodeAnim).scalingMode;
        }
        if (interpolation == Interpolation.STEP) {
            NodeKeyframe firstKeyframe = (NodeKeyframe)nodeAnim.scaling.get(index);
            out.set((Vector3)firstKeyframe.value);
        } else if (interpolation == Interpolation.LINEAR) {
            NodeKeyframe firstKeyframe = (NodeKeyframe)nodeAnim.scaling.get(index);
            out.set((Vector3)firstKeyframe.value);
            if (++index < nodeAnim.scaling.size) {
                NodeKeyframe secondKeyframe = (NodeKeyframe)nodeAnim.scaling.get(index);
                float t = (time - firstKeyframe.keytime) / (secondKeyframe.keytime - firstKeyframe.keytime);
                out.lerp((Vector3)secondKeyframe.value, t);
            } else {
                out.set((Vector3)firstKeyframe.value);
            }
        } else if (interpolation == Interpolation.CUBICSPLINE) {
            NodeKeyframe firstKeyframe = (NodeKeyframe)nodeAnim.scaling.get(index);
            if (++index < nodeAnim.scaling.size) {
                NodeKeyframe secondKeyframe = (NodeKeyframe)nodeAnim.scaling.get(index);
                float t = (time - firstKeyframe.keytime) / (secondKeyframe.keytime - firstKeyframe.keytime);
                CubicVector3 firstCV = (CubicVector3)((Object)firstKeyframe.value);
                CubicVector3 secondCV = (CubicVector3)((Object)secondKeyframe.value);
                AnimationControllerHack.cubic(out, t, firstCV, firstCV.tangentOut, secondCV, secondCV.tangentIn);
            } else {
                out.set((Vector3)firstKeyframe.value);
            }
        }
        return out;
    }

    private static final WeightVector getMorphTargetAtTime(NodeAnimationHack nodeAnim, float time, WeightVector out) {
        if (nodeAnim.weights == null) {
            return out.set();
        }
        if (nodeAnim.weights.size == 1) {
            return out.set((WeightVector)((NodeKeyframe)nodeAnim.weights.get((int)0)).value);
        }
        int index = AnimationControllerHack.getFirstKeyframeIndexAtTime(nodeAnim.weights, time);
        Interpolation interpolation = null;
        if (nodeAnim instanceof NodeAnimationHack) {
            interpolation = nodeAnim.weightsMode;
        }
        if (interpolation == Interpolation.STEP) {
            NodeKeyframe firstKeyframe = (NodeKeyframe)nodeAnim.weights.get(index);
            out.set((WeightVector)firstKeyframe.value);
        } else if (interpolation == Interpolation.LINEAR) {
            NodeKeyframe firstKeyframe = (NodeKeyframe)nodeAnim.weights.get(index);
            out.set((WeightVector)firstKeyframe.value);
            if (++index < nodeAnim.weights.size) {
                NodeKeyframe secondKeyframe = (NodeKeyframe)nodeAnim.weights.get(index);
                float t = (time - firstKeyframe.keytime) / (secondKeyframe.keytime - firstKeyframe.keytime);
                out.lerp((WeightVector)secondKeyframe.value, t);
            } else {
                out.set((WeightVector)firstKeyframe.value);
            }
        } else if (interpolation == Interpolation.CUBICSPLINE) {
            NodeKeyframe firstKeyframe = (NodeKeyframe)nodeAnim.weights.get(index);
            if (++index < nodeAnim.weights.size) {
                NodeKeyframe secondKeyframe = (NodeKeyframe)nodeAnim.weights.get(index);
                float t = (time - firstKeyframe.keytime) / (secondKeyframe.keytime - firstKeyframe.keytime);
                CubicWeightVector firstCV = (CubicWeightVector)firstKeyframe.value;
                CubicWeightVector secondCV = (CubicWeightVector)secondKeyframe.value;
                AnimationControllerHack.cubic(out, t, firstCV, firstCV.tangentOut, secondCV, secondCV.tangentIn);
            } else {
                out.set((WeightVector)firstKeyframe.value);
            }
        }
        return out;
    }

    private static final Transform getNodeAnimationTransform(NodeAnimation nodeAnim, float time) {
        Transform transform = tmpT;
        AnimationControllerHack.getTranslationAtTime(nodeAnim, time, transform.translation);
        AnimationControllerHack.getRotationAtTime(nodeAnim, time, transform.rotation);
        AnimationControllerHack.getScalingAtTime(nodeAnim, time, transform.scale);
        if (nodeAnim instanceof NodeAnimationHack) {
            AnimationControllerHack.getMorphTargetAtTime((NodeAnimationHack)nodeAnim, time, transform.weights);
        }
        return transform;
    }

    private static final void applyNodeAnimationDirectly(NodeAnimation nodeAnim, float time) {
        Node node = nodeAnim.node;
        node.isAnimated = true;
        Transform transform = AnimationControllerHack.getNodeAnimationTransform(nodeAnim, time);
        transform.toMatrix4(node.localTransform);
        if (node instanceof NodePlus && ((NodePlus)node).weights != null) {
            ((NodePlus)node).weights.set(transform.weights);
            for (NodePart part : node.parts) {
                ((NodePartPlus)part).morphTargets.set(transform.weights);
            }
        }
    }

    private static final void applyNodeAnimationBlending(NodeAnimation nodeAnim, ObjectMap<Node, Transform> out, Pool<Transform> pool, float alpha, float time) {
        Node node = nodeAnim.node;
        node.isAnimated = true;
        Transform transform = AnimationControllerHack.getNodeAnimationTransform(nodeAnim, time);
        Transform t = (Transform)out.get((Object)node, null);
        if (t != null) {
            if (alpha > 0.999999f) {
                t.set(transform);
            } else {
                t.lerp(transform, alpha);
            }
        } else if (alpha > 0.999999f) {
            out.put((Object)node, (Object)((Transform)pool.obtain()).set(transform));
        } else {
            out.put((Object)node, (Object)((Transform)pool.obtain()).set(node.translation, node.rotation, node.scale, ((NodePlus)node).weights).lerp(transform, alpha));
        }
    }

    protected static void applyAnimationPlus(ObjectMap<Node, Transform> out, Pool<Transform> pool, float alpha, Animation animation, float time) {
        if (out == null) {
            for (NodeAnimation nodeAnim : animation.nodeAnimations) {
                AnimationControllerHack.applyNodeAnimationDirectly(nodeAnim, time);
            }
        } else {
            for (Node node : out.keys()) {
                node.isAnimated = false;
            }
            for (NodeAnimation nodeAnim : animation.nodeAnimations) {
                AnimationControllerHack.applyNodeAnimationBlending(nodeAnim, out, pool, alpha, time);
            }
            for (ObjectMap.Entry e : out.entries()) {
                if (((Node)e.key).isAnimated) continue;
                ((Node)e.key).isAnimated = true;
                ((Transform)e.value).lerp(((Node)e.key).translation, ((Node)e.key).rotation, ((Node)e.key).scale, ((NodePlus)((Object)e.key)).weights, alpha);
            }
        }
    }

    public void setAnimationDesc(AnimationController.AnimationDesc anim) {
        this.setAnimation(anim.animation, anim.offset, anim.duration, anim.loopCount, anim.speed, anim.listener);
    }

    public void setAnimation(Animation animation) {
        this.setAnimation(animation, 1);
    }

    public void setAnimation(Animation animation, int loopCount) {
        this.setAnimation(animation, 0.0f, animation.duration, loopCount, 1.0f, null);
    }

    public static class Transform
    implements Pool.Poolable {
        public final Vector3 translation = new Vector3();
        public final Quaternion rotation = new Quaternion();
        public final Vector3 scale = new Vector3(1.0f, 1.0f, 1.0f);
        public final WeightVector weights = new WeightVector();

        public Transform idt() {
            this.translation.set(0.0f, 0.0f, 0.0f);
            this.rotation.idt();
            this.scale.set(1.0f, 1.0f, 1.0f);
            this.weights.set();
            return this;
        }

        public Transform set(Vector3 t, Quaternion r, Vector3 s, WeightVector w) {
            this.translation.set(t);
            this.rotation.set(r);
            this.scale.set(s);
            this.weights.set(w);
            return this;
        }

        public Transform set(Transform other) {
            return this.set(other.translation, other.rotation, other.scale, other.weights);
        }

        public Transform lerp(Transform target, float alpha) {
            return this.lerp(target.translation, target.rotation, target.scale, target.weights, alpha);
        }

        public Transform lerp(Vector3 targetT, Quaternion targetR, Vector3 targetS, WeightVector targetW, float alpha) {
            this.translation.lerp(targetT, alpha);
            this.rotation.slerp(targetR, alpha);
            this.scale.lerp(targetS, alpha);
            this.weights.lerp(targetW, alpha);
            return this;
        }

        public Matrix4 toMatrix4(Matrix4 out) {
            return out.set(this.translation, this.rotation, this.scale);
        }

        public void reset() {
            this.idt();
        }

        public String toString() {
            return this.translation.toString() + " - " + this.rotation.toString() + " - " + this.scale.toString() + " - " + this.weights.toString();
        }
    }
}

