/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.loaders.shared.scene;

import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ArrayMap;
import java.nio.FloatBuffer;
import net.mgsx.gltf.data.scene.GLTFNode;
import net.mgsx.gltf.data.scene.GLTFSkin;
import net.mgsx.gltf.loaders.exceptions.GLTFIllegalException;
import net.mgsx.gltf.loaders.shared.data.DataResolver;
import net.mgsx.gltf.loaders.shared.scene.NodeResolver;

public class SkinLoader {
    public void load(Array<GLTFSkin> glSkins, Array<GLTFNode> glNodes, NodeResolver nodeResolver, DataResolver dataResolver) {
        for (int i = 0; i < glNodes.size; ++i) {
            GLTFNode glNode = (GLTFNode)glNodes.get(i);
            if (glNode.skin == null) continue;
            GLTFSkin glSkin = (GLTFSkin)glSkins.get(glNode.skin.intValue());
            this.load(glSkin, glNode, nodeResolver.get(i), nodeResolver, dataResolver);
        }
    }

    private void load(GLTFSkin glSkin, GLTFNode glNode, Node node, NodeResolver nodeResolver, DataResolver dataResolver) {
        Array ibms = new Array();
        Array joints = new Array();
        int bonesCount = glSkin.joints.size;
        FloatBuffer floatBuffer = dataResolver.getBufferFloat(glSkin.inverseBindMatrices);
        for (int i = 0; i < bonesCount; ++i) {
            float[] matrixData = new float[16];
            floatBuffer.get(matrixData);
            ibms.add((Object)new Matrix4(matrixData));
        }
        joints.addAll(glSkin.joints);
        if (ibms.size > 0) {
            for (NodePart nodePart : node.parts) {
                nodePart.bones = new Matrix4[ibms.size];
                nodePart.invBoneBindTransforms = new ArrayMap();
                for (int n = 0; n < joints.size; ++n) {
                    nodePart.bones[n] = new Matrix4().idt();
                    int nodeIndex = (Integer)joints.get(n);
                    Node key = nodeResolver.get(nodeIndex);
                    if (key == null) {
                        throw new GLTFIllegalException("node not found for bone: " + nodeIndex);
                    }
                    nodePart.invBoneBindTransforms.put((Object)key, ibms.get(n));
                }
            }
        }
    }
}

