/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.loaders.shared.geometry;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.MeshPlus;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.mgsx.gltf.data.data.GLTFAccessor;
import net.mgsx.gltf.data.geometry.GLTFMesh;
import net.mgsx.gltf.data.geometry.GLTFMorphTarget;
import net.mgsx.gltf.data.geometry.GLTFPrimitive;
import net.mgsx.gltf.loaders.blender.BlenderShapeKeys;
import net.mgsx.gltf.loaders.exceptions.GLTFIllegalException;
import net.mgsx.gltf.loaders.exceptions.GLTFUnsupportedException;
import net.mgsx.gltf.loaders.shared.GLTFTypes;
import net.mgsx.gltf.loaders.shared.data.DataResolver;
import net.mgsx.gltf.loaders.shared.material.MaterialLoader;
import net.mgsx.gltf.scene3d.model.NodePartPlus;
import net.mgsx.gltf.scene3d.model.NodePlus;
import net.mgsx.gltf.scene3d.model.WeightVector;

public class MeshLoader {
    private ObjectMap<GLTFMesh, Array<NodePart>> meshMap = new ObjectMap();
    private final Array<Mesh> meshes = new Array();
    private int maxBones;

    /*
     * Unable to fully structure code
     */
    public void load(Node node, GLTFMesh glMesh, DataResolver dataResolver, MaterialLoader materialLoader) {
        block41: {
            ((NodePlus)node).morphTargetNames = BlenderShapeKeys.parse(glMesh);
            parts = (Array)this.meshMap.get((Object)glMesh);
            if (parts != null) break block41;
            parts = new Array();
            for (GLTFPrimitive primitive : glMesh.primitives) {
                indices = this.loadIndices(primitive, dataResolver);
                maxIndices = indices == null ? 0 : indices.length;
                vertexAttributes = new Array();
                glAccessors = new Array();
                bonesIndices = new Array();
                bonesWeights = new Array();
                hasNormals = false;
                for (ObjectMap.Entry attribute : primitive.attributes) {
                    block43: {
                        block47: {
                            block46: {
                                block45: {
                                    block44: {
                                        block42: {
                                            attributeName = (String)attribute.key;
                                            accessorId = (Integer)attribute.value;
                                            accessor = dataResolver.getAccessor(accessorId);
                                            rawAttribute = true;
                                            if (!attributeName.equals("POSITION")) break block42;
                                            vertexAttributes.add((Object)VertexAttribute.Position());
                                            break block43;
                                        }
                                        if (!attributeName.equals("NORMAL")) break block44;
                                        vertexAttributes.add((Object)VertexAttribute.Normal());
                                        hasNormals = true;
                                        break block43;
                                    }
                                    if (!attributeName.equals("TANGENT")) break block45;
                                    vertexAttributes.add((Object)new VertexAttribute(128, 4, "a_tangent"));
                                    break block43;
                                }
                                if (!attributeName.startsWith("TEXCOORD_")) break block46;
                                unit = this.parseAttributeUnit(attributeName);
                                vertexAttributes.add((Object)VertexAttribute.TexCoords((int)unit));
                                break block43;
                            }
                            if (!attributeName.startsWith("COLOR_")) break block47;
                            unit = this.parseAttributeUnit(attributeName);
                            if (unit == 0) {
                                vertexAttributes.add((Object)VertexAttribute.ColorUnpacked());
                            } else {
                                vertexAttributes.add((Object)new VertexAttribute(2, 4, "a_color" + unit, unit));
                            }
                            break block43;
                        }
                        if (!attributeName.startsWith("WEIGHTS_")) ** GOTO lbl60
                        rawAttribute = false;
                        if (!"VEC4".equals(accessor.type)) {
                            throw new GLTFIllegalException("illegal weight attribute type: " + accessor.type);
                        }
                        unit = this.parseAttributeUnit(attributeName);
                        if (unit >= bonesWeights.size) {
                            bonesWeights.setSize(unit + 1);
                        }
                        if (accessor.componentType == 5126) {
                            bonesWeights.set(unit, (Object)dataResolver.readBufferFloat(accessorId));
                        } else {
                            if (accessor.componentType == 5123) {
                                throw new GLTFUnsupportedException("unsigned short weight attribute not supported");
                            }
                            if (accessor.componentType == 5121) {
                                throw new GLTFUnsupportedException("unsigned byte weight attribute not supported");
                            }
                            throw new GLTFIllegalException("illegal weight attribute type: " + accessor.componentType);
lbl60:
                            // 1 sources

                            if (attributeName.startsWith("JOINTS_")) {
                                rawAttribute = false;
                                if (!"VEC4".equals(accessor.type)) {
                                    throw new GLTFIllegalException("illegal joints attribute type: " + accessor.type);
                                }
                                unit = this.parseAttributeUnit(attributeName);
                                if (unit >= bonesIndices.size) {
                                    bonesIndices.setSize(unit + 1);
                                }
                                if (accessor.componentType == 5121) {
                                    bonesIndices.set(unit, (Object)dataResolver.readBufferUByte(accessorId));
                                } else if (accessor.componentType == 5123) {
                                    bonesIndices.set(unit, (Object)dataResolver.readBufferUShort(accessorId));
                                } else {
                                    throw new GLTFIllegalException("illegal type for joints: " + accessor.componentType);
                                }
                                if (accessor.max != null) {
                                    for (float boneIndex : accessor.max) {
                                        this.maxBones = Math.max(this.maxBones, (int)boneIndex + 1);
                                    }
                                } else {
                                    for (float boneIndex : (float[])((int[])bonesIndices.get(unit))) {
                                        this.maxBones = Math.max(this.maxBones, (int)(boneIndex + true));
                                    }
                                }
                            } else if (attributeName.startsWith("_")) {
                                Gdx.app.error("GLTF", "skip unsupported custom attribute: " + attributeName);
                            } else {
                                throw new GLTFIllegalException("illegal attribute type " + attributeName);
                            }
                        }
                    }
                    if (!rawAttribute) continue;
                    glAccessors.add((Object)accessor);
                }
                if (primitive.targets != null) {
                    morphTargetCount = primitive.targets.size;
                    ((NodePlus)node).weights = new WeightVector(morphTargetCount);
                    for (t = 0; t < primitive.targets.size; ++t) {
                        unit = t;
                        accessorId = ((GLTFMorphTarget)primitive.targets.get(t)).iterator();
                        while (accessorId.hasNext()) {
                            attribute = (ObjectMap.Entry)accessorId.next();
                            attributeName = (String)attribute.key;
                            accessorId = (Integer)attribute.value;
                            accessor = dataResolver.getAccessor(accessorId);
                            glAccessors.add((Object)accessor);
                            if (attributeName.equals("POSITION")) {
                                vertexAttributes.add((Object)new VertexAttribute(512, 3, "a_position" + unit, unit));
                                continue;
                            }
                            if (attributeName.equals("NORMAL")) {
                                vertexAttributes.add((Object)new VertexAttribute(1024, 3, "a_normal" + unit, unit));
                                continue;
                            }
                            if (attributeName.equals("TANGENT")) {
                                vertexAttributes.add((Object)new VertexAttribute(2048, 3, "a_tangent" + unit, unit));
                                continue;
                            }
                            throw new GLTFIllegalException("illegal morph target attribute type " + attributeName);
                        }
                    }
                }
                bSize = bonesIndices.size * 4;
                bonesAttributes = new Array();
                for (b = 0; b < bSize; ++b) {
                    boneAttribute = VertexAttribute.BoneWeight((int)b);
                    vertexAttributes.add((Object)boneAttribute);
                    bonesAttributes.add((Object)boneAttribute);
                }
                if (!hasNormals) {
                    vertexAttributes.add((Object)VertexAttribute.Normal());
                    glAccessors.add(null);
                }
                attributesGroup = new VertexAttributes((VertexAttribute[])vertexAttributes.toArray(VertexAttribute.class));
                vertexFloats = attributesGroup.vertexSize / 4;
                maxVertices = ((GLTFAccessor)glAccessors.first()).count;
                vertices = new float[maxVertices * vertexFloats];
                for (b = 0; b < bSize; ++b) {
                    boneAttribute = (VertexAttribute)bonesAttributes.get(b);
                    for (i = 0; i < maxVertices; ++i) {
                        vertices[i * vertexFloats + boneAttribute.offset / 4] = ((int[])bonesIndices.get(b / 4))[i * 4 + b % 4];
                        vertices[i * vertexFloats + boneAttribute.offset / 4 + 1] = ((float[])bonesWeights.get(b / 4))[i * 4 + b % 4];
                    }
                }
                for (i = 0; i < glAccessors.size; ++i) {
                    glAccessor = (GLTFAccessor)glAccessors.get(i);
                    attribute = (VertexAttribute)vertexAttributes.get(i);
                    if (glAccessor == null) continue;
                    if (glAccessor.bufferView == null) {
                        throw new GdxRuntimeException("bufferView is null (mesh compression ?)");
                    }
                    glBufferView = dataResolver.getBufferView(glAccessor.bufferView);
                    if (glBufferView.target != null && glBufferView.target != 34963 && glBufferView.target != 34962) {
                        throw new GdxRuntimeException("bufferView target unknown : " + glBufferView.target);
                    }
                    floatBuffer = dataResolver.getBufferFloat(glAccessor);
                    floatStride = (glBufferView.byteStride == null ? GLTFTypes.accessorStrideSize(glAccessor) : glBufferView.byteStride) / 4;
                    for (j = 0; j < glAccessor.count; ++j) {
                        floatBuffer.position(j * floatStride);
                        vIndex = j * vertexFloats + attribute.offset / 4;
                        floatBuffer.get(vertices, vIndex, attribute.numComponents);
                    }
                }
                if (!hasNormals) {
                    posOffset = attributesGroup.getOffset(1);
                    normalOffset = attributesGroup.getOffset(8);
                    stride = attributesGroup.vertexSize / 4;
                    vab = new Vector3();
                    vac = new Vector3();
                    index = 0;
                    while (index < maxIndices) {
                        vIndexA = indices[index++];
                        ax = vertices[vIndexA * stride + posOffset];
                        ay = vertices[vIndexA * stride + posOffset + 1];
                        az = vertices[vIndexA * stride + posOffset + 2];
                        vIndexB = indices[index++];
                        bx = vertices[vIndexB * stride + posOffset];
                        by = vertices[vIndexB * stride + posOffset + 1];
                        bz = vertices[vIndexB * stride + posOffset + 2];
                        vIndexC = indices[index++];
                        cx = vertices[vIndexC * stride + posOffset];
                        cy = vertices[vIndexC * stride + posOffset + 1];
                        cz = vertices[vIndexC * stride + posOffset + 2];
                        vab.set(bx, by, bz).sub(ax, ay, az);
                        vac.set(cx, cy, cz).sub(ax, ay, az);
                        n = vab.crs(vac).nor();
                        vertices[vIndexA * stride + normalOffset] = n.x;
                        vertices[vIndexA * stride + normalOffset + 1] = n.y;
                        vertices[vIndexA * stride + normalOffset + 2] = n.z;
                        vertices[vIndexB * stride + normalOffset] = n.x;
                        vertices[vIndexB * stride + normalOffset + 1] = n.y;
                        vertices[vIndexB * stride + normalOffset + 2] = n.z;
                        vertices[vIndexC * stride + normalOffset] = n.x;
                        vertices[vIndexC * stride + normalOffset + 1] = n.y;
                        vertices[vIndexC * stride + normalOffset + 2] = n.z;
                    }
                }
                mesh = new MeshPlus(true, maxVertices, maxIndices, attributesGroup);
                this.meshes.add((Object)mesh);
                mesh.setVertices(vertices);
                if (indices != null) {
                    mesh.setIndices(indices);
                }
                len = indices == null ? maxVertices : indices.length;
                meshPart = new MeshPart(glMesh.name, (Mesh)mesh, 0, len, GLTFTypes.mapPrimitiveMode(primitive.mode));
                nodePart = new NodePartPlus();
                nodePart.morphTargets = ((NodePlus)node).weights;
                nodePart.meshPart = meshPart;
                nodePart.material = primitive.material != null ? materialLoader.get(primitive.material) : materialLoader.getDefaultMaterial();
                parts.add((Object)nodePart);
            }
            this.meshMap.put((Object)glMesh, (Object)parts);
        }
        node.parts.addAll(parts);
    }

    private int parseAttributeUnit(String attributeName) {
        int lastUnderscoreIndex = attributeName.lastIndexOf(95);
        try {
            return Integer.parseInt(attributeName.substring(lastUnderscoreIndex + 1));
        }
        catch (NumberFormatException e) {
            throw new GLTFIllegalException("illegal attribute name " + attributeName);
        }
    }

    private short[] loadIndices(GLTFPrimitive primitive, DataResolver dataResolver) {
        short[] indices = null;
        if (primitive.indices != null) {
            GLTFAccessor indicesAccessor = dataResolver.getAccessor(primitive.indices);
            if (!indicesAccessor.type.equals("SCALAR")) {
                throw new GLTFIllegalException("indices accessor must be SCALAR but was " + indicesAccessor.type);
            }
            int maxIndices = indicesAccessor.count;
            indices = new short[maxIndices];
            switch (indicesAccessor.componentType) {
                case 5125: {
                    IntBuffer intBuffer = dataResolver.getBufferInt(indicesAccessor);
                    long maxIndex = 0L;
                    for (int i = 0; i < maxIndices; ++i) {
                        long index = (long)intBuffer.get() & 0xFFFFFFFFL;
                        maxIndex = Math.max(index, maxIndex);
                        indices[i] = (short)index;
                    }
                    this.checkMaxIndex(maxIndex);
                    break;
                }
                case 5122: 
                case 5123: {
                    int maxIndex;
                    dataResolver.getBufferShort(indicesAccessor).get(indices);
                    if (indicesAccessor.max != null) {
                        maxIndex = (int)indicesAccessor.max[0];
                    } else {
                        maxIndex = 0;
                        for (short i : indices) {
                            maxIndex = Math.max(maxIndex, i & 0xFFFF);
                        }
                    }
                    this.checkMaxIndex(maxIndex);
                    break;
                }
                case 5121: {
                    ByteBuffer byteBuffer = dataResolver.getBufferByte(indicesAccessor);
                    for (int i = 0; i < maxIndices; ++i) {
                        indices[i] = (short)(byteBuffer.get() & 0xFF);
                    }
                    break;
                }
                default: {
                    throw new GLTFIllegalException("illegal componentType " + indicesAccessor.componentType);
                }
            }
        }
        return indices;
    }

    public int getMaxBones() {
        return this.maxBones;
    }

    public Array<? extends Mesh> getMeshes() {
        return this.meshes;
    }

    private void checkMaxIndex(long maxIndex) {
        if (maxIndex >= 65536L) {
            throw new GLTFUnsupportedException("high index detected: " + maxIndex + ". Not supported");
        }
        if (maxIndex >= 32768L) {
            Gdx.app.error("GLTF", "high index detected: " + maxIndex + ". Unsigned short indices are supported but still experimental");
        }
    }
}

