/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.loaders.gltf;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import net.mgsx.gltf.data.GLTF;
import net.mgsx.gltf.data.texture.GLTFImage;
import net.mgsx.gltf.data.texture.GLTFSampler;
import net.mgsx.gltf.data.texture.GLTFTexture;
import net.mgsx.gltf.loaders.gltf.SeparatedDataFileResolver;
import net.mgsx.gltf.loaders.shared.GLTFLoaderBase;
import net.mgsx.gltf.loaders.shared.GLTFTypes;
import net.mgsx.gltf.loaders.shared.SceneAssetLoaderParameters;
import net.mgsx.gltf.loaders.shared.texture.ImageResolver;
import net.mgsx.gltf.loaders.shared.texture.TextureResolver;
import net.mgsx.gltf.scene3d.scene.SceneAsset;

public class GLTFAssetLoader
extends AsynchronousAssetLoader<SceneAsset, SceneAssetLoaderParameters> {
    private SeparatedDataFileResolver dataFileResolver;
    private ManagedTextureResolver textureResolver;

    public GLTFAssetLoader() {
        this((FileHandleResolver)new InternalFileHandleResolver());
    }

    public GLTFAssetLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public void loadAsync(AssetManager manager, String fileName, FileHandle file, SceneAssetLoaderParameters parameter) {
        this.textureResolver.fetch(manager);
    }

    public SceneAsset loadSync(AssetManager manager, String fileName, FileHandle file, SceneAssetLoaderParameters parameter) {
        boolean withData = parameter != null && parameter.withData;
        GLTFLoaderBase loader = new GLTFLoaderBase(this.textureResolver);
        SceneAsset sceneAsset = loader.load(this.dataFileResolver, withData);
        this.textureResolver = null;
        this.dataFileResolver = null;
        return sceneAsset;
    }

    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, SceneAssetLoaderParameters parameter) {
        Array deps = new Array();
        this.dataFileResolver = new SeparatedDataFileResolver();
        this.dataFileResolver.load(file);
        GLTF glModel = this.dataFileResolver.getRoot();
        this.textureResolver = new ManagedTextureResolver(glModel);
        this.textureResolver.getDependencies((Array<AssetDescriptor>)deps);
        return deps;
    }

    private class ManagedTextureResolver
    extends TextureResolver {
        private ObjectMap<Integer, AssetDescriptor<Texture>> textureDescriptorsSimple = new ObjectMap();
        private ObjectMap<Integer, AssetDescriptor<Texture>> textureDescriptorsMipMap = new ObjectMap();
        private GLTF glModel;

        public ManagedTextureResolver(GLTF glModel) {
            this.glModel = glModel;
        }

        @Override
        public void loadTextures(Array<GLTFTexture> glTextures, Array<GLTFSampler> glSamplers, ImageResolver imageResolver) {
        }

        public void fetch(AssetManager manager) {
            for (ObjectMap.Entry e : this.textureDescriptorsSimple) {
                this.texturesSimple.put(e.key, manager.get((AssetDescriptor)e.value));
            }
            for (ObjectMap.Entry e : this.textureDescriptorsMipMap) {
                this.texturesMipmap.put(e.key, manager.get((AssetDescriptor)e.value));
            }
        }

        public void getDependencies(Array<AssetDescriptor> deps) {
            this.glTextures = this.glModel.textures;
            this.glSamplers = this.glModel.samplers;
            if (this.glTextures != null) {
                for (int i = 0; i < this.glTextures.size; ++i) {
                    GLTFTexture glTexture = (GLTFTexture)this.glTextures.get(i);
                    GLTFImage glImage = (GLTFImage)this.glModel.images.get(glTexture.source.intValue());
                    FileHandle imageFile = GLTFAssetLoader.this.dataFileResolver.getImageFile(glImage);
                    TextureLoader.TextureParameter textureParameter = new TextureLoader.TextureParameter();
                    if (glTexture.sampler != null) {
                        GLTFSampler sampler = (GLTFSampler)this.glSamplers.get(glTexture.sampler.intValue());
                        if (GLTFTypes.isMipMapFilter(sampler)) {
                            textureParameter.genMipMaps = true;
                        }
                        GLTFTypes.mapTextureSampler(textureParameter, sampler);
                    } else {
                        GLTFTypes.mapTextureSampler(textureParameter);
                    }
                    AssetDescriptor assetDescriptor = new AssetDescriptor(imageFile, Texture.class, (AssetLoaderParameters)textureParameter);
                    deps.add((Object)assetDescriptor);
                    if (textureParameter.genMipMaps) {
                        this.textureDescriptorsMipMap.put((Object)glTexture.source, (Object)assetDescriptor);
                        continue;
                    }
                    this.textureDescriptorsSimple.put((Object)glTexture.source, (Object)assetDescriptor);
                }
            }
        }
    }
}

