/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.loaders.glb;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.LittleEndianInputStream;
import com.badlogic.gdx.utils.ObjectMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.mgsx.gltf.data.GLTF;
import net.mgsx.gltf.data.data.GLTFBufferView;
import net.mgsx.gltf.data.texture.GLTFImage;
import net.mgsx.gltf.loaders.exceptions.GLTFIllegalException;
import net.mgsx.gltf.loaders.shared.data.DataFileResolver;
import net.mgsx.gltf.loaders.shared.texture.PixmapBinaryLoaderHack;

public class BinaryDataFileResolver
implements DataFileResolver {
    private ObjectMap<Integer, ByteBuffer> bufferMap = new ObjectMap();
    private GLTF glModel;

    @Override
    public void load(FileHandle file) {
        this.load(file.read());
    }

    public void load(byte[] bytes) {
        this.load(new ByteArrayInputStream(bytes));
    }

    public void load(InputStream stream) {
        this.load(new LittleEndianInputStream(stream));
    }

    public void load(LittleEndianInputStream stream) {
        try {
            this.loadInternal(stream);
        }
        catch (IOException e) {
            throw new GdxRuntimeException((Throwable)e);
        }
    }

    private void loadInternal(LittleEndianInputStream stream) throws IOException {
        long magic = stream.readInt();
        if (magic != 1179937895L) {
            throw new GLTFIllegalException("bad magic");
        }
        int version = stream.readInt();
        if (version != 2) {
            throw new GLTFIllegalException("bad version");
        }
        long length = stream.readInt();
        String jsonData = null;
        int i = 12;
        while ((long)i < length) {
            int chunkLen = stream.readInt();
            int chunkType = stream.readInt();
            i += 8;
            if (chunkType == 1313821514) {
                byte[] data = new byte[chunkLen];
                stream.read(data, 0, chunkLen);
                jsonData = new String(data);
            } else if (chunkType == 5130562) {
                ByteBuffer bufferData = ByteBuffer.allocate(chunkLen);
                bufferData.order(ByteOrder.LITTLE_ENDIAN);
                for (int j = 0; j < chunkLen; ++j) {
                    bufferData.put(stream.readByte());
                }
                bufferData.flip();
                this.bufferMap.put((Object)this.bufferMap.size, (Object)bufferData);
            } else {
                Gdx.app.log("GLTF", "skip buffer type " + chunkType);
                if (chunkLen > 0) {
                    stream.skip((long)chunkLen);
                }
            }
            i += chunkLen;
        }
        this.glModel = (GLTF)new Json().fromJson(GLTF.class, jsonData);
    }

    @Override
    public GLTF getRoot() {
        return this.glModel;
    }

    @Override
    public ByteBuffer getBuffer(int buffer) {
        return (ByteBuffer)this.bufferMap.get((Object)buffer);
    }

    @Override
    public Pixmap load(GLTFImage glImage) {
        if (glImage.bufferView != null) {
            GLTFBufferView bufferView = (GLTFBufferView)this.glModel.bufferViews.get(glImage.bufferView.intValue());
            ByteBuffer buffer = (ByteBuffer)this.bufferMap.get((Object)bufferView.buffer);
            buffer.position(bufferView.byteOffset);
            byte[] data = new byte[bufferView.byteLength];
            buffer.get(data);
            return PixmapBinaryLoaderHack.load(data, 0, data.length);
        }
        throw new GLTFIllegalException("GLB image should have bufferView");
    }
}

