/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.exporters;

import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import net.mgsx.gltf.data.data.GLTFAccessor;
import net.mgsx.gltf.data.geometry.GLTFMorphTarget;
import net.mgsx.gltf.data.geometry.GLTFPrimitive;
import net.mgsx.gltf.exporters.GLTFExporter;

class GLTFMeshExporter {
    private final GLTFExporter base;
    private ObjectMap<Mesh, GLTFPrimitive> layouts = new ObjectMap();

    public GLTFMeshExporter(GLTFExporter base) {
        this.base = base;
    }

    GLTFPrimitive exportMeshPart(MeshPart meshPart) {
        Mesh mesh = meshPart.mesh;
        GLTFPrimitive primitive = new GLTFPrimitive();
        primitive.attributes = new ObjectMap();
        primitive.mode = GLTFMeshExporter.mapPrimitiveMode(meshPart.primitiveType);
        GLTFPrimitive layout = (GLTFPrimitive)this.layouts.get((Object)mesh);
        if (layout != null) {
            this.copyLayout(primitive, layout);
        } else {
            this.layouts.put((Object)mesh, (Object)primitive);
            this.exportMesh(primitive, mesh);
        }
        if (mesh.getNumIndices() > 0) {
            ShortBuffer outBuffer = this.base.binManager.beginShorts(meshPart.size);
            ShortBuffer inBuffer = mesh.getIndicesBuffer();
            if (meshPart.offset == 0 && meshPart.size == mesh.getNumIndices()) {
                outBuffer.put(mesh.getIndicesBuffer());
            } else {
                short[] localIndices = new short[meshPart.size];
                inBuffer.position(meshPart.offset);
                inBuffer.get(localIndices);
                outBuffer.put(localIndices);
            }
            inBuffer.rewind();
            GLTFAccessor accessor = this.base.obtainAccessor();
            accessor.type = "SCALAR";
            accessor.componentType = 5122;
            accessor.count = meshPart.size;
            accessor.bufferView = this.base.binManager.end();
            primitive.indices = this.base.root.accessors.size - 1;
        }
        return primitive;
    }

    private void copyLayout(GLTFPrimitive primitive, GLTFPrimitive layout) {
        primitive.attributes.putAll(layout.attributes);
        if (layout.targets != null) {
            primitive.targets = new Array();
            primitive.targets.addAll(layout.targets);
        }
    }

    private void exportMesh(GLTFPrimitive primitive, Mesh mesh) {
        ShortBuffer boneJointsBuffer;
        FloatBuffer vertices = mesh.getVerticesBuffer();
        Array boneWeightsBuffers = new Array();
        Array boneJointsBuffers = new Array();
        int stride = mesh.getVertexAttributes().vertexSize / 4;
        int numVertices = mesh.getNumVertices();
        for (VertexAttribute a : mesh.getVertexAttributes()) {
            int i;
            String accessorType;
            String attributeKey;
            boolean useTargets = false;
            if (a.usage == 1) {
                attributeKey = "POSITION";
                accessorType = "VEC3";
            } else if (a.usage == 8) {
                attributeKey = "NORMAL";
                accessorType = "VEC3";
            } else if (a.usage == 128) {
                attributeKey = "TANGENT";
                accessorType = "VEC3";
            } else if (a.usage == 2) {
                attributeKey = "COLOR_" + a.unit;
                accessorType = "VEC4";
            } else if (a.usage == 16) {
                attributeKey = "TEXCOORD_" + a.unit;
                accessorType = "VEC2";
            } else if (a.usage == 512) {
                attributeKey = "POSITION";
                accessorType = "VEC3";
                useTargets = true;
            } else if (a.usage == 1024) {
                attributeKey = "NORMAL";
                accessorType = "VEC3";
                useTargets = true;
            } else if (a.usage == 2048) {
                attributeKey = "TANGENT";
                accessorType = "VEC3";
                useTargets = true;
            } else {
                if (a.usage == 64) {
                    while (a.unit >= boneWeightsBuffers.size) {
                        boneWeightsBuffers.add(null);
                    }
                    while (a.unit >= boneJointsBuffers.size) {
                        boneJointsBuffers.add(null);
                    }
                    FloatBuffer boneWeightsBuffer = FloatBuffer.allocate(numVertices);
                    boneWeightsBuffers.set(a.unit, (Object)boneWeightsBuffer);
                    boneJointsBuffer = ShortBuffer.allocate(numVertices);
                    boneJointsBuffers.set(a.unit, (Object)boneJointsBuffer);
                    for (i = 0; i < numVertices; ++i) {
                        vertices.position(i * stride + a.offset / 4);
                        int boneID = (int)vertices.get();
                        short shortID = (short)(boneID & 0xFFFF);
                        float boneWeight = vertices.get();
                        boneWeightsBuffer.put(boneWeight);
                        boneJointsBuffer.put(shortID);
                    }
                    continue;
                }
                throw new GdxRuntimeException("unsupported vertex attribute " + a.alias);
            }
            GLTFAccessor accessor = this.base.obtainAccessor();
            accessor.type = accessorType;
            accessor.componentType = 5126;
            accessor.count = numVertices;
            if (useTargets) {
                if (primitive.targets == null) {
                    primitive.targets = new Array();
                }
                while (primitive.targets.size <= a.unit) {
                    primitive.targets.add((Object)new GLTFMorphTarget());
                }
                ((GLTFMorphTarget)((Object)primitive.targets.get(a.unit))).put(attributeKey, this.base.root.accessors.size - 1);
            } else {
                primitive.attributes.put((Object)attributeKey, (Object)(this.base.root.accessors.size - 1));
            }
            FloatBuffer outBuffer = this.base.binManager.beginFloats(numVertices * a.numComponents);
            for (i = 0; i < numVertices; ++i) {
                vertices.position(i * stride + a.offset / 4);
                for (int j = 0; j < a.numComponents; ++j) {
                    outBuffer.put(vertices.get());
                }
            }
            accessor.bufferView = this.base.binManager.end();
        }
        if (boneWeightsBuffers.size > 0) {
            GLTFAccessor accessor;
            int g;
            int numGroup = boneWeightsBuffers.size > 4 ? 2 : 1;
            for (g = 0; g < numGroup; ++g) {
                accessor = this.base.obtainAccessor();
                FloatBuffer outBuffer = this.base.binManager.beginFloats(numVertices * 4);
                for (int i = 0; i < numVertices; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        FloatBuffer boneWeightsBuffer = (FloatBuffer)boneWeightsBuffers.get(g * 4 + j);
                        if (boneWeightsBuffer != null) {
                            outBuffer.put(boneWeightsBuffer.get(i));
                            continue;
                        }
                        outBuffer.put(0.0f);
                    }
                }
                accessor.type = "VEC4";
                accessor.componentType = 5126;
                accessor.count = numVertices;
                accessor.bufferView = this.base.binManager.end();
                primitive.attributes.put((Object)("WEIGHTS_" + g), (Object)(this.base.root.accessors.size - 1));
            }
            for (g = 0; g < numGroup; ++g) {
                accessor = this.base.obtainAccessor();
                ShortBuffer soutBuffer = this.base.binManager.beginShorts(numVertices * 4);
                for (int i = 0; i < numVertices; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        boneJointsBuffer = (ShortBuffer)boneJointsBuffers.get(g * 4 + j);
                        if (boneJointsBuffer != null) {
                            soutBuffer.put(boneJointsBuffer.get(i));
                            continue;
                        }
                        soutBuffer.put((short)0);
                    }
                }
                accessor.type = "VEC4";
                accessor.componentType = 5123;
                accessor.count = numVertices;
                accessor.bufferView = this.base.binManager.end();
                primitive.attributes.put((Object)("JOINTS_" + g), (Object)(this.base.root.accessors.size - 1));
            }
        }
    }

    public static Integer mapPrimitiveMode(int type) {
        switch (type) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return null;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
        }
        throw new GdxRuntimeException("unsupported primitive type " + type);
    }
}

