/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.exporters;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.FloatAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.IntAttribute;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.utils.Array;
import net.mgsx.gltf.data.material.GLTFMaterial;
import net.mgsx.gltf.data.material.GLTFpbrMetallicRoughness;
import net.mgsx.gltf.data.texture.GLTFImage;
import net.mgsx.gltf.data.texture.GLTFNormalTextureInfo;
import net.mgsx.gltf.data.texture.GLTFOcclusionTextureInfo;
import net.mgsx.gltf.data.texture.GLTFSampler;
import net.mgsx.gltf.data.texture.GLTFTexture;
import net.mgsx.gltf.data.texture.GLTFTextureInfo;
import net.mgsx.gltf.exporters.GLTFExportTypes;
import net.mgsx.gltf.exporters.GLTFExporter;
import net.mgsx.gltf.scene3d.attributes.PBRColorAttribute;
import net.mgsx.gltf.scene3d.attributes.PBRFloatAttribute;
import net.mgsx.gltf.scene3d.attributes.PBRTextureAttribute;

class GLTFMaterialExporter {
    private final GLTFExporter base;

    public GLTFMaterialExporter(GLTFExporter base) {
        this.base = base;
    }

    public void export(Iterable<Node> nodes) {
        for (Node node : nodes) {
            for (NodePart nodePart : node.parts) {
                this.export(nodePart.material);
            }
            this.export(node.getChildren());
        }
    }

    private void export(Material material) {
        if (this.base.materialMapping.contains((Object)material, true)) {
            return;
        }
        this.base.materialMapping.add((Object)material);
        GLTFMaterial m = new GLTFMaterial();
        if (this.base.root.materials == null) {
            this.base.root.materials = new Array();
        }
        this.base.root.materials.add((Object)m);
        m.name = material.id;
        boolean blending = false;
        for (Attribute a : material) {
            if (a.type == ColorAttribute.Diffuse) {
                this.pbr((GLTFMaterial)m).baseColorFactor = GLTFExportTypes.rgba(this.defaultNull(Color.WHITE, (ColorAttribute)a));
                continue;
            }
            if (a.type == PBRColorAttribute.BaseColorFactor) {
                this.pbr((GLTFMaterial)m).baseColorFactor = GLTFExportTypes.rgba(this.defaultNull(Color.WHITE, (PBRColorAttribute)a));
                continue;
            }
            if (a.type == ColorAttribute.Emissive) {
                m.emissiveFactor = GLTFExportTypes.rgb(this.defaultNull(Color.BLACK, (ColorAttribute)a));
                continue;
            }
            if (a.type == BlendingAttribute.Type) {
                blending = true;
                continue;
            }
            if (a.type == IntAttribute.CullFace) {
                m.doubleSided = this.defaultNull(true, ((IntAttribute)a).value == 0);
                continue;
            }
            if (a.type == FloatAttribute.AlphaTest) {
                m.alphaCutoff = Float.valueOf(((FloatAttribute)a).value);
                continue;
            }
            if (a.type == PBRFloatAttribute.Metallic) {
                this.pbr((GLTFMaterial)m).metallicFactor = ((PBRFloatAttribute)a).value;
                continue;
            }
            if (a.type == PBRFloatAttribute.Roughness) {
                this.pbr((GLTFMaterial)m).roughnessFactor = ((PBRFloatAttribute)a).value;
                continue;
            }
            if (a.type == PBRTextureAttribute.BaseColorTexture) {
                this.pbr((GLTFMaterial)m).baseColorTexture = this.texture((PBRTextureAttribute)a);
                continue;
            }
            if (a.type == PBRTextureAttribute.MetallicRoughnessTexture) {
                this.pbr((GLTFMaterial)m).metallicRoughnessTexture = this.texture((PBRTextureAttribute)a);
                continue;
            }
            if (a.type == PBRTextureAttribute.EmissiveTexture) {
                m.emissiveTexture = this.texture((PBRTextureAttribute)a);
                continue;
            }
            if (a.type == PBRTextureAttribute.NormalTexture) {
                m.normalTexture = this.normalTexture((PBRTextureAttribute)a, material);
                continue;
            }
            if (a.type != PBRTextureAttribute.OcclusionTexture) continue;
            m.occlusionTexture = this.occlusionTexture((PBRTextureAttribute)a, material);
        }
        if (blending) {
            m.alphaMode = m.alphaCutoff != null ? "MASK" : "BLEND";
        }
    }

    private Boolean defaultNull(boolean defValue, boolean value) {
        return defValue == value ? null : Boolean.valueOf(value);
    }

    protected Color defaultNull(Color defaultColor, Color color) {
        return color.equals((Object)defaultColor) ? null : color;
    }

    private ColorAttribute defaultNull(Color defaultColor, ColorAttribute a) {
        return a.color.equals((Object)defaultColor) ? null : a;
    }

    private GLTFOcclusionTextureInfo occlusionTexture(PBRTextureAttribute a, Material material) {
        GLTFOcclusionTextureInfo ti = new GLTFOcclusionTextureInfo();
        ti.strength = ((PBRFloatAttribute)material.get(PBRFloatAttribute.class, (long)PBRFloatAttribute.OcclusionStrength)).value;
        ti.texCoord = a.uvIndex;
        ti.index = this.getTexture(a);
        return ti;
    }

    private GLTFNormalTextureInfo normalTexture(PBRTextureAttribute a, Material material) {
        GLTFNormalTextureInfo ti = new GLTFNormalTextureInfo();
        ti.scale = ((PBRFloatAttribute)material.get(PBRFloatAttribute.class, (long)PBRFloatAttribute.NormalScale)).value;
        ti.texCoord = a.uvIndex;
        ti.index = this.getTexture(a);
        return ti;
    }

    private GLTFTextureInfo texture(PBRTextureAttribute a) {
        GLTFTextureInfo ti = new GLTFTextureInfo();
        ti.texCoord = a.uvIndex;
        ti.index = this.getTexture(a);
        return ti;
    }

    private int getTexture(PBRTextureAttribute a) {
        GLTFTexture t = new GLTFTexture();
        t.sampler = this.sampler(a);
        t.source = this.source((Texture)a.textureDescription.texture);
        if (this.base.root.textures == null) {
            this.base.root.textures = new Array();
        }
        this.base.root.textures.add((Object)t);
        return this.base.root.textures.size - 1;
    }

    private Integer source(Texture texture) {
        int imageIndex = this.base.textureMapping.indexOf((Object)texture, true);
        if (imageIndex >= 0) {
            return imageIndex;
        }
        GLTFImage image = new GLTFImage();
        if (this.base.root.images == null) {
            this.base.root.images = new Array();
        }
        this.base.root.images.add((Object)image);
        this.base.textureMapping.add((Object)texture);
        this.base.binManager.export(image, texture, this.base.getImageName(texture));
        return this.base.root.images.size - 1;
    }

    private Integer sampler(PBRTextureAttribute a) {
        GLTFSampler sampler = new GLTFSampler();
        sampler.minFilter = this.mapMin(a.textureDescription.minFilter);
        sampler.magFilter = this.mapMag(a.textureDescription.magFilter);
        sampler.wrapS = this.map(a.textureDescription.uWrap);
        sampler.wrapT = this.map(a.textureDescription.vWrap);
        if (sampler.minFilter == null && sampler.magFilter == null && sampler.wrapS == null && sampler.wrapT == null) {
            return null;
        }
        if (this.base.root.samplers == null) {
            this.base.root.samplers = new Array();
        }
        this.base.root.samplers.add((Object)sampler);
        return this.base.root.samplers.size - 1;
    }

    private Integer map(Texture.TextureWrap wrap) {
        switch (wrap) {
            case ClampToEdge: {
                return 33071;
            }
            case MirroredRepeat: {
                return 33648;
            }
        }
        return null;
    }

    private Integer mapMag(Texture.TextureFilter filter) {
        switch (filter) {
            default: {
                return null;
            }
            case Nearest: 
        }
        return 9728;
    }

    private Integer mapMin(Texture.TextureFilter filter) {
        switch (filter) {
            default: {
                return null;
            }
            case MipMap: 
            case MipMapLinearLinear: {
                return 9987;
            }
            case MipMapLinearNearest: {
                return 9985;
            }
            case MipMapNearestLinear: {
                return 9986;
            }
            case MipMapNearestNearest: {
                return 9984;
            }
            case Nearest: 
        }
        return 9728;
    }

    private GLTFpbrMetallicRoughness pbr(GLTFMaterial m) {
        if (m.pbrMetallicRoughness == null) {
            m.pbrMetallicRoughness = new GLTFpbrMetallicRoughness();
        }
        return m.pbrMetallicRoughness;
    }
}

