/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.exporters;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import net.mgsx.gltf.data.camera.GLTFCamera;
import net.mgsx.gltf.data.camera.GLTFOrthographic;
import net.mgsx.gltf.data.camera.GLTFPerspective;
import net.mgsx.gltf.data.scene.GLTFNode;
import net.mgsx.gltf.exporters.GLTFExporter;

class GLTFCameraExporter {
    private GLTFExporter base;

    public GLTFCameraExporter(GLTFExporter base) {
        this.base = base;
    }

    public void export(ObjectMap<Node, Camera> cameras) {
        for (ObjectMap.Entry entry : cameras) {
            int nodeID = this.base.nodeMapping.indexOf(entry.key, true);
            if (nodeID < 0) {
                throw new GdxRuntimeException("node not found");
            }
            GLTFNode glNode = (GLTFNode)this.base.root.nodes.get(nodeID);
            if (this.base.root.cameras == null) {
                this.base.root.cameras = new Array();
            }
            glNode.camera = this.base.root.cameras.size;
            this.base.root.cameras.add((Object)this.export((Camera)entry.value));
        }
    }

    private GLTFCamera export(Camera camera) {
        GLTFCamera glCamera = new GLTFCamera();
        if (camera instanceof PerspectiveCamera) {
            PerspectiveCamera pcam = (PerspectiveCamera)camera;
            glCamera.type = "perspective";
            glCamera.perspective = new GLTFPerspective();
            glCamera.perspective.yfov = pcam.fieldOfView * ((float)Math.PI / 180);
            glCamera.perspective.znear = camera.near;
            glCamera.perspective.zfar = Float.valueOf(camera.far);
            glCamera.perspective.aspectRatio = Float.valueOf(camera.viewportWidth / camera.viewportHeight);
        } else if (camera instanceof OrthographicCamera) {
            OrthographicCamera ocam = (OrthographicCamera)camera;
            glCamera.type = "orthographic";
            glCamera.orthographic = new GLTFOrthographic();
            glCamera.orthographic.znear = Float.valueOf(camera.near);
            glCamera.orthographic.zfar = Float.valueOf(camera.far);
            glCamera.orthographic.xmag = Float.valueOf(camera.viewportWidth * ocam.zoom);
            glCamera.orthographic.ymag = Float.valueOf(camera.viewportHeight * ocam.zoom);
        } else {
            throw new GdxRuntimeException("unsupported camera type " + camera.getClass());
        }
        return glCamera;
    }
}

