/*
 * Decompiled with CFR 0.152.
 */
package com.github.mfathi91.time;

import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class MyUtils {
    private MyUtils() {
        throw new UnsupportedOperationException();
    }

    static boolean isBetween(int val, int lowerLimit, int upperLimit) {
        return val >= lowerLimit && val <= upperLimit;
    }

    static boolean isBetween(long val, long lowerLimit, long upperLimit) {
        return val >= lowerLimit && val <= upperLimit;
    }

    static int intRequireRange(int val, int lowerLimit, int upperLimit, String valName) {
        if (!MyUtils.isBetween(val, lowerLimit, upperLimit)) {
            throw new IllegalArgumentException(valName + " " + val + " is out of valid range [" + lowerLimit + ", " + upperLimit + "]");
        }
        return val;
    }

    static int intRequirePositive(int val, String valName) {
        if (val <= 0) {
            throw new IllegalArgumentException(valName + " is not positive: " + val);
        }
        return val;
    }

    static long longRequirePositive(long val, String valName) {
        if (val <= 0L) {
            throw new IllegalArgumentException(valName + " is not positive: " + val);
        }
        return val;
    }

    static long longRequireRange(long val, long lowerLimit, long upperLimit, String valName) {
        if (val < lowerLimit || val > upperLimit) {
            throw new IllegalArgumentException(valName + " " + val + " is out of valid range [" + lowerLimit + ", " + upperLimit + "]");
        }
        return val;
    }
}

