/*
 * Decompiled with CFR 0.152.
 */
package com.mehery.mchat;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.DownloadManager;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.util.Log;
import android.webkit.ConsoleMessage;
import android.webkit.CookieManager;
import android.webkit.MimeTypeMap;
import android.webkit.PermissionRequest;
import android.webkit.URLUtil;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.agrawalsuneet.dotsloader.loaders.LazyLoader;
import com.mehery.mchat.JsObject;
import com.mehery.mchat.OnComplete;
import com.mehery.mchat.PostMessageInterface;
import com.mehery.mchat.R;
import java.io.File;
import java.io.StringWriter;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class MChatWebActivity
extends AppCompatActivity
implements PostMessageInterface {
    WebView mywebview;
    String domain;
    String key;
    String id;
    int headerColor;
    String title;
    int resId;
    int titleColor;
    LazyLoader lazyLoader;
    int backgroundColor;
    int sentMessageBubbleColor;
    int receivedMessageBubbleColor;
    int sentMessageTextColor;
    int receivedMessageTextColor;
    int userInputBackgroundColor;
    int userInputTextColor;
    public ValueCallback<Uri[]> uploadMessage;
    private ValueCallback<Uri> mUploadMessage;
    public static final int REQUEST_SELECT_FILE = 100;
    private static final int FILECHOOSER_RESULTCODE = 1;
    OnComplete onComplete;
    private final int MY_PERMISSIONS_RECORD_AUDIO = 1;
    private final int MY_PERMISSIONS_READ_EXTERNAL_STORAGE = 2;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_m_chat_web);
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.RECORD_AUDIO") != 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.RECORD_AUDIO"}, (int)1);
        }
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.READ_EXTERNAL_STORAGE") != 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, (int)2);
        }
        this.onComplete = new OnComplete();
        this.lazyLoader = (LazyLoader)this.findViewById(R.id.loaderView);
        this.lazyLoader.setVisibility(0);
        this.mywebview = (WebView)this.findViewById(R.id.webView);
        RelativeLayout headerLayout = (RelativeLayout)this.findViewById(R.id.headerLayout);
        ImageView chatImage = (ImageView)this.findViewById(R.id.chatImage);
        TextView headerTitle = (TextView)this.findViewById(R.id.headerTitle);
        this.headerColor = this.getIntent().getExtras().getInt("headerColor");
        this.title = this.getIntent().getExtras().getString("title");
        this.resId = this.getIntent().getExtras().getInt("resId");
        this.titleColor = this.getIntent().getExtras().getInt("titleColor");
        if (this.getIntent().hasExtra("backgroundColor")) {
            this.backgroundColor = this.getIntent().getExtras().getInt("backgroundColor");
        }
        if (this.getIntent().hasExtra("sentMessageBubbleColor")) {
            this.sentMessageBubbleColor = this.getIntent().getExtras().getInt("sentMessageBubbleColor");
        }
        if (this.getIntent().hasExtra("receivedMessageBubbleColor")) {
            this.receivedMessageBubbleColor = this.getIntent().getExtras().getInt("receivedMessageBubbleColor");
        }
        if (this.getIntent().hasExtra("sentMessageTextColor")) {
            this.sentMessageTextColor = this.getIntent().getExtras().getInt("sentMessageTextColor");
        }
        if (this.getIntent().hasExtra("receivedMessageTextColor")) {
            this.receivedMessageTextColor = this.getIntent().getExtras().getInt("receivedMessageTextColor");
        }
        if (this.getIntent().hasExtra("userInputBackgroundColor")) {
            this.userInputBackgroundColor = this.getIntent().getExtras().getInt("userInputBackgroundColor");
        }
        if (this.getIntent().hasExtra("userInputTextColor")) {
            this.userInputTextColor = this.getIntent().getExtras().getInt("userInputTextColor");
        }
        Log.e((String)"HeaderColor", (String)String.valueOf(this.headerColor));
        headerLayout.setBackgroundColor(this.headerColor);
        chatImage.setImageDrawable(this.getResources().getDrawable(this.resId));
        headerTitle.setText((CharSequence)this.title);
        headerTitle.setTextColor(this.titleColor);
        this.domain = this.getIntent().getExtras().getString("domain");
        this.key = this.getIntent().getExtras().getString("key");
        this.id = this.getIntent().getExtras().getString("id");
        this.mywebview.setWebChromeClient(new WebChromeClient());
        this.mywebview.clearCache(true);
        this.mywebview.clearHistory();
        this.mywebview.getSettings().setJavaScriptEnabled(true);
        this.mywebview.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        this.mywebview.getSettings().setDomStorageEnabled(true);
        this.mywebview.getSettings().setLoadsImagesAutomatically(true);
        this.mywebview.getSettings().setJavaScriptEnabled(true);
        this.mywebview.getSettings().setDomStorageEnabled(true);
        this.mywebview.getSettings().setAppCacheEnabled(true);
        this.mywebview.getSettings().setDomStorageEnabled(true);
        this.mywebview.getSettings().setAllowContentAccess(true);
        this.mywebview.getSettings().setAllowFileAccess(true);
        if (Build.VERSION.SDK_INT >= 26) {
            this.mywebview.getSettings().setSafeBrowsingEnabled(false);
            this.mywebview.getSettings().setMixedContentMode(0);
        }
        this.mywebview.setScrollBarStyle(0);
        if (Build.VERSION.SDK_INT >= 21) {
            CookieManager.getInstance().setAcceptThirdPartyCookies(this.mywebview, true);
        }
        this.mywebview.getSettings().setAllowContentAccess(true);
        this.mywebview.getSettings().setAllowFileAccess(true);
        this.mywebview.getSettings().setBlockNetworkImage(false);
        this.mywebview.getSettings().setLoadWithOverviewMode(true);
        this.mywebview.getSettings().setUseWideViewPort(true);
        this.mywebview.getSettings().setUseWideViewPort(true);
        this.mywebview.getSettings().setAllowUniversalAccessFromFileURLs(true);
        this.mywebview.getSettings().setAllowFileAccessFromFileURLs(true);
        this.mywebview.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        HashMap headerMap = new HashMap();
        String ua = new WebView((Context)this).getSettings().getUserAgentString();
        this.mywebview.getSettings().setUserAgentString(ua + "WebViewApp");
        this.mywebview.setWebChromeClient(new WebChromeClient(){

            public void onPermissionRequest(PermissionRequest request) {
                MChatWebActivity.this.runOnUiThread(() -> {
                    if (Build.VERSION.SDK_INT >= 21) {
                        request.grant(request.getResources());
                    }
                });
            }

            public void onPermissionRequestCanceled(PermissionRequest request) {
                super.onPermissionRequestCanceled(request);
            }

            protected void openFileChooser(ValueCallback uploadMsg, String acceptType) {
                MChatWebActivity.this.mUploadMessage = uploadMsg;
                Intent i = new Intent("android.intent.action.GET_CONTENT");
                i.addCategory("android.intent.category.OPENABLE");
                i.setType("image/*");
                MChatWebActivity.this.startActivityForResult(Intent.createChooser((Intent)i, (CharSequence)"File Chooser"), 1);
            }

            @TargetApi(value=21)
            public boolean onShowFileChooser(WebView mWebView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
                if (MChatWebActivity.this.uploadMessage != null) {
                    MChatWebActivity.this.uploadMessage.onReceiveValue(null);
                    MChatWebActivity.this.uploadMessage = null;
                }
                MChatWebActivity.this.uploadMessage = filePathCallback;
                Intent intent = fileChooserParams.createIntent();
                try {
                    MChatWebActivity.this.startActivityForResult(intent, 100);
                }
                catch (ActivityNotFoundException e) {
                    MChatWebActivity.this.uploadMessage = null;
                    Toast.makeText((Context)MChatWebActivity.this, (CharSequence)"Cannot Open File Chooser", (int)1).show();
                    return false;
                }
                return true;
            }

            protected void openFileChooser(ValueCallback<Uri> uploadMsg, String acceptType, String capture) {
                MChatWebActivity.this.mUploadMessage = uploadMsg;
                Intent intent = new Intent("android.intent.action.GET_CONTENT");
                intent.addCategory("android.intent.category.OPENABLE");
                intent.setType("image/*");
                MChatWebActivity.this.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)"File Chooser"), 1);
            }

            protected void openFileChooser(ValueCallback<Uri> uploadMsg) {
                MChatWebActivity.this.mUploadMessage = uploadMsg;
                Intent i = new Intent("android.intent.action.GET_CONTENT");
                i.addCategory("android.intent.category.OPENABLE");
                i.setType("image/*");
                MChatWebActivity.this.startActivityForResult(Intent.createChooser((Intent)i, (CharSequence)"File Chooser"), 1);
            }

            public boolean onConsoleMessage(ConsoleMessage cm) {
                this.onConsoleMessage(cm.message(), cm.lineNumber(), cm.sourceId());
                return true;
            }

            public void onConsoleMessage(String message, int lineNumber, String sourceID) {
            }
        });
        this.mywebview.getSettings().setMediaPlaybackRequiresUserGesture(false);
        this.mywebview.getSettings().setMixedContentMode(0);
        this.mywebview.loadUrl("https://" + this.domain + "/postman/ext/plugin/customer/app/chat/");
        this.setPostMessgeListener(this.mywebview);
    }

    protected void onPause() {
        super.onPause();
        this.unregisterReceiver(this.onComplete);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        if (Build.VERSION.SDK_INT >= 21) {
            if (requestCode == 100) {
                if (this.uploadMessage == null) {
                    return;
                }
                this.uploadMessage.onReceiveValue((Object)WebChromeClient.FileChooserParams.parseResult((int)resultCode, (Intent)intent));
                this.uploadMessage = null;
            }
        } else if (requestCode == 1) {
            if (null == this.mUploadMessage) {
                return;
            }
            Uri result = intent == null || resultCode != -1 ? null : intent.getData();
            this.mUploadMessage.onReceiveValue((Object)result);
            this.mUploadMessage = null;
        } else {
            Toast.makeText((Context)this, (CharSequence)"Failed to Upload Image", (int)1).show();
        }
    }

    void setPostMessgeListener(final WebView webView) {
        webView.addJavascriptInterface((Object)new JsObject(this::postMessageReceived), "Android");
        webView.setWebViewClient(new WebViewClient(){

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                webView.loadUrl("javascript:(function() {function receiveMessage(event) {\nAndroid.receiveMessage(JSON.stringify(event.data));\n}window.addEventListener(\"message\", receiveMessage, false);})()");
                Log.i((String)"TAG", (String)("onPageStarted " + url));
            }
        });
    }

    protected void onResume() {
        super.onResume();
        this.registerReceiver(this.onComplete, new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"));
    }

    protected void onStop() {
        super.onStop();
    }

    void evaluateScript(final WebView webView, final String script) {
        webView.post(new Runnable(){

            @Override
            public void run() {
                webView.evaluateJavascript(script, (ValueCallback)new ValueCallback<String>(){

                    public void onReceiveValue(String s) {
                        Log.d((String)"CALLBACK", (String)s);
                    }
                });
            }
        });
    }

    public static String escape(CharSequence text) {
        if (text == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        int length = text.length();
        block4: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\"': {
                    writer.write("\\\"");
                    continue block4;
                }
                case '\\': {
                    writer.write("\\\\");
                    continue block4;
                }
                default: {
                    if (c > '\u001f') {
                        writer.write(c);
                        continue block4;
                    }
                    writer.write("\\u");
                    String hex = "000" + Integer.toHexString(c);
                    writer.write(hex.substring(hex.length() - 4));
                }
            }
        }
        return writer.toString();
    }

    @Override
    public void postMessageReceived(String data) {
        Log.i((String)"JsObject", (String)("postMessage data=" + data));
        if (data.contains("DOWNLOAD_FILE")) {
            try {
                String url;
                data = data.replace("\\\"", "\"");
                data = data.substring(data.indexOf("{"), data.lastIndexOf("}") + 1);
                JSONObject obj = new JSONObject(data);
                JSONObject myChatEventObject = obj.optJSONObject("myChatEvent");
                if (myChatEventObject != null && (url = myChatEventObject.optString("url")) != null) {
                    Log.e((String)"URL", (String)url);
                    DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)url));
                    request.setTitle((CharSequence)"Downloading...");
                    request.setNotificationVisibility(1);
                    String nameOfFile = URLUtil.guessFileName((String)url, null, (String)MimeTypeMap.getFileExtensionFromUrl((String)url));
                    File f = new File(Environment.DIRECTORY_PICTURES);
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                    request.setDestinationInExternalPublicDir(Environment.DIRECTORY_PICTURES, nameOfFile);
                    DownloadManager downloadManager = (DownloadManager)this.getSystemService("download");
                    downloadManager.enqueue(request);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (data.contains("ON_CHAT_LOAD")) {
            Log.e((String)"ADDED ONCHAT", (String)"ONCHAT");
            String config = "{";
            config = config + "\"header.disabled\" : true";
            config = config + ",\"launcher.open\" : true";
            if (this.backgroundColor != 0) {
                config = config + ",\"messageList.bg.color\" : \"" + String.format("#%06X", 0xFFFFFF & this.backgroundColor) + "\"";
            }
            if (this.sentMessageBubbleColor != 0) {
                config = config + ",\"sentMessage.bg.color\" : \"" + String.format("#%06X", 0xFFFFFF & this.sentMessageBubbleColor) + "\"";
            }
            if (this.sentMessageTextColor != 0) {
                config = config + ",\"sentMessage.text.color\" : \"" + String.format("#%06X", 0xFFFFFF & this.sentMessageTextColor) + "\"";
            }
            if (this.receivedMessageBubbleColor != 0) {
                config = config + ",\"receivedMessage.bg.color\" : \"" + String.format("#%06X", 0xFFFFFF & this.receivedMessageBubbleColor) + "\"";
            }
            if (this.receivedMessageTextColor != 0) {
                config = config + ",\"receivedMessage.text.color\" : \"" + String.format("#%06X", 0xFFFFFF & this.receivedMessageTextColor) + "\"";
            }
            if (this.userInputBackgroundColor != 0) {
                config = config + ",\"userInput.bg.color\" : \"" + String.format("#%06X", 0xFFFFFF & this.userInputBackgroundColor) + "\"";
            }
            if (this.userInputTextColor != 0) {
                config = config + ",\"userInput.text.color\" : \"" + String.format("#%06X", 0xFFFFFF & this.userInputTextColor) + "\"";
            }
            config = config + "}";
            Log.e((String)"Config", (String)config);
            String options = "{event : \"SET_OPTIONS\" , options : {\"domain\" : \"" + this.domain + "\", \"channelId\" : \"" + this.id + "\", \"channelKey\" : \"" + this.key + "\" , \"config\" : " + config + "}}";
            Log.e((String)"OPTIONS", (String)options);
            this.evaluateScript(this.mywebview, "javascript: callMobileEventListener(" + options + ");");
        } else if (data.contains("ON_CHAT_TOGGLE")) {
            this.lazyLoader.setVisibility(8);
        }
    }
}

