/*
 * Decompiled with CFR 0.152.
 */
package com.github.megatronking.stringfog.aescbc;

import com.github.megatronking.stringfog.Base64;
import com.github.megatronking.stringfog.IStringFog;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class StringFogImpl
implements IStringFog {
    private static final int KEY_LENGTH = 16;
    private static final String AES_ALGORITHM = "AES";
    private static final String TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final String IV = "1234123412341234";
    private static final String CHARSET_NAME_UTF_8 = "UTF-8";
    private String mEncryptedKey;
    private Cipher mEncryptedCipher;
    private String mDecryptedKey;
    private Cipher mDecryptedCipher;

    public String encrypt(String data, String key) {
        if (key == null) {
            throw new IllegalArgumentException("Invalid AES key length: 0 bytes");
        }
        if (key.length() != 16) {
            throw new IllegalArgumentException("Invalid AES key length: " + key.length() + " bytes");
        }
        this.initAESEncryptCipherIfNecessary(key);
        if (this.mEncryptedCipher == null) {
            return data;
        }
        try {
            byte[] raw = data.getBytes(CHARSET_NAME_UTF_8);
            return new String(Base64.encode((byte[])this.mEncryptedCipher.doFinal(raw), (int)2), CHARSET_NAME_UTF_8);
        }
        catch (UnsupportedEncodingException | BadPaddingException | IllegalBlockSizeException e) {
            return data;
        }
    }

    public String decrypt(String data, String key) {
        if (key == null) {
            throw new IllegalArgumentException("Invalid AES key length: 0 bytes");
        }
        if (key.length() != 16) {
            throw new IllegalArgumentException("Invalid AES key length: " + key.length() + " bytes");
        }
        this.initAESDecryptCipherIfNecessary(key);
        if (this.mDecryptedCipher == null) {
            return data;
        }
        try {
            byte[] raw = data.getBytes(CHARSET_NAME_UTF_8);
            return new String(this.mDecryptedCipher.doFinal(Base64.decode((byte[])raw, (int)2)), CHARSET_NAME_UTF_8);
        }
        catch (UnsupportedEncodingException | BadPaddingException | IllegalBlockSizeException e) {
            return data;
        }
    }

    public boolean overflow(String data, String key) {
        return data.length() * 4 / 3 >= Short.MAX_VALUE;
    }

    private void initAESEncryptCipherIfNecessary(String key) {
        if (this.mEncryptedKey == null || !this.mEncryptedKey.equals(key)) {
            try {
                SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(CHARSET_NAME_UTF_8), AES_ALGORITHM);
                IvParameterSpec ivSpec = new IvParameterSpec(IV.getBytes(CHARSET_NAME_UTF_8));
                this.mEncryptedCipher = Cipher.getInstance(TRANSFORMATION);
                this.mEncryptedCipher.init(1, (Key)keySpec, ivSpec);
                this.mEncryptedKey = key;
            }
            catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                this.mDecryptedCipher = null;
                this.mDecryptedKey = null;
            }
        }
    }

    private void initAESDecryptCipherIfNecessary(String key) {
        if (this.mDecryptedKey == null || !this.mDecryptedKey.equals(key)) {
            try {
                SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(CHARSET_NAME_UTF_8), AES_ALGORITHM);
                IvParameterSpec ivSpec = new IvParameterSpec(IV.getBytes(CHARSET_NAME_UTF_8));
                this.mDecryptedCipher = Cipher.getInstance(TRANSFORMATION);
                this.mDecryptedCipher.init(2, (Key)keySpec, ivSpec);
                this.mDecryptedKey = key;
            }
            catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                this.mDecryptedCipher = null;
                this.mDecryptedKey = null;
            }
        }
    }
}

