/*
 * Decompiled with CFR 0.152.
 */
package mehdi.sakout.fancybuttons;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TableLayout;
import android.widget.TextView;
import java.util.ArrayList;
import mehdi.sakout.fancybuttons.R;

public class FancyButton
extends LinearLayout {
    private Context mContext;
    private int mDefaultBackgroundColor = -16777216;
    private int mFocusBackgroundColor = 0;
    private int mDefaultTextColor = -1;
    private int mDefaultTextSize = 15;
    private String mText = null;
    private Drawable mIconResource = null;
    private int mFontIconSize = 15;
    private String mFontIcon = null;
    private int mIconPosition = 1;
    private int mBorderColor = 0;
    private int mBorderWidth = 0;
    private int mRadius = 0;
    private Typeface mTextTypeFace = null;
    private Typeface mIconTypeFace = null;
    public static final int POSITION_LEFT = 1;
    public static final int POSITION_RIGHT = 2;
    public static final int POSITION_TOP = 3;
    public static final int POSITION_BOTTOM = 4;
    private String mDefaultIconFont = "fontawesome.ttf";
    private String mDefaultTextFont = "robotoregular.ttf";
    private ImageView mIconView;
    private TextView mFontIconView;
    private TextView mTextView;

    public FancyButton(Context context) {
        super(context);
        this.mContext = context;
        this.mTextTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)String.format("fonts/%s", this.mDefaultTextFont));
        this.mIconTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)String.format("iconfonts/%s", this.mDefaultIconFont));
        this.init();
    }

    private void init() {
        this.initContainer();
        this.mTextView = this.setupTextView();
        this.mIconView = this.setupIconView();
        this.mFontIconView = this.setupFontIconView();
        if (this.mIconView == null && this.mFontIconView == null && this.mTextView == null) {
            Button tempTextView = new Button(this.mContext);
            tempTextView.setText((CharSequence)"Fancy Button");
            this.addView((View)tempTextView);
        } else {
            this.removeAllViews();
            this.setupBackground();
            ArrayList<Object> views = new ArrayList<Object>();
            if (this.mIconPosition == 1 || this.mIconPosition == 3) {
                if (this.mIconView != null) {
                    views.add(this.mIconView);
                }
                if (this.mFontIconView != null) {
                    views.add(this.mFontIconView);
                }
                if (this.mTextView != null) {
                    views.add(this.mTextView);
                }
            } else {
                if (this.mTextView != null) {
                    views.add(this.mTextView);
                }
                if (this.mIconView != null) {
                    views.add(this.mIconView);
                }
                if (this.mFontIconView != null) {
                    views.add(this.mFontIconView);
                }
            }
            for (View view : views) {
                this.addView(view);
            }
        }
    }

    public FancyButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        TypedArray attrsArray = context.obtainStyledAttributes(attrs, R.styleable.FancyButtonsAttrs, 0, 0);
        this.initAttributs(attrsArray);
        attrsArray.recycle();
        this.init();
    }

    private TextView setupTextView() {
        if (this.mText != null) {
            TextView textView = new TextView(this.mContext);
            textView.setText((CharSequence)this.mText);
            textView.setGravity(17);
            textView.setTextColor(this.mDefaultTextColor);
            textView.setTextSize((float)this.mDefaultTextSize);
            textView.setLayoutParams((ViewGroup.LayoutParams)new TableLayout.LayoutParams(-1, -2, 1.0f));
            if (!this.isInEditMode() && this.mTextTypeFace != null) {
                textView.setTypeface(this.mTextTypeFace);
            }
            return textView;
        }
        return null;
    }

    private TextView setupFontIconView() {
        if (this.mFontIcon != null) {
            TextView fontIconView = new TextView(this.mContext);
            fontIconView.setTextColor(this.mDefaultTextColor);
            LinearLayout.LayoutParams iconTextViewParams = new LinearLayout.LayoutParams(-1, -2, 1.0f);
            if (this.mTextView != null) {
                iconTextViewParams.rightMargin = 10;
                iconTextViewParams.leftMargin = 10;
                if (this.mIconPosition == 3 || this.mIconPosition == 4) {
                    iconTextViewParams.gravity = 17;
                    fontIconView.setGravity(17);
                } else {
                    fontIconView.setGravity(16);
                    iconTextViewParams.gravity = 16;
                }
            } else {
                iconTextViewParams.gravity = 17;
                fontIconView.setGravity(16);
            }
            fontIconView.setLayoutParams((ViewGroup.LayoutParams)iconTextViewParams);
            if (!this.isInEditMode()) {
                fontIconView.setTextSize((float)this.mFontIconSize);
                fontIconView.setText((CharSequence)this.mFontIcon);
                fontIconView.setTypeface(this.mIconTypeFace);
            } else {
                fontIconView.setText((CharSequence)"O");
            }
            return fontIconView;
        }
        return null;
    }

    private ImageView setupIconView() {
        if (this.mIconResource != null) {
            ImageView iconView = new ImageView(this.mContext);
            iconView.setImageDrawable(this.mIconResource);
            LinearLayout.LayoutParams iconViewParams = new LinearLayout.LayoutParams(-2, -2);
            if (this.mTextView != null) {
                iconViewParams.gravity = this.mIconPosition == 3 || this.mIconPosition == 4 ? 17 : 3;
                iconViewParams.rightMargin = 10;
                iconViewParams.leftMargin = 10;
            } else {
                iconViewParams.gravity = 16;
            }
            iconView.setLayoutParams((ViewGroup.LayoutParams)iconViewParams);
            return iconView;
        }
        return null;
    }

    private void initAttributs(TypedArray attrsArray) {
        this.mDefaultBackgroundColor = attrsArray.getColor(0, this.mDefaultBackgroundColor);
        this.mFocusBackgroundColor = attrsArray.getColor(12, this.mFocusBackgroundColor);
        this.mDefaultTextColor = attrsArray.getColor(2, this.mDefaultTextColor);
        this.mDefaultTextSize = (int)attrsArray.getDimension(5, (float)this.mDefaultTextSize);
        this.mBorderColor = attrsArray.getColor(10, this.mBorderColor);
        this.mBorderWidth = (int)attrsArray.getDimension(11, (float)this.mBorderWidth);
        this.mRadius = (int)attrsArray.getDimension(13, (float)this.mRadius);
        this.mFontIconSize = (int)attrsArray.getDimension(8, (float)this.mFontIconSize);
        String text = attrsArray.getString(1);
        this.mIconPosition = attrsArray.getInt(9, this.mIconPosition);
        String fontIcon = attrsArray.getString(7);
        String iconFontFamily = attrsArray.getString(4);
        String textFontFamily = attrsArray.getString(3);
        Object icon = null;
        try {
            this.mIconResource = attrsArray.getDrawable(6);
        }
        catch (Exception e) {
            this.mIconResource = null;
        }
        if (fontIcon != null) {
            this.mFontIcon = fontIcon;
        }
        if (text != null) {
            this.mText = text;
        }
        if (!this.isInEditMode()) {
            if (iconFontFamily != null) {
                try {
                    this.mIconTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)String.format("iconfonts/%s", iconFontFamily));
                }
                catch (Exception e) {
                    Log.e((String)"Fancy", (String)e.getMessage());
                    this.mIconTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)String.format("iconfonts/%s", this.mDefaultIconFont));
                }
            } else {
                this.mIconTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)String.format("iconfonts/%s", this.mDefaultIconFont));
            }
            if (textFontFamily != null) {
                try {
                    this.mTextTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)String.format("fonts/%s", textFontFamily));
                }
                catch (Exception e) {
                    this.mTextTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)String.format("fonts/%s", this.mDefaultTextFont));
                }
            } else {
                this.mTextTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)String.format("fonts/%s", this.mDefaultTextFont));
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    private void setupBackground() {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setCornerRadius((float)this.mRadius);
        drawable.setColor(this.mDefaultBackgroundColor);
        if (this.mBorderColor != 0) {
            drawable.setStroke(this.mBorderWidth, this.mBorderColor);
        }
        GradientDrawable drawable2 = new GradientDrawable();
        drawable2.setCornerRadius((float)this.mRadius);
        drawable2.setColor(this.mFocusBackgroundColor);
        if (this.mBorderColor != 0) {
            drawable2.setStroke(this.mBorderWidth, this.mBorderColor);
        }
        StateListDrawable states = new StateListDrawable();
        if (this.mFocusBackgroundColor != 0) {
            states.addState(new int[]{16842919}, (Drawable)drawable2);
            states.addState(new int[]{16842908}, (Drawable)drawable2);
        }
        states.addState(new int[0], (Drawable)drawable);
        if (Build.VERSION.SDK_INT < 16) {
            this.setBackgroundDrawable((Drawable)states);
        } else {
            this.setBackground((Drawable)states);
        }
    }

    private void initContainer() {
        if (this.mIconPosition == 3 || this.mIconPosition == 4) {
            this.setOrientation(1);
        } else {
            this.setOrientation(0);
        }
        LinearLayout.LayoutParams containerParams = new LinearLayout.LayoutParams(-2, -2);
        this.setLayoutParams((ViewGroup.LayoutParams)containerParams);
        this.setGravity(16);
        this.setClickable(true);
        this.setFocusable(true);
        if (this.mIconResource == null && this.mFontIcon == null && this.getPaddingLeft() == 0 && this.getPaddingRight() == 0 && this.getPaddingTop() == 0 && this.getPaddingBottom() == 0) {
            this.setPadding(20, 20, 20, 20);
        }
    }

    public void setText(String text) {
        this.mText = text;
        if (this.mTextView == null) {
            this.init();
        } else {
            this.mTextView.setText((CharSequence)text);
        }
    }

    public void setTextColor(int color) {
        this.mDefaultTextColor = color;
        if (this.mTextView == null) {
            this.init();
        } else {
            this.mTextView.setTextColor(color);
        }
    }

    public void setBackgroundColor(int color) {
        this.mDefaultBackgroundColor = color;
        if (this.mIconView != null || this.mFontIconView != null || this.mTextView != null) {
            this.setupBackground();
        }
    }

    public void setFocusBackgroundColor(int color) {
        this.mFocusBackgroundColor = color;
        if (this.mIconView != null || this.mFontIconView != null || this.mTextView != null) {
            this.setupBackground();
        }
    }

    public void setTextSize(int textSize) {
        this.mDefaultTextSize = textSize;
        if (this.mTextView != null) {
            this.mTextView.setTextSize((float)textSize);
        }
    }

    public void setIconResource(int drawable) {
        this.mIconResource = this.mContext.getResources().getDrawable(drawable);
        if (this.mIconView == null || this.mFontIconView != null) {
            this.mFontIconView = null;
            this.init();
        } else {
            this.mIconView.setImageDrawable(this.mIconResource);
        }
    }

    public void setIconResource(String icon) {
        this.mFontIcon = icon;
        if (this.mFontIconView == null) {
            this.mIconView = null;
            this.init();
        } else {
            this.mFontIconView.setText((CharSequence)icon);
        }
    }

    public void setFontIconSize(int iconSize) {
        this.mFontIconSize = iconSize;
        if (this.mFontIconView != null) {
            this.mFontIconView.setTextSize((float)iconSize);
        }
    }

    public void setIconPosition(int position) {
        this.mIconPosition = position > 0 && position < 5 ? position : 1;
        this.init();
    }

    public void setBorderColor(int color) {
        this.mBorderColor = color;
        if (this.mIconView != null || this.mFontIconView != null || this.mTextView != null) {
            this.setupBackground();
        }
    }

    public void setBorderWidth(int width) {
        this.mBorderWidth = width;
        if (this.mIconView != null || this.mFontIconView != null || this.mTextView != null) {
            this.setupBackground();
        }
    }

    public void setRadius(int radius) {
        this.mRadius = radius;
        if (this.mIconView != null || this.mFontIconView != null || this.mTextView != null) {
            this.setupBackground();
        }
    }

    public void setCustomTextFont(String fontName) {
        try {
            this.mTextTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)String.format("fonts/%s", fontName));
        }
        catch (Exception e) {
            Log.e((String)"FancyButtons", (String)e.getMessage());
            this.mTextTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)String.format("fonts/%s", this.mDefaultTextFont));
        }
        if (this.mTextView == null) {
            this.init();
        } else {
            this.mTextView.setTypeface(this.mTextTypeFace);
        }
    }

    public void setCustomIconFont(String fontName) {
        try {
            this.mIconTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)String.format("iconfonts/%s", fontName));
        }
        catch (Exception e) {
            Log.e((String)"FancyButtons", (String)e.getMessage());
            this.mIconTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)String.format("iconfonts/%s", this.mDefaultIconFont));
        }
        if (this.mFontIconView == null) {
            this.init();
        } else {
            this.mFontIconView.setTypeface(this.mIconTypeFace);
        }
    }
}

