/*
 * Decompiled with CFR 0.152.
 */
package mehdi.sakout.aboutpage;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.widget.TextViewCompat;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import mehdi.sakout.aboutpage.AboutPageUtils;
import mehdi.sakout.aboutpage.Element;
import mehdi.sakout.aboutpage.R;

public class AboutPage {
    private final Context mContext;
    private final LayoutInflater mInflater;
    private final View mView;
    private CharSequence mDescription;
    private int mImage = 0;
    private boolean mIsRTL = false;
    private Typeface mCustomFont;
    private Boolean mEnableDarkMode = false;
    private int mBackgroundColor;
    private int mIconColor;
    private int mTextColor;
    private int mSeparatorColor;

    public AboutPage(Context context) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)context);
        this.mView = this.mInflater.inflate(R.layout.about_page, null);
        this.enableDarkMode(false);
    }

    public AboutPage setCustomFont(String path) {
        this.mCustomFont = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)path);
        return this;
    }

    public AboutPage setCustomFont(Typeface typeface) {
        this.mCustomFont = typeface;
        return this;
    }

    public AboutPage enableDarkMode(Boolean enabled) {
        this.mEnableDarkMode = enabled;
        if (enabled.booleanValue()) {
            this.mBackgroundColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.about_background_dark_color);
            this.mTextColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.about_text_dark_color);
            this.mSeparatorColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.about_separator_dark_color);
            this.mIconColor = AboutPageUtils.getThemeAccentColor(this.mContext);
        } else {
            this.mBackgroundColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.about_background_color);
            this.mTextColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.about_text_color);
            this.mSeparatorColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.about_separator_color);
            this.mIconColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.about_item_icon_color);
        }
        return this;
    }

    public AboutPage addEmail(String email) {
        return this.addEmail(email, this.mContext.getString(R.string.about_contact_us));
    }

    public AboutPage addEmail(String email, String title) {
        Element emailElement = new Element();
        emailElement.setTitle(title);
        emailElement.setIconDrawable(R.drawable.about_icon_email);
        emailElement.setIconTint(R.color.about_item_icon_color);
        Intent intent = new Intent("android.intent.action.SENDTO");
        intent.setData(Uri.parse((String)"mailto:"));
        intent.putExtra("android.intent.extra.EMAIL", new String[]{email});
        emailElement.setIntent(intent);
        this.addItem(emailElement);
        return this;
    }

    public AboutPage addFacebook(String id2) {
        return this.addFacebook(id2, this.mContext.getString(R.string.about_facebook));
    }

    public AboutPage addFacebook(String id2, String title) {
        Element facebookElement = new Element();
        facebookElement.setTitle(title);
        facebookElement.setIconDrawable(R.drawable.about_icon_facebook);
        facebookElement.setIconTint(R.color.about_facebook_color);
        facebookElement.setValue(id2);
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.BROWSABLE");
        if (AboutPageUtils.isAppInstalled(this.mContext, "com.facebook.katana").booleanValue()) {
            intent.setPackage("com.facebook.katana");
            int versionCode = 0;
            try {
                versionCode = this.mContext.getPackageManager().getPackageInfo((String)"com.facebook.katana", (int)0).versionCode;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
            if (versionCode >= 3002850) {
                Uri uri = Uri.parse((String)("fb://facewebmodal/f?href=http://m.facebook.com/" + id2));
                intent.setData(uri);
            } else {
                Uri uri = Uri.parse((String)("fb://page/" + id2));
                intent.setData(uri);
            }
        } else {
            intent.setData(Uri.parse((String)("http://m.facebook.com/" + id2)));
        }
        facebookElement.setIntent(intent);
        this.addItem(facebookElement);
        return this;
    }

    public AboutPage addTwitter(String id2) {
        return this.addTwitter(id2, this.mContext.getString(R.string.about_twitter));
    }

    public AboutPage addTwitter(String id2, String title) {
        Element twitterElement = new Element();
        twitterElement.setTitle(title);
        twitterElement.setIconDrawable(R.drawable.about_icon_twitter);
        twitterElement.setIconTint(R.color.about_twitter_color);
        twitterElement.setValue(id2);
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.BROWSABLE");
        if (AboutPageUtils.isAppInstalled(this.mContext, "com.twitter.android").booleanValue()) {
            intent.setPackage("com.twitter.android");
            intent.setData(Uri.parse((String)String.format("twitter://user?screen_name=%s", id2)));
        } else {
            intent.setData(Uri.parse((String)String.format("http://twitter.com/intent/user?screen_name=%s", id2)));
        }
        twitterElement.setIntent(intent);
        this.addItem(twitterElement);
        return this;
    }

    public AboutPage addPlayStore(String id2) {
        return this.addPlayStore(id2, this.mContext.getString(R.string.about_play_store));
    }

    public AboutPage addPlayStore(String id2, String title) {
        Element playStoreElement = new Element();
        playStoreElement.setTitle(title);
        playStoreElement.setIconDrawable(R.drawable.about_icon_google_play);
        playStoreElement.setIconTint(R.color.about_play_store_color);
        playStoreElement.setValue(id2);
        Uri uri = Uri.parse((String)("https://play.google.com/store/apps/details?id=" + id2));
        Intent goToMarket = new Intent("android.intent.action.VIEW", uri);
        playStoreElement.setIntent(goToMarket);
        this.addItem(playStoreElement);
        return this;
    }

    public AboutPage addYoutube(String id2) {
        return this.addYoutube(id2, this.mContext.getString(R.string.about_youtube));
    }

    public AboutPage addYoutube(String id2, String title) {
        Element youtubeElement = new Element();
        youtubeElement.setTitle(title);
        youtubeElement.setIconDrawable(R.drawable.about_icon_youtube);
        youtubeElement.setIconTint(R.color.about_youtube_color);
        youtubeElement.setValue(id2);
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)String.format("http://youtube.com/channel/%s", id2)));
        if (AboutPageUtils.isAppInstalled(this.mContext, "com.google.android.youtube").booleanValue()) {
            intent.setPackage("com.google.android.youtube");
        }
        youtubeElement.setIntent(intent);
        this.addItem(youtubeElement);
        return this;
    }

    public AboutPage addInstagram(String id2) {
        return this.addInstagram(id2, this.mContext.getString(R.string.about_instagram));
    }

    public AboutPage addInstagram(String id2, String title) {
        Element instagramElement = new Element();
        instagramElement.setTitle(title);
        instagramElement.setIconDrawable(R.drawable.about_icon_instagram);
        instagramElement.setIconTint(R.color.about_instagram_color);
        instagramElement.setValue(id2);
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)("http://instagram.com/_u/" + id2)));
        if (AboutPageUtils.isAppInstalled(this.mContext, "com.instagram.android").booleanValue()) {
            intent.setPackage("com.instagram.android");
        }
        instagramElement.setIntent(intent);
        this.addItem(instagramElement);
        return this;
    }

    public AboutPage addGitHub(String id2) {
        return this.addGitHub(id2, this.mContext.getString(R.string.about_github));
    }

    public AboutPage addGitHub(String id2, String title) {
        Element gitHubElement = new Element();
        gitHubElement.setTitle(title);
        gitHubElement.setIconDrawable(R.drawable.about_icon_github);
        gitHubElement.setIconTint(R.color.about_github_color);
        gitHubElement.setValue(id2);
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.BROWSABLE");
        intent.setData(Uri.parse((String)String.format("https://github.com/%s", id2)));
        gitHubElement.setIntent(intent);
        this.addItem(gitHubElement);
        return this;
    }

    public AboutPage addWebsite(String url) {
        return this.addWebsite(url, this.mContext.getString(R.string.about_website));
    }

    public AboutPage addWebsite(String url, String title) {
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            url = "http://" + url;
        }
        Element websiteElement = new Element();
        websiteElement.setTitle(title);
        websiteElement.setIconDrawable(R.drawable.about_icon_link);
        websiteElement.setIconTint(R.color.about_item_icon_color);
        websiteElement.setValue(url);
        Uri uri = Uri.parse((String)url);
        Intent browserIntent = new Intent("android.intent.action.VIEW", uri);
        websiteElement.setIntent(browserIntent);
        this.addItem(websiteElement);
        return this;
    }

    public AboutPage addItem(Element element) {
        LinearLayout wrapper = (LinearLayout)this.mView.findViewById(R.id.about_providers);
        wrapper.addView(this.createItem(element));
        wrapper.addView(this.getSeparator(), new ViewGroup.LayoutParams(-1, this.mContext.getResources().getDimensionPixelSize(R.dimen.about_separator_height)));
        return this;
    }

    public AboutPage setImage(@DrawableRes int resource) {
        this.mImage = resource;
        return this;
    }

    public AboutPage addGroup(String name) {
        TextView textView = new TextView(this.mContext);
        textView.setText((CharSequence)name);
        TextViewCompat.setTextAppearance((TextView)textView, (int)R.style.about_groupTextAppearance);
        LinearLayout.LayoutParams textParams = new LinearLayout.LayoutParams(-2, -2);
        if (this.mCustomFont != null) {
            textView.setTypeface(this.mCustomFont);
        }
        int padding = this.mContext.getResources().getDimensionPixelSize(R.dimen.about_group_text_padding);
        textView.setPadding(padding, padding, padding, padding);
        if (this.mIsRTL) {
            textView.setGravity(8388629);
            textParams.gravity = 8388629;
        } else {
            textView.setGravity(8388627);
            textParams.gravity = 8388627;
        }
        textView.setLayoutParams((ViewGroup.LayoutParams)textParams);
        ((LinearLayout)this.mView.findViewById(R.id.about_providers)).addView((View)textView);
        return this;
    }

    public AboutPage isRTL(boolean value) {
        this.mIsRTL = value;
        return this;
    }

    public AboutPage setDescription(CharSequence description) {
        this.mDescription = description;
        return this;
    }

    public View create() {
        TextView description = (TextView)this.mView.findViewById(R.id.description);
        ImageView image = (ImageView)this.mView.findViewById(R.id.image);
        View subWrapper = this.mView.findViewById(R.id.sub_wrapper);
        View descriptionSeparator = this.mView.findViewById(R.id.description_separator);
        if (this.mImage > 0) {
            image.setImageResource(this.mImage);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mDescription)) {
            description.setText(this.mDescription);
        }
        description.setGravity(17);
        description.setTextColor(this.mTextColor);
        if (this.mCustomFont != null) {
            description.setTypeface(this.mCustomFont);
        }
        subWrapper.setBackgroundColor(this.mBackgroundColor);
        descriptionSeparator.setBackgroundColor(this.mSeparatorColor);
        return this.mView;
    }

    private View createItem(final Element element) {
        int gravity;
        LinearLayout wrapper = new LinearLayout(this.mContext);
        wrapper.setOrientation(0);
        wrapper.setClickable(true);
        if (element.getOnClickListener() != null) {
            wrapper.setOnClickListener(element.getOnClickListener());
        } else if (element.getIntent() != null) {
            wrapper.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    try {
                        AboutPage.this.mContext.startActivity(element.getIntent());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        TypedValue outValue = new TypedValue();
        this.mContext.getTheme().resolveAttribute(R.attr.selectableItemBackground, outValue, true);
        wrapper.setBackgroundResource(outValue.resourceId);
        int padding = this.mContext.getResources().getDimensionPixelSize(R.dimen.about_text_padding);
        wrapper.setPadding(padding, padding, padding, padding);
        LinearLayout.LayoutParams wrapperParams = new LinearLayout.LayoutParams(-1, -2);
        wrapper.setLayoutParams((ViewGroup.LayoutParams)wrapperParams);
        TextView textView = new TextView(this.mContext);
        TextViewCompat.setTextAppearance((TextView)textView, (int)R.style.about_elementTextAppearance);
        LinearLayout.LayoutParams textParams = new LinearLayout.LayoutParams(-2, -2);
        textView.setLayoutParams((ViewGroup.LayoutParams)textParams);
        if (this.mCustomFont != null) {
            textView.setTypeface(this.mCustomFont);
        }
        ImageView iconView = null;
        if (element.getIconDrawable() != null) {
            iconView = new ImageView(this.mContext);
            int size = this.mContext.getResources().getDimensionPixelSize(R.dimen.about_icon_size);
            LinearLayout.LayoutParams iconParams = new LinearLayout.LayoutParams(size, size);
            iconView.setLayoutParams((ViewGroup.LayoutParams)iconParams);
            int iconPadding = this.mContext.getResources().getDimensionPixelSize(R.dimen.about_icon_padding);
            iconView.setPadding(iconPadding, 0, iconPadding, 0);
            if (Build.VERSION.SDK_INT < 21) {
                VectorDrawableCompat drawable2 = VectorDrawableCompat.create((Resources)iconView.getResources(), (int)element.getIconDrawable(), (Resources.Theme)iconView.getContext().getTheme());
                iconView.setImageDrawable((Drawable)drawable2);
            } else {
                iconView.setImageResource(element.getIconDrawable().intValue());
            }
            Drawable wrappedDrawable = DrawableCompat.wrap((Drawable)iconView.getDrawable());
            wrappedDrawable = wrappedDrawable.mutate();
            if (!element.getSkipTint().booleanValue()) {
                if (element.getAutoApplyIconTint().booleanValue()) {
                    if (this.mEnableDarkMode.booleanValue()) {
                        if (element.getIconNightTint() != null) {
                            DrawableCompat.setTint((Drawable)wrappedDrawable, (int)ContextCompat.getColor((Context)this.mContext, (int)element.getIconNightTint()));
                        } else {
                            DrawableCompat.setTint((Drawable)wrappedDrawable, (int)this.mIconColor);
                        }
                    } else if (element.getIconTint() != null) {
                        DrawableCompat.setTint((Drawable)wrappedDrawable, (int)ContextCompat.getColor((Context)this.mContext, (int)element.getIconTint()));
                    } else {
                        DrawableCompat.setTint((Drawable)wrappedDrawable, (int)this.mIconColor);
                    }
                } else if (element.getIconTint() != null) {
                    DrawableCompat.setTint((Drawable)wrappedDrawable, (int)ContextCompat.getColor((Context)this.mContext, (int)element.getIconTint()));
                } else if (this.mEnableDarkMode.booleanValue()) {
                    DrawableCompat.setTint((Drawable)wrappedDrawable, (int)this.mIconColor);
                }
            }
        } else {
            int iconPadding = this.mContext.getResources().getDimensionPixelSize(R.dimen.about_icon_padding);
            textView.setPadding(iconPadding, iconPadding, iconPadding, iconPadding);
        }
        textView.setText((CharSequence)element.getTitle());
        textView.setTextColor(this.mTextColor);
        if (this.mIsRTL) {
            gravity = element.getGravity() != null ? element.getGravity() : 0x800005;
            wrapper.setGravity(gravity | 0x10);
            textParams.gravity = gravity | 0x10;
            wrapper.addView((View)textView);
            if (element.getIconDrawable() != null) {
                wrapper.addView((View)iconView);
            }
        } else {
            gravity = element.getGravity() != null ? element.getGravity() : 0x800003;
            wrapper.setGravity(gravity | 0x10);
            textParams.gravity = gravity | 0x10;
            if (element.getIconDrawable() != null) {
                wrapper.addView((View)iconView);
            }
            wrapper.addView((View)textView);
        }
        return wrapper;
    }

    private View getSeparator() {
        View separator = this.mInflater.inflate(R.layout.about_page_separator, null);
        separator.setBackgroundColor(this.mSeparatorColor);
        return separator;
    }
}

