/*
 * Decompiled with CFR 0.152.
 */
package com.mcxtzhang.swipemenulib;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.OvershootInterpolator;

public class SwipeMenuLayout
extends ViewGroup {
    private static final String TAG = "zxt";
    private boolean isSwipeEnable = true;
    private int mScaleTouchSlop;
    private int mMaxVelocity;
    private int mPointerId;
    private int mHeight;
    private int mMaxWidth;
    private int mRightMenuWidths;
    private int mLimit;
    private PointF mLastP = new PointF();
    private boolean isUnMoved = true;
    private static SwipeMenuLayout mViewCache;
    private static boolean isTouching;
    private VelocityTracker mVelocityTracker;
    private Log LogUtils;
    private boolean isIos = true;
    private boolean iosInterceptFlag = false;
    private boolean isLeftSwipe = true;
    private ValueAnimator mExpandAnim;
    private ValueAnimator mCloseAnim;

    public SwipeMenuLayout(Context context) {
        this(context, null);
    }

    public SwipeMenuLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeMenuLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public boolean isSwipeEnable() {
        return this.isSwipeEnable;
    }

    public void setSwipeEnable(boolean swipeEnable) {
        this.isSwipeEnable = swipeEnable;
    }

    public boolean isIos() {
        return this.isIos;
    }

    public SwipeMenuLayout setIos(boolean ios) {
        this.isIos = ios;
        return this;
    }

    public boolean isLeftSwipe() {
        return this.isLeftSwipe;
    }

    public SwipeMenuLayout setLeftSwipe(boolean leftSwipe) {
        this.isLeftSwipe = leftSwipe;
        return this;
    }

    public static SwipeMenuLayout getViewCache() {
        return mViewCache;
    }

    private void init(Context context) {
        this.mScaleTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mMaxVelocity = ViewConfiguration.get((Context)context).getScaledMaximumFlingVelocity();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        ViewParent parent = this.getParent();
        if (parent != null && parent instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)parent;
            this.mMaxWidth = viewGroup.getMeasuredWidth() - viewGroup.getPaddingLeft() - viewGroup.getPaddingRight();
        } else {
            this.mMaxWidth = this.getResources().getDisplayMetrics().widthPixels;
        }
        this.mRightMenuWidths = 0;
        int childCount = this.getChildCount();
        boolean measureMatchParentChildren = View.MeasureSpec.getMode((int)heightMeasureSpec) != 0x40000000;
        boolean isNeedMeasureChildHeight = false;
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            if (childView.getVisibility() == 8) continue;
            this.measureChildWithMargins(childView, widthMeasureSpec, 0, heightMeasureSpec, 0);
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)childView.getLayoutParams();
            this.mHeight = Math.max(this.mHeight, childView.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            if (measureMatchParentChildren && lp.height == -1) {
                isNeedMeasureChildHeight = true;
            }
            if (i <= 0) continue;
            this.mRightMenuWidths += childView.getMeasuredWidth();
        }
        this.setMeasuredDimension(this.mMaxWidth, this.mHeight);
        this.mLimit = this.mRightMenuWidths * 4 / 10;
        if (isNeedMeasureChildHeight) {
            this.forceUniformHeight(childCount, widthMeasureSpec);
        }
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    private void forceUniformHeight(int count, int widthMeasureSpec) {
        int uniformMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredHeight(), (int)0x40000000);
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            if (lp.height != -1) continue;
            int oldWidth = lp.width;
            lp.width = child.getMeasuredWidth();
            this.measureChildWithMargins(child, widthMeasureSpec, 0, uniformMeasureSpec, 0);
            lp.width = oldWidth;
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int childCount = this.getChildCount();
        int left = 0 + this.getPaddingLeft();
        int right = 0;
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            if (childView.getVisibility() == 8) continue;
            if (i == 0) {
                childView.layout(left, this.getPaddingTop(), left + this.mMaxWidth, this.getPaddingTop() + childView.getMeasuredHeight());
                left += this.mMaxWidth;
                continue;
            }
            if (this.isLeftSwipe) {
                childView.layout(left, this.getPaddingTop(), left + childView.getMeasuredWidth(), this.getPaddingTop() + childView.getMeasuredHeight());
                left += childView.getMeasuredWidth();
                continue;
            }
            childView.layout(right - childView.getMeasuredWidth(), this.getPaddingTop(), right, this.getPaddingTop() + childView.getMeasuredHeight());
            right -= childView.getMeasuredWidth();
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.isSwipeEnable) {
            this.acquireVelocityTracker(ev);
            VelocityTracker verTracker = this.mVelocityTracker;
            switch (ev.getAction()) {
                case 0: {
                    this.isUnMoved = true;
                    this.iosInterceptFlag = false;
                    if (isTouching) {
                        return false;
                    }
                    isTouching = true;
                    this.mLastP.set(ev.getRawX(), ev.getRawY());
                    if (mViewCache != null) {
                        if (mViewCache != this) {
                            mViewCache.smoothClose();
                            mViewCache = null;
                            this.iosInterceptFlag = this.isIos;
                        }
                        this.getParent().requestDisallowInterceptTouchEvent(true);
                    }
                    this.mPointerId = ev.getPointerId(0);
                    break;
                }
                case 2: {
                    if (this.iosInterceptFlag) break;
                    float gap = this.mLastP.x - ev.getRawX();
                    if (Math.abs(gap) > 10.0f || Math.abs(this.getScrollX()) > 10) {
                        this.getParent().requestDisallowInterceptTouchEvent(true);
                    }
                    if (Math.abs(gap) > (float)this.mScaleTouchSlop) {
                        this.isUnMoved = false;
                    }
                    this.scrollBy((int)gap, 0);
                    if (this.isLeftSwipe) {
                        if (this.getScrollX() < 0) {
                            this.scrollTo(0, 0);
                        }
                        if (this.getScrollX() > this.mRightMenuWidths) {
                            this.scrollTo(this.mRightMenuWidths, 0);
                        }
                    } else {
                        if (this.getScrollX() < -this.mRightMenuWidths) {
                            this.scrollTo(-this.mRightMenuWidths, 0);
                        }
                        if (this.getScrollX() > 0) {
                            this.scrollTo(0, 0);
                        }
                    }
                    this.mLastP.set(ev.getRawX(), ev.getRawY());
                    break;
                }
                case 1: 
                case 3: {
                    if (!this.iosInterceptFlag) {
                        verTracker.computeCurrentVelocity(1000, (float)this.mMaxVelocity);
                        float velocityX = verTracker.getXVelocity(this.mPointerId);
                        if (Math.abs(velocityX) > 1000.0f) {
                            if (velocityX < -1000.0f) {
                                if (this.isLeftSwipe) {
                                    this.smoothExpand();
                                    mViewCache = this;
                                } else {
                                    this.smoothClose();
                                }
                            } else if (this.isLeftSwipe) {
                                this.smoothClose();
                            } else {
                                this.smoothExpand();
                                mViewCache = this;
                            }
                        } else if (Math.abs(this.getScrollX()) > this.mLimit) {
                            this.smoothExpand();
                            mViewCache = this;
                        } else {
                            this.smoothClose();
                        }
                    }
                    this.releaseVelocityTracker();
                    isTouching = false;
                    break;
                }
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 1: {
                if (this.isLeftSwipe) {
                    if (this.getScrollX() <= this.mScaleTouchSlop || !(ev.getX() < (float)(this.getWidth() - this.getScrollX()))) break;
                    if (this.isUnMoved) {
                        this.smoothClose();
                    }
                    return true;
                }
                if (-this.getScrollX() <= this.mScaleTouchSlop || !(ev.getX() > (float)(-this.getScrollX()))) break;
                if (this.isUnMoved) {
                    this.smoothClose();
                }
                return true;
            }
        }
        if (this.iosInterceptFlag) {
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public void smoothExpand() {
        this.mExpandAnim = ValueAnimator.ofInt((int[])new int[]{this.getScrollX(), this.isLeftSwipe ? this.mRightMenuWidths : -this.mRightMenuWidths});
        this.mExpandAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                SwipeMenuLayout.this.scrollTo((Integer)animation.getAnimatedValue(), 0);
            }
        });
        this.mExpandAnim.setInterpolator((TimeInterpolator)new OvershootInterpolator());
        this.mExpandAnim.setDuration(300L).start();
    }

    public void smoothClose() {
        this.mCloseAnim = ValueAnimator.ofInt((int[])new int[]{this.getScrollX(), 0});
        this.mCloseAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                SwipeMenuLayout.this.scrollTo((Integer)animation.getAnimatedValue(), 0);
            }
        });
        this.mCloseAnim.setInterpolator((TimeInterpolator)new AnticipateInterpolator());
        this.mCloseAnim.setDuration(300L).start();
    }

    private void acquireVelocityTracker(MotionEvent event) {
        if (null == this.mVelocityTracker) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
    }

    private void releaseVelocityTracker() {
        if (null != this.mVelocityTracker) {
            this.mVelocityTracker.clear();
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    protected void onDetachedFromWindow() {
        if (this == mViewCache) {
            mViewCache.smoothClose();
            mViewCache = null;
        }
        super.onDetachedFromWindow();
    }

    public boolean performLongClick() {
        if (Math.abs(this.getScrollX()) > this.mScaleTouchSlop) {
            return false;
        }
        return super.performLongClick();
    }

    public void quickClose() {
        if (this == mViewCache) {
            if (null != this.mExpandAnim && this.mExpandAnim.isRunning()) {
                this.mExpandAnim.cancel();
            }
            mViewCache.scrollTo(0, 0);
            mViewCache = null;
        }
    }
}

