/*
 * Decompiled with CFR 0.152.
 */
package com.yqritc.recyclerviewflexibledivider;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.DimenRes;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.yqritc.recyclerviewflexibledivider.FlexibleDividerDecoration;

public class VerticalDividerItemDecoration
extends FlexibleDividerDecoration {
    private MarginProvider mMarginProvider;

    protected VerticalDividerItemDecoration(Builder builder) {
        super(builder);
        this.mMarginProvider = builder.mMarginProvider;
    }

    @Override
    protected Rect getDividerBound(int position, RecyclerView parent, View child) {
        Rect bounds = new Rect(0, 0, 0, 0);
        int transitionX = (int)ViewCompat.getTranslationX((View)child);
        int transitionY = (int)ViewCompat.getTranslationY((View)child);
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
        bounds.top = parent.getPaddingTop() + this.mMarginProvider.dividerTopMargin(position, parent) + transitionY;
        bounds.bottom = parent.getHeight() - parent.getPaddingBottom() - this.mMarginProvider.dividerBottomMargin(position, parent) + transitionY;
        int dividerSize = this.getDividerSize(position, parent);
        boolean isReverseLayout = this.isReverseLayout(parent);
        if (this.mDividerType == FlexibleDividerDecoration.DividerType.DRAWABLE) {
            if (isReverseLayout) {
                bounds.right = child.getLeft() - params.leftMargin + transitionX;
                bounds.left = bounds.right - dividerSize;
            } else {
                bounds.left = child.getRight() + params.rightMargin + transitionX;
                bounds.right = bounds.left + dividerSize;
            }
        } else {
            int halfSize = dividerSize / 2;
            bounds.left = isReverseLayout ? child.getLeft() - params.leftMargin - halfSize + transitionX : child.getRight() + params.rightMargin + halfSize + transitionX;
            bounds.right = bounds.left;
        }
        if (this.mPositionInsideItem) {
            if (isReverseLayout) {
                bounds.left += dividerSize;
                bounds.right += dividerSize;
            } else {
                bounds.left -= dividerSize;
                bounds.right -= dividerSize;
            }
        }
        return bounds;
    }

    @Override
    protected void setItemOffsets(Rect outRect, int position, RecyclerView parent) {
        if (this.mPositionInsideItem) {
            outRect.set(0, 0, 0, 0);
            return;
        }
        if (this.isReverseLayout(parent)) {
            outRect.set(this.getDividerSize(position, parent), 0, 0, 0);
        } else {
            outRect.set(0, 0, this.getDividerSize(position, parent), 0);
        }
    }

    private int getDividerSize(int position, RecyclerView parent) {
        if (this.mPaintProvider != null) {
            return (int)this.mPaintProvider.dividerPaint(position, parent).getStrokeWidth();
        }
        if (this.mSizeProvider != null) {
            return this.mSizeProvider.dividerSize(position, parent);
        }
        if (this.mDrawableProvider != null) {
            Drawable drawable = this.mDrawableProvider.drawableProvider(position, parent);
            return drawable.getIntrinsicWidth();
        }
        throw new RuntimeException("failed to get size");
    }

    public static class Builder
    extends FlexibleDividerDecoration.Builder<Builder> {
        private MarginProvider mMarginProvider = new MarginProvider(){

            @Override
            public int dividerTopMargin(int position, RecyclerView parent) {
                return 0;
            }

            @Override
            public int dividerBottomMargin(int position, RecyclerView parent) {
                return 0;
            }
        };

        public Builder(Context context) {
            super(context);
        }

        public Builder margin(final int topMargin, final int bottomMargin) {
            return this.marginProvider(new MarginProvider(){

                @Override
                public int dividerTopMargin(int position, RecyclerView parent) {
                    return topMargin;
                }

                @Override
                public int dividerBottomMargin(int position, RecyclerView parent) {
                    return bottomMargin;
                }
            });
        }

        public Builder margin(int verticalMargin) {
            return this.margin(verticalMargin, verticalMargin);
        }

        public Builder marginResId(@DimenRes int topMarginId, @DimenRes int bottomMarginId) {
            return this.margin(this.mResources.getDimensionPixelSize(topMarginId), this.mResources.getDimensionPixelSize(bottomMarginId));
        }

        public Builder marginResId(@DimenRes int verticalMarginId) {
            return this.marginResId(verticalMarginId, verticalMarginId);
        }

        public Builder marginProvider(MarginProvider provider) {
            this.mMarginProvider = provider;
            return this;
        }

        public VerticalDividerItemDecoration build() {
            this.checkBuilderParams();
            return new VerticalDividerItemDecoration(this);
        }
    }

    public static interface MarginProvider {
        public int dividerTopMargin(int var1, RecyclerView var2);

        public int dividerBottomMargin(int var1, RecyclerView var2);
    }
}

