/*
 * Decompiled with CFR 0.152.
 */
package com.labters.documentscanner.libraries;

import java.util.ArrayList;
import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class PerspectiveTransformation {
    private static final String DEBUG_TAG = "PerspectiveTransformation";

    public Mat transform(Mat src, MatOfPoint2f corners) {
        MatOfPoint2f sortedCorners = this.sortCorners(corners);
        Size size = this.getRectangleSize(sortedCorners);
        Mat result = Mat.zeros((Size)size, (int)src.type());
        MatOfPoint2f imageOutline = this.getOutline(result);
        Mat transformation = Imgproc.getPerspectiveTransform((Mat)sortedCorners, (Mat)imageOutline);
        Imgproc.warpPerspective((Mat)src, (Mat)result, (Mat)transformation, (Size)size);
        return result;
    }

    private Size getRectangleSize(MatOfPoint2f rectangle) {
        Point[] corners = rectangle.toArray();
        double top = this.getDistance(corners[0], corners[1]);
        double right = this.getDistance(corners[1], corners[2]);
        double bottom = this.getDistance(corners[2], corners[3]);
        double left = this.getDistance(corners[3], corners[0]);
        double averageWidth = (top + bottom) / 2.0;
        double averageHeight = (right + left) / 2.0;
        return new Size(new Point(averageWidth, averageHeight));
    }

    private double getDistance(Point p1, Point p2) {
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    private MatOfPoint2f getOutline(Mat image) {
        Point topLeft = new Point(0.0, 0.0);
        Point topRight = new Point((double)image.cols(), 0.0);
        Point bottomRight = new Point((double)image.cols(), (double)image.rows());
        Point bottomLeft = new Point(0.0, (double)image.rows());
        Point[] points = new Point[]{topLeft, topRight, bottomRight, bottomLeft};
        MatOfPoint2f result = new MatOfPoint2f();
        result.fromArray(points);
        return result;
    }

    private MatOfPoint2f sortCorners(MatOfPoint2f corners) {
        Point center = this.getMassCenter(corners);
        List points = corners.toList();
        ArrayList<Point> topPoints = new ArrayList<Point>();
        ArrayList<Point> bottomPoints = new ArrayList<Point>();
        for (Point point : points) {
            if (point.y < center.y) {
                topPoints.add(point);
                continue;
            }
            bottomPoints.add(point);
        }
        Point topLeft = ((Point)topPoints.get((int)0)).x > ((Point)topPoints.get((int)1)).x ? (Point)topPoints.get(1) : (Point)topPoints.get(0);
        Point topRight = ((Point)topPoints.get((int)0)).x > ((Point)topPoints.get((int)1)).x ? (Point)topPoints.get(0) : (Point)topPoints.get(1);
        Point bottomLeft = ((Point)bottomPoints.get((int)0)).x > ((Point)bottomPoints.get((int)1)).x ? (Point)bottomPoints.get(1) : (Point)bottomPoints.get(0);
        Point bottomRight = ((Point)bottomPoints.get((int)0)).x > ((Point)bottomPoints.get((int)1)).x ? (Point)bottomPoints.get(0) : (Point)bottomPoints.get(1);
        MatOfPoint2f result = new MatOfPoint2f();
        Point[] sortedPoints = new Point[]{topLeft, topRight, bottomRight, bottomLeft};
        result.fromArray(sortedPoints);
        return result;
    }

    private Point getMassCenter(MatOfPoint2f points) {
        double xSum = 0.0;
        double ySum = 0.0;
        List pointList = points.toList();
        int len = pointList.size();
        for (Point point : pointList) {
            xSum += point.x;
            ySum += point.y;
        }
        return new Point(xSum / (double)len, ySum / (double)len);
    }
}

