/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.QuantitativeValue;
import com.google.schemaorg.core.StructuredValueImpl;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.WarrantyPromise;
import com.google.schemaorg.core.WarrantyScope;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class WarrantyPromiseImpl
extends StructuredValueImpl
implements WarrantyPromise {
    private static final ImmutableSet<String> PROPERTY_SET = WarrantyPromiseImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/durationOfWarranty");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/warrantyScope");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public WarrantyPromiseImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/WarrantyPromise";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getDurationOfWarrantyList() {
        return this.getProperty("http://schema.org/durationOfWarranty");
    }

    @Override
    public ImmutableList<SchemaOrgType> getWarrantyScopeList() {
        return this.getProperty("http://schema.org/warrantyScope");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<WarrantyPromise.Builder>
    implements WarrantyPromise.Builder {
        BuilderImpl() {
        }

        @Override
        public WarrantyPromise.Builder addAdditionalType(URL value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public WarrantyPromise.Builder addAdditionalType(String value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public WarrantyPromise.Builder addAlternateName(Text value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public WarrantyPromise.Builder addAlternateName(String value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public WarrantyPromise.Builder addDescription(Text value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public WarrantyPromise.Builder addDescription(String value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public WarrantyPromise.Builder addDurationOfWarranty(QuantitativeValue value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/durationOfWarranty", value);
        }

        @Override
        public WarrantyPromise.Builder addDurationOfWarranty(QuantitativeValue.Builder value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/durationOfWarranty", value.build());
        }

        @Override
        public WarrantyPromise.Builder addDurationOfWarranty(String value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/durationOfWarranty", Text.of(value));
        }

        @Override
        public WarrantyPromise.Builder addImage(ImageObject value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public WarrantyPromise.Builder addImage(ImageObject.Builder value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public WarrantyPromise.Builder addImage(URL value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public WarrantyPromise.Builder addImage(String value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public WarrantyPromise.Builder addMainEntityOfPage(CreativeWork value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public WarrantyPromise.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public WarrantyPromise.Builder addMainEntityOfPage(URL value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public WarrantyPromise.Builder addMainEntityOfPage(String value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public WarrantyPromise.Builder addName(Text value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public WarrantyPromise.Builder addName(String value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public WarrantyPromise.Builder addPotentialAction(Action value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public WarrantyPromise.Builder addPotentialAction(Action.Builder value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public WarrantyPromise.Builder addPotentialAction(String value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public WarrantyPromise.Builder addSameAs(URL value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public WarrantyPromise.Builder addSameAs(String value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public WarrantyPromise.Builder addUrl(URL value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public WarrantyPromise.Builder addUrl(String value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public WarrantyPromise.Builder addWarrantyScope(WarrantyScope value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/warrantyScope", value);
        }

        @Override
        public WarrantyPromise.Builder addWarrantyScope(String value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.org/warrantyScope", Text.of(value));
        }

        @Override
        public WarrantyPromise.Builder addDetailedDescription(Article value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public WarrantyPromise.Builder addDetailedDescription(Article.Builder value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public WarrantyPromise.Builder addDetailedDescription(String value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public WarrantyPromise.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public WarrantyPromise.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public WarrantyPromise.Builder addPopularityScore(String value) {
            return (WarrantyPromise.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public WarrantyPromise build() {
            return new WarrantyPromiseImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

