/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.WPHeader;
import com.google.schemaorg.core.WebPageElementImpl;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class WPHeaderImpl
extends WebPageElementImpl
implements WPHeader {
    private static final ImmutableSet<String> PROPERTY_SET = WPHeaderImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public WPHeaderImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/WPHeader";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<WPHeader.Builder>
    implements WPHeader.Builder {
        BuilderImpl() {
        }

        @Override
        public WPHeader.Builder addAbout(Thing value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public WPHeader.Builder addAbout(Thing.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public WPHeader.Builder addAbout(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public WPHeader.Builder addAccessibilityAPI(Text value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public WPHeader.Builder addAccessibilityAPI(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public WPHeader.Builder addAccessibilityControl(Text value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public WPHeader.Builder addAccessibilityControl(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public WPHeader.Builder addAccessibilityFeature(Text value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public WPHeader.Builder addAccessibilityFeature(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public WPHeader.Builder addAccessibilityHazard(Text value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public WPHeader.Builder addAccessibilityHazard(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public WPHeader.Builder addAccountablePerson(Person value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public WPHeader.Builder addAccountablePerson(Person.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public WPHeader.Builder addAccountablePerson(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public WPHeader.Builder addAdditionalType(URL value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public WPHeader.Builder addAdditionalType(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public WPHeader.Builder addAggregateRating(AggregateRating value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public WPHeader.Builder addAggregateRating(AggregateRating.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public WPHeader.Builder addAggregateRating(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public WPHeader.Builder addAlternateName(Text value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public WPHeader.Builder addAlternateName(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public WPHeader.Builder addAlternativeHeadline(Text value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public WPHeader.Builder addAlternativeHeadline(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public WPHeader.Builder addAssociatedMedia(MediaObject value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public WPHeader.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public WPHeader.Builder addAssociatedMedia(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public WPHeader.Builder addAudience(Audience value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public WPHeader.Builder addAudience(Audience.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public WPHeader.Builder addAudience(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public WPHeader.Builder addAudio(AudioObject value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public WPHeader.Builder addAudio(AudioObject.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public WPHeader.Builder addAudio(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public WPHeader.Builder addAuthor(Organization value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public WPHeader.Builder addAuthor(Organization.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public WPHeader.Builder addAuthor(Person value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public WPHeader.Builder addAuthor(Person.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public WPHeader.Builder addAuthor(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public WPHeader.Builder addAward(Text value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public WPHeader.Builder addAward(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public WPHeader.Builder addAwards(Text value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public WPHeader.Builder addAwards(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public WPHeader.Builder addCharacter(Person value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public WPHeader.Builder addCharacter(Person.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public WPHeader.Builder addCharacter(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public WPHeader.Builder addCitation(CreativeWork value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public WPHeader.Builder addCitation(CreativeWork.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public WPHeader.Builder addCitation(Text value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public WPHeader.Builder addCitation(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public WPHeader.Builder addComment(Comment value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public WPHeader.Builder addComment(Comment.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public WPHeader.Builder addComment(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public WPHeader.Builder addCommentCount(Integer value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public WPHeader.Builder addCommentCount(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public WPHeader.Builder addContentLocation(Place value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public WPHeader.Builder addContentLocation(Place.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public WPHeader.Builder addContentLocation(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public WPHeader.Builder addContentRating(Text value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public WPHeader.Builder addContentRating(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public WPHeader.Builder addContributor(Organization value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public WPHeader.Builder addContributor(Organization.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public WPHeader.Builder addContributor(Person value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public WPHeader.Builder addContributor(Person.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public WPHeader.Builder addContributor(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public WPHeader.Builder addCopyrightHolder(Organization value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public WPHeader.Builder addCopyrightHolder(Organization.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public WPHeader.Builder addCopyrightHolder(Person value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public WPHeader.Builder addCopyrightHolder(Person.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public WPHeader.Builder addCopyrightHolder(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public WPHeader.Builder addCopyrightYear(Number value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public WPHeader.Builder addCopyrightYear(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public WPHeader.Builder addCreator(Organization value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public WPHeader.Builder addCreator(Organization.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public WPHeader.Builder addCreator(Person value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public WPHeader.Builder addCreator(Person.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public WPHeader.Builder addCreator(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public WPHeader.Builder addDateCreated(Date value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public WPHeader.Builder addDateCreated(DateTime value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public WPHeader.Builder addDateCreated(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public WPHeader.Builder addDateModified(Date value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public WPHeader.Builder addDateModified(DateTime value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public WPHeader.Builder addDateModified(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public WPHeader.Builder addDatePublished(Date value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public WPHeader.Builder addDatePublished(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public WPHeader.Builder addDescription(Text value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public WPHeader.Builder addDescription(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public WPHeader.Builder addDiscussionUrl(URL value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public WPHeader.Builder addDiscussionUrl(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public WPHeader.Builder addEditor(Person value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public WPHeader.Builder addEditor(Person.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public WPHeader.Builder addEditor(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public WPHeader.Builder addEducationalAlignment(AlignmentObject value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public WPHeader.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public WPHeader.Builder addEducationalAlignment(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public WPHeader.Builder addEducationalUse(Text value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public WPHeader.Builder addEducationalUse(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public WPHeader.Builder addEncoding(MediaObject value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public WPHeader.Builder addEncoding(MediaObject.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public WPHeader.Builder addEncoding(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public WPHeader.Builder addEncodings(MediaObject value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public WPHeader.Builder addEncodings(MediaObject.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public WPHeader.Builder addEncodings(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public WPHeader.Builder addExampleOfWork(CreativeWork value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public WPHeader.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public WPHeader.Builder addExampleOfWork(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public WPHeader.Builder addFileFormat(Text value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public WPHeader.Builder addFileFormat(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public WPHeader.Builder addGenre(Text value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public WPHeader.Builder addGenre(URL value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public WPHeader.Builder addGenre(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public WPHeader.Builder addHasPart(CreativeWork value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public WPHeader.Builder addHasPart(CreativeWork.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public WPHeader.Builder addHasPart(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public WPHeader.Builder addHeadline(Text value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public WPHeader.Builder addHeadline(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public WPHeader.Builder addImage(ImageObject value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public WPHeader.Builder addImage(ImageObject.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public WPHeader.Builder addImage(URL value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public WPHeader.Builder addImage(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public WPHeader.Builder addInLanguage(Language value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public WPHeader.Builder addInLanguage(Language.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public WPHeader.Builder addInLanguage(Text value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public WPHeader.Builder addInLanguage(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public WPHeader.Builder addInteractionStatistic(InteractionCounter value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public WPHeader.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public WPHeader.Builder addInteractionStatistic(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public WPHeader.Builder addInteractivityType(Text value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public WPHeader.Builder addInteractivityType(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public WPHeader.Builder addIsBasedOnUrl(URL value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public WPHeader.Builder addIsBasedOnUrl(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public WPHeader.Builder addIsFamilyFriendly(Boolean value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public WPHeader.Builder addIsFamilyFriendly(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public WPHeader.Builder addIsPartOf(CreativeWork value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public WPHeader.Builder addIsPartOf(CreativeWork.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public WPHeader.Builder addIsPartOf(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public WPHeader.Builder addKeywords(Text value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public WPHeader.Builder addKeywords(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public WPHeader.Builder addLearningResourceType(Text value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public WPHeader.Builder addLearningResourceType(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public WPHeader.Builder addLicense(CreativeWork value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public WPHeader.Builder addLicense(CreativeWork.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public WPHeader.Builder addLicense(URL value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public WPHeader.Builder addLicense(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public WPHeader.Builder addLocationCreated(Place value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public WPHeader.Builder addLocationCreated(Place.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public WPHeader.Builder addLocationCreated(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public WPHeader.Builder addMainEntity(Thing value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public WPHeader.Builder addMainEntity(Thing.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public WPHeader.Builder addMainEntity(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public WPHeader.Builder addMainEntityOfPage(CreativeWork value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public WPHeader.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public WPHeader.Builder addMainEntityOfPage(URL value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public WPHeader.Builder addMainEntityOfPage(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public WPHeader.Builder addMentions(Thing value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public WPHeader.Builder addMentions(Thing.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public WPHeader.Builder addMentions(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public WPHeader.Builder addName(Text value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public WPHeader.Builder addName(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public WPHeader.Builder addOffers(Offer value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public WPHeader.Builder addOffers(Offer.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public WPHeader.Builder addOffers(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public WPHeader.Builder addPosition(Integer value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public WPHeader.Builder addPosition(Text value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public WPHeader.Builder addPosition(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public WPHeader.Builder addPotentialAction(Action value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public WPHeader.Builder addPotentialAction(Action.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public WPHeader.Builder addPotentialAction(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public WPHeader.Builder addProducer(Organization value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public WPHeader.Builder addProducer(Organization.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public WPHeader.Builder addProducer(Person value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public WPHeader.Builder addProducer(Person.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public WPHeader.Builder addProducer(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public WPHeader.Builder addProvider(Organization value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public WPHeader.Builder addProvider(Organization.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public WPHeader.Builder addProvider(Person value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public WPHeader.Builder addProvider(Person.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public WPHeader.Builder addProvider(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public WPHeader.Builder addPublication(PublicationEvent value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public WPHeader.Builder addPublication(PublicationEvent.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public WPHeader.Builder addPublication(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public WPHeader.Builder addPublisher(Organization value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public WPHeader.Builder addPublisher(Organization.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public WPHeader.Builder addPublisher(Person value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public WPHeader.Builder addPublisher(Person.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public WPHeader.Builder addPublisher(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public WPHeader.Builder addPublishingPrinciples(URL value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public WPHeader.Builder addPublishingPrinciples(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public WPHeader.Builder addRecordedAt(Event value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public WPHeader.Builder addRecordedAt(Event.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public WPHeader.Builder addRecordedAt(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public WPHeader.Builder addReleasedEvent(PublicationEvent value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public WPHeader.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public WPHeader.Builder addReleasedEvent(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public WPHeader.Builder addReview(Review value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public WPHeader.Builder addReview(Review.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public WPHeader.Builder addReview(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public WPHeader.Builder addReviews(Review value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public WPHeader.Builder addReviews(Review.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public WPHeader.Builder addReviews(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public WPHeader.Builder addSameAs(URL value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public WPHeader.Builder addSameAs(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public WPHeader.Builder addSchemaVersion(Text value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public WPHeader.Builder addSchemaVersion(URL value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public WPHeader.Builder addSchemaVersion(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public WPHeader.Builder addSourceOrganization(Organization value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public WPHeader.Builder addSourceOrganization(Organization.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public WPHeader.Builder addSourceOrganization(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public WPHeader.Builder addText(Text value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public WPHeader.Builder addText(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public WPHeader.Builder addThumbnailUrl(URL value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public WPHeader.Builder addThumbnailUrl(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public WPHeader.Builder addTimeRequired(Duration value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public WPHeader.Builder addTimeRequired(Duration.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public WPHeader.Builder addTimeRequired(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public WPHeader.Builder addTranslator(Organization value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public WPHeader.Builder addTranslator(Organization.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public WPHeader.Builder addTranslator(Person value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public WPHeader.Builder addTranslator(Person.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public WPHeader.Builder addTranslator(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public WPHeader.Builder addTypicalAgeRange(Text value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public WPHeader.Builder addTypicalAgeRange(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public WPHeader.Builder addUrl(URL value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public WPHeader.Builder addUrl(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public WPHeader.Builder addVersion(Number value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public WPHeader.Builder addVersion(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public WPHeader.Builder addVideo(VideoObject value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public WPHeader.Builder addVideo(VideoObject.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public WPHeader.Builder addVideo(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public WPHeader.Builder addWorkExample(CreativeWork value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public WPHeader.Builder addWorkExample(CreativeWork.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public WPHeader.Builder addWorkExample(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public WPHeader.Builder addDetailedDescription(Article value) {
            return (WPHeader.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public WPHeader.Builder addDetailedDescription(Article.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public WPHeader.Builder addDetailedDescription(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public WPHeader.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (WPHeader.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public WPHeader.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (WPHeader.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public WPHeader.Builder addPopularityScore(String value) {
            return (WPHeader.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public WPHeader build() {
            return new WPHeaderImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

