/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.ActionImpl;
import com.google.schemaorg.core.ActionStatusType;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.EntryPoint;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PostalAddress;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.UpdateAction;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class UpdateActionImpl
extends ActionImpl
implements UpdateAction {
    private static final ImmutableSet<String> PROPERTY_SET = UpdateActionImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/actionStatus");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/agent");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/collection");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/endTime");
        builder.add((Object)"http://schema.org/error");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/instrument");
        builder.add((Object)"http://schema.org/location");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/object");
        builder.add((Object)"http://schema.org/participant");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/result");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/startTime");
        builder.add((Object)"http://schema.org/target");
        builder.add((Object)"http://schema.org/targetCollection");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public UpdateActionImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/UpdateAction";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getCollectionList() {
        return this.getProperty("http://schema.org/collection");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTargetCollectionList() {
        return this.getProperty("http://schema.org/targetCollection");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<UpdateAction.Builder>
    implements UpdateAction.Builder {
        BuilderImpl() {
        }

        @Override
        public UpdateAction.Builder addActionStatus(ActionStatusType value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/actionStatus", value);
        }

        @Override
        public UpdateAction.Builder addActionStatus(String value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/actionStatus", Text.of(value));
        }

        @Override
        public UpdateAction.Builder addAdditionalType(URL value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public UpdateAction.Builder addAdditionalType(String value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public UpdateAction.Builder addAgent(Organization value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/agent", value);
        }

        @Override
        public UpdateAction.Builder addAgent(Organization.Builder value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/agent", value.build());
        }

        @Override
        public UpdateAction.Builder addAgent(Person value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/agent", value);
        }

        @Override
        public UpdateAction.Builder addAgent(Person.Builder value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/agent", value.build());
        }

        @Override
        public UpdateAction.Builder addAgent(String value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/agent", Text.of(value));
        }

        @Override
        public UpdateAction.Builder addAlternateName(Text value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public UpdateAction.Builder addAlternateName(String value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public UpdateAction.Builder addCollection(Thing value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/collection", value);
        }

        @Override
        public UpdateAction.Builder addCollection(Thing.Builder value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/collection", value.build());
        }

        @Override
        public UpdateAction.Builder addCollection(String value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/collection", Text.of(value));
        }

        @Override
        public UpdateAction.Builder addDescription(Text value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public UpdateAction.Builder addDescription(String value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public UpdateAction.Builder addEndTime(DateTime value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/endTime", value);
        }

        @Override
        public UpdateAction.Builder addEndTime(String value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/endTime", Text.of(value));
        }

        @Override
        public UpdateAction.Builder addError(Thing value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/error", value);
        }

        @Override
        public UpdateAction.Builder addError(Thing.Builder value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/error", value.build());
        }

        @Override
        public UpdateAction.Builder addError(String value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/error", Text.of(value));
        }

        @Override
        public UpdateAction.Builder addImage(ImageObject value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public UpdateAction.Builder addImage(ImageObject.Builder value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public UpdateAction.Builder addImage(URL value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public UpdateAction.Builder addImage(String value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public UpdateAction.Builder addInstrument(Thing value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/instrument", value);
        }

        @Override
        public UpdateAction.Builder addInstrument(Thing.Builder value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/instrument", value.build());
        }

        @Override
        public UpdateAction.Builder addInstrument(String value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/instrument", Text.of(value));
        }

        @Override
        public UpdateAction.Builder addLocation(Place value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/location", value);
        }

        @Override
        public UpdateAction.Builder addLocation(Place.Builder value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/location", value.build());
        }

        @Override
        public UpdateAction.Builder addLocation(PostalAddress value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/location", value);
        }

        @Override
        public UpdateAction.Builder addLocation(PostalAddress.Builder value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/location", value.build());
        }

        @Override
        public UpdateAction.Builder addLocation(Text value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/location", value);
        }

        @Override
        public UpdateAction.Builder addLocation(String value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/location", Text.of(value));
        }

        @Override
        public UpdateAction.Builder addMainEntityOfPage(CreativeWork value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public UpdateAction.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public UpdateAction.Builder addMainEntityOfPage(URL value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public UpdateAction.Builder addMainEntityOfPage(String value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public UpdateAction.Builder addName(Text value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public UpdateAction.Builder addName(String value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public UpdateAction.Builder addObject(Thing value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/object", value);
        }

        @Override
        public UpdateAction.Builder addObject(Thing.Builder value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/object", value.build());
        }

        @Override
        public UpdateAction.Builder addObject(String value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/object", Text.of(value));
        }

        @Override
        public UpdateAction.Builder addParticipant(Organization value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/participant", value);
        }

        @Override
        public UpdateAction.Builder addParticipant(Organization.Builder value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/participant", value.build());
        }

        @Override
        public UpdateAction.Builder addParticipant(Person value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/participant", value);
        }

        @Override
        public UpdateAction.Builder addParticipant(Person.Builder value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/participant", value.build());
        }

        @Override
        public UpdateAction.Builder addParticipant(String value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/participant", Text.of(value));
        }

        @Override
        public UpdateAction.Builder addPotentialAction(Action value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public UpdateAction.Builder addPotentialAction(Action.Builder value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public UpdateAction.Builder addPotentialAction(String value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public UpdateAction.Builder addResult(Thing value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/result", value);
        }

        @Override
        public UpdateAction.Builder addResult(Thing.Builder value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/result", value.build());
        }

        @Override
        public UpdateAction.Builder addResult(String value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/result", Text.of(value));
        }

        @Override
        public UpdateAction.Builder addSameAs(URL value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public UpdateAction.Builder addSameAs(String value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public UpdateAction.Builder addStartTime(DateTime value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/startTime", value);
        }

        @Override
        public UpdateAction.Builder addStartTime(String value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/startTime", Text.of(value));
        }

        @Override
        public UpdateAction.Builder addTarget(EntryPoint value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/target", value);
        }

        @Override
        public UpdateAction.Builder addTarget(EntryPoint.Builder value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/target", value.build());
        }

        @Override
        public UpdateAction.Builder addTarget(String value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/target", Text.of(value));
        }

        @Override
        public UpdateAction.Builder addTargetCollection(Thing value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/targetCollection", value);
        }

        @Override
        public UpdateAction.Builder addTargetCollection(Thing.Builder value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/targetCollection", value.build());
        }

        @Override
        public UpdateAction.Builder addTargetCollection(String value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/targetCollection", Text.of(value));
        }

        @Override
        public UpdateAction.Builder addUrl(URL value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public UpdateAction.Builder addUrl(String value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public UpdateAction.Builder addDetailedDescription(Article value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public UpdateAction.Builder addDetailedDescription(Article.Builder value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public UpdateAction.Builder addDetailedDescription(String value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public UpdateAction.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public UpdateAction.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public UpdateAction.Builder addPopularityScore(String value) {
            return (UpdateAction.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public UpdateAction build() {
            return new UpdateActionImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

