/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Rating;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class RatingImpl
extends IntangibleImpl
implements Rating {
    private static final ImmutableSet<String> PROPERTY_SET = RatingImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/bestRating");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/ratingValue");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/worstRating");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public RatingImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Rating";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getBestRatingList() {
        return this.getProperty("http://schema.org/bestRating");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRatingValueList() {
        return this.getProperty("http://schema.org/ratingValue");
    }

    @Override
    public ImmutableList<SchemaOrgType> getWorstRatingList() {
        return this.getProperty("http://schema.org/worstRating");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Rating.Builder>
    implements Rating.Builder {
        BuilderImpl() {
        }

        @Override
        public Rating.Builder addAdditionalType(URL value) {
            return (Rating.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Rating.Builder addAdditionalType(String value) {
            return (Rating.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Rating.Builder addAlternateName(Text value) {
            return (Rating.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Rating.Builder addAlternateName(String value) {
            return (Rating.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Rating.Builder addBestRating(Number value) {
            return (Rating.Builder)this.addProperty("http://schema.org/bestRating", value);
        }

        @Override
        public Rating.Builder addBestRating(Text value) {
            return (Rating.Builder)this.addProperty("http://schema.org/bestRating", value);
        }

        @Override
        public Rating.Builder addBestRating(String value) {
            return (Rating.Builder)this.addProperty("http://schema.org/bestRating", Text.of(value));
        }

        @Override
        public Rating.Builder addDescription(Text value) {
            return (Rating.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Rating.Builder addDescription(String value) {
            return (Rating.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Rating.Builder addImage(ImageObject value) {
            return (Rating.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Rating.Builder addImage(ImageObject.Builder value) {
            return (Rating.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Rating.Builder addImage(URL value) {
            return (Rating.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Rating.Builder addImage(String value) {
            return (Rating.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Rating.Builder addMainEntityOfPage(CreativeWork value) {
            return (Rating.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Rating.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Rating.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Rating.Builder addMainEntityOfPage(URL value) {
            return (Rating.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Rating.Builder addMainEntityOfPage(String value) {
            return (Rating.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Rating.Builder addName(Text value) {
            return (Rating.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Rating.Builder addName(String value) {
            return (Rating.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Rating.Builder addPotentialAction(Action value) {
            return (Rating.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Rating.Builder addPotentialAction(Action.Builder value) {
            return (Rating.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Rating.Builder addPotentialAction(String value) {
            return (Rating.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Rating.Builder addRatingValue(Text value) {
            return (Rating.Builder)this.addProperty("http://schema.org/ratingValue", value);
        }

        @Override
        public Rating.Builder addRatingValue(String value) {
            return (Rating.Builder)this.addProperty("http://schema.org/ratingValue", Text.of(value));
        }

        @Override
        public Rating.Builder addSameAs(URL value) {
            return (Rating.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Rating.Builder addSameAs(String value) {
            return (Rating.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Rating.Builder addUrl(URL value) {
            return (Rating.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Rating.Builder addUrl(String value) {
            return (Rating.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Rating.Builder addWorstRating(Number value) {
            return (Rating.Builder)this.addProperty("http://schema.org/worstRating", value);
        }

        @Override
        public Rating.Builder addWorstRating(Text value) {
            return (Rating.Builder)this.addProperty("http://schema.org/worstRating", value);
        }

        @Override
        public Rating.Builder addWorstRating(String value) {
            return (Rating.Builder)this.addProperty("http://schema.org/worstRating", Text.of(value));
        }

        @Override
        public Rating.Builder addDetailedDescription(Article value) {
            return (Rating.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Rating.Builder addDetailedDescription(Article.Builder value) {
            return (Rating.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Rating.Builder addDetailedDescription(String value) {
            return (Rating.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Rating.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Rating.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Rating.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Rating.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Rating.Builder addPopularityScore(String value) {
            return (Rating.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Rating build() {
            return new RatingImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

