/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AnatomicalStructure;
import com.google.schemaorg.core.AnatomicalStructureImpl;
import com.google.schemaorg.core.AnatomicalSystem;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalCondition;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalTherapy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Muscle;
import com.google.schemaorg.core.Nerve;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.Vessel;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MuscleImpl
extends AnatomicalStructureImpl
implements Muscle {
    private static final ImmutableSet<String> PROPERTY_SET = MuscleImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/action");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/antagonist");
        builder.add((Object)"http://schema.org/associatedPathophysiology");
        builder.add((Object)"http://schema.org/bloodSupply");
        builder.add((Object)"http://schema.org/bodyLocation");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/connectedTo");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/diagram");
        builder.add((Object)"http://schema.org/function");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/insertion");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/muscleAction");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/nerve");
        builder.add((Object)"http://schema.org/origin");
        builder.add((Object)"http://schema.org/partOfSystem");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relatedCondition");
        builder.add((Object)"http://schema.org/relatedTherapy");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/subStructure");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MuscleImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Muscle";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getActionList() {
        return this.getProperty("http://schema.org/action");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAntagonistList() {
        return this.getProperty("http://schema.org/antagonist");
    }

    @Override
    public ImmutableList<SchemaOrgType> getBloodSupplyList() {
        return this.getProperty("http://schema.org/bloodSupply");
    }

    @Override
    public ImmutableList<SchemaOrgType> getInsertionList() {
        return this.getProperty("http://schema.org/insertion");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMuscleActionList() {
        return this.getProperty("http://schema.org/muscleAction");
    }

    @Override
    public ImmutableList<SchemaOrgType> getNerveList() {
        return this.getProperty("http://schema.org/nerve");
    }

    @Override
    public ImmutableList<SchemaOrgType> getOriginList() {
        return this.getProperty("http://schema.org/origin");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Muscle.Builder>
    implements Muscle.Builder {
        BuilderImpl() {
        }

        @Override
        public Muscle.Builder addAction(Text value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/action", value);
        }

        @Override
        public Muscle.Builder addAction(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/action", Text.of(value));
        }

        @Override
        public Muscle.Builder addAdditionalType(URL value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Muscle.Builder addAdditionalType(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Muscle.Builder addAlternateName(Text value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Muscle.Builder addAlternateName(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Muscle.Builder addAntagonist(Muscle value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/antagonist", value);
        }

        @Override
        public Muscle.Builder addAntagonist(Muscle.Builder value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/antagonist", value.build());
        }

        @Override
        public Muscle.Builder addAntagonist(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/antagonist", Text.of(value));
        }

        @Override
        public Muscle.Builder addAssociatedPathophysiology(Text value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/associatedPathophysiology", value);
        }

        @Override
        public Muscle.Builder addAssociatedPathophysiology(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/associatedPathophysiology", Text.of(value));
        }

        @Override
        public Muscle.Builder addBloodSupply(Vessel value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/bloodSupply", value);
        }

        @Override
        public Muscle.Builder addBloodSupply(Vessel.Builder value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/bloodSupply", value.build());
        }

        @Override
        public Muscle.Builder addBloodSupply(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/bloodSupply", Text.of(value));
        }

        @Override
        public Muscle.Builder addBodyLocation(Text value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/bodyLocation", value);
        }

        @Override
        public Muscle.Builder addBodyLocation(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/bodyLocation", Text.of(value));
        }

        @Override
        public Muscle.Builder addCode(MedicalCode value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public Muscle.Builder addCode(MedicalCode.Builder value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public Muscle.Builder addCode(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public Muscle.Builder addConnectedTo(AnatomicalStructure value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/connectedTo", value);
        }

        @Override
        public Muscle.Builder addConnectedTo(AnatomicalStructure.Builder value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/connectedTo", value.build());
        }

        @Override
        public Muscle.Builder addConnectedTo(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/connectedTo", Text.of(value));
        }

        @Override
        public Muscle.Builder addDescription(Text value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Muscle.Builder addDescription(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Muscle.Builder addDiagram(ImageObject value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/diagram", value);
        }

        @Override
        public Muscle.Builder addDiagram(ImageObject.Builder value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/diagram", value.build());
        }

        @Override
        public Muscle.Builder addDiagram(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/diagram", Text.of(value));
        }

        @Override
        public Muscle.Builder addFunction(Text value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/function", value);
        }

        @Override
        public Muscle.Builder addFunction(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/function", Text.of(value));
        }

        @Override
        public Muscle.Builder addGuideline(MedicalGuideline value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public Muscle.Builder addGuideline(MedicalGuideline.Builder value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public Muscle.Builder addGuideline(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public Muscle.Builder addImage(ImageObject value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Muscle.Builder addImage(ImageObject.Builder value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Muscle.Builder addImage(URL value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Muscle.Builder addImage(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Muscle.Builder addInsertion(AnatomicalStructure value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/insertion", value);
        }

        @Override
        public Muscle.Builder addInsertion(AnatomicalStructure.Builder value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/insertion", value.build());
        }

        @Override
        public Muscle.Builder addInsertion(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/insertion", Text.of(value));
        }

        @Override
        public Muscle.Builder addMainEntityOfPage(CreativeWork value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Muscle.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Muscle.Builder addMainEntityOfPage(URL value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Muscle.Builder addMainEntityOfPage(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Muscle.Builder addMedicineSystem(MedicineSystem value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public Muscle.Builder addMedicineSystem(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public Muscle.Builder addMuscleAction(Text value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/muscleAction", value);
        }

        @Override
        public Muscle.Builder addMuscleAction(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/muscleAction", Text.of(value));
        }

        @Override
        public Muscle.Builder addName(Text value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Muscle.Builder addName(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Muscle.Builder addNerve(Nerve value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/nerve", value);
        }

        @Override
        public Muscle.Builder addNerve(Nerve.Builder value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/nerve", value.build());
        }

        @Override
        public Muscle.Builder addNerve(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/nerve", Text.of(value));
        }

        @Override
        public Muscle.Builder addOrigin(AnatomicalStructure value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/origin", value);
        }

        @Override
        public Muscle.Builder addOrigin(AnatomicalStructure.Builder value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/origin", value.build());
        }

        @Override
        public Muscle.Builder addOrigin(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/origin", Text.of(value));
        }

        @Override
        public Muscle.Builder addPartOfSystem(AnatomicalSystem value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/partOfSystem", value);
        }

        @Override
        public Muscle.Builder addPartOfSystem(AnatomicalSystem.Builder value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/partOfSystem", value.build());
        }

        @Override
        public Muscle.Builder addPartOfSystem(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/partOfSystem", Text.of(value));
        }

        @Override
        public Muscle.Builder addPotentialAction(Action value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Muscle.Builder addPotentialAction(Action.Builder value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Muscle.Builder addPotentialAction(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Muscle.Builder addRecognizingAuthority(Organization value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public Muscle.Builder addRecognizingAuthority(Organization.Builder value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public Muscle.Builder addRecognizingAuthority(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public Muscle.Builder addRelatedCondition(MedicalCondition value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/relatedCondition", value);
        }

        @Override
        public Muscle.Builder addRelatedCondition(MedicalCondition.Builder value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/relatedCondition", value.build());
        }

        @Override
        public Muscle.Builder addRelatedCondition(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/relatedCondition", Text.of(value));
        }

        @Override
        public Muscle.Builder addRelatedTherapy(MedicalTherapy value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/relatedTherapy", value);
        }

        @Override
        public Muscle.Builder addRelatedTherapy(MedicalTherapy.Builder value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/relatedTherapy", value.build());
        }

        @Override
        public Muscle.Builder addRelatedTherapy(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/relatedTherapy", Text.of(value));
        }

        @Override
        public Muscle.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public Muscle.Builder addRelevantSpecialty(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public Muscle.Builder addSameAs(URL value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Muscle.Builder addSameAs(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Muscle.Builder addStudy(MedicalStudy value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public Muscle.Builder addStudy(MedicalStudy.Builder value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public Muscle.Builder addStudy(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public Muscle.Builder addSubStructure(AnatomicalStructure value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/subStructure", value);
        }

        @Override
        public Muscle.Builder addSubStructure(AnatomicalStructure.Builder value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/subStructure", value.build());
        }

        @Override
        public Muscle.Builder addSubStructure(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/subStructure", Text.of(value));
        }

        @Override
        public Muscle.Builder addUrl(URL value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Muscle.Builder addUrl(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Muscle.Builder addDetailedDescription(Article value) {
            return (Muscle.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Muscle.Builder addDetailedDescription(Article.Builder value) {
            return (Muscle.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Muscle.Builder addDetailedDescription(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Muscle.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Muscle.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Muscle.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Muscle.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Muscle.Builder addPopularityScore(String value) {
            return (Muscle.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Muscle build() {
            return new MuscleImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

