/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.Country;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkImpl;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.Movie;
import com.google.schemaorg.core.MusicGroup;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MovieImpl
extends CreativeWorkImpl
implements Movie {
    private static final ImmutableSet<String> PROPERTY_SET = MovieImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/actor");
        builder.add((Object)"http://schema.org/actors");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/countryOfOrigin");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/director");
        builder.add((Object)"http://schema.org/directors");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/duration");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/musicBy");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/productionCompany");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/subtitleLanguage");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/trailer");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MovieImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Movie";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getActorList() {
        return this.getProperty("http://schema.org/actor");
    }

    @Override
    public ImmutableList<SchemaOrgType> getActorsList() {
        return this.getProperty("http://schema.org/actors");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCountryOfOriginList() {
        return this.getProperty("http://schema.org/countryOfOrigin");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDirectorList() {
        return this.getProperty("http://schema.org/director");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDirectorsList() {
        return this.getProperty("http://schema.org/directors");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDurationList() {
        return this.getProperty("http://schema.org/duration");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMusicByList() {
        return this.getProperty("http://schema.org/musicBy");
    }

    @Override
    public ImmutableList<SchemaOrgType> getProductionCompanyList() {
        return this.getProperty("http://schema.org/productionCompany");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSubtitleLanguageList() {
        return this.getProperty("http://schema.org/subtitleLanguage");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTrailerList() {
        return this.getProperty("http://schema.org/trailer");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Movie.Builder>
    implements Movie.Builder {
        BuilderImpl() {
        }

        @Override
        public Movie.Builder addAbout(Thing value) {
            return (Movie.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public Movie.Builder addAbout(Thing.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public Movie.Builder addAbout(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public Movie.Builder addAccessibilityAPI(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public Movie.Builder addAccessibilityAPI(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public Movie.Builder addAccessibilityControl(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public Movie.Builder addAccessibilityControl(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public Movie.Builder addAccessibilityFeature(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public Movie.Builder addAccessibilityFeature(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public Movie.Builder addAccessibilityHazard(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public Movie.Builder addAccessibilityHazard(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public Movie.Builder addAccountablePerson(Person value) {
            return (Movie.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public Movie.Builder addAccountablePerson(Person.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public Movie.Builder addAccountablePerson(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public Movie.Builder addActor(Person value) {
            return (Movie.Builder)this.addProperty("http://schema.org/actor", value);
        }

        @Override
        public Movie.Builder addActor(Person.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/actor", value.build());
        }

        @Override
        public Movie.Builder addActor(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/actor", Text.of(value));
        }

        @Override
        public Movie.Builder addActors(Person value) {
            return (Movie.Builder)this.addProperty("http://schema.org/actors", value);
        }

        @Override
        public Movie.Builder addActors(Person.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/actors", value.build());
        }

        @Override
        public Movie.Builder addActors(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/actors", Text.of(value));
        }

        @Override
        public Movie.Builder addAdditionalType(URL value) {
            return (Movie.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Movie.Builder addAdditionalType(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Movie.Builder addAggregateRating(AggregateRating value) {
            return (Movie.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public Movie.Builder addAggregateRating(AggregateRating.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public Movie.Builder addAggregateRating(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public Movie.Builder addAlternateName(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Movie.Builder addAlternateName(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Movie.Builder addAlternativeHeadline(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public Movie.Builder addAlternativeHeadline(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public Movie.Builder addAssociatedMedia(MediaObject value) {
            return (Movie.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public Movie.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public Movie.Builder addAssociatedMedia(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public Movie.Builder addAudience(Audience value) {
            return (Movie.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public Movie.Builder addAudience(Audience.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public Movie.Builder addAudience(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public Movie.Builder addAudio(AudioObject value) {
            return (Movie.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public Movie.Builder addAudio(AudioObject.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public Movie.Builder addAudio(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public Movie.Builder addAuthor(Organization value) {
            return (Movie.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Movie.Builder addAuthor(Organization.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Movie.Builder addAuthor(Person value) {
            return (Movie.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Movie.Builder addAuthor(Person.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Movie.Builder addAuthor(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public Movie.Builder addAward(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public Movie.Builder addAward(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public Movie.Builder addAwards(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public Movie.Builder addAwards(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public Movie.Builder addCharacter(Person value) {
            return (Movie.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public Movie.Builder addCharacter(Person.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public Movie.Builder addCharacter(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public Movie.Builder addCitation(CreativeWork value) {
            return (Movie.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Movie.Builder addCitation(CreativeWork.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public Movie.Builder addCitation(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Movie.Builder addCitation(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public Movie.Builder addComment(Comment value) {
            return (Movie.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public Movie.Builder addComment(Comment.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public Movie.Builder addComment(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public Movie.Builder addCommentCount(Integer value) {
            return (Movie.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public Movie.Builder addCommentCount(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public Movie.Builder addContentLocation(Place value) {
            return (Movie.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public Movie.Builder addContentLocation(Place.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public Movie.Builder addContentLocation(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public Movie.Builder addContentRating(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public Movie.Builder addContentRating(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public Movie.Builder addContributor(Organization value) {
            return (Movie.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Movie.Builder addContributor(Organization.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Movie.Builder addContributor(Person value) {
            return (Movie.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Movie.Builder addContributor(Person.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Movie.Builder addContributor(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public Movie.Builder addCopyrightHolder(Organization value) {
            return (Movie.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Movie.Builder addCopyrightHolder(Organization.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Movie.Builder addCopyrightHolder(Person value) {
            return (Movie.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Movie.Builder addCopyrightHolder(Person.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Movie.Builder addCopyrightHolder(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public Movie.Builder addCopyrightYear(Number value) {
            return (Movie.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public Movie.Builder addCopyrightYear(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public Movie.Builder addCountryOfOrigin(Country value) {
            return (Movie.Builder)this.addProperty("http://schema.org/countryOfOrigin", value);
        }

        @Override
        public Movie.Builder addCountryOfOrigin(Country.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/countryOfOrigin", value.build());
        }

        @Override
        public Movie.Builder addCountryOfOrigin(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/countryOfOrigin", Text.of(value));
        }

        @Override
        public Movie.Builder addCreator(Organization value) {
            return (Movie.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Movie.Builder addCreator(Organization.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Movie.Builder addCreator(Person value) {
            return (Movie.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Movie.Builder addCreator(Person.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Movie.Builder addCreator(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public Movie.Builder addDateCreated(Date value) {
            return (Movie.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Movie.Builder addDateCreated(DateTime value) {
            return (Movie.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Movie.Builder addDateCreated(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public Movie.Builder addDateModified(Date value) {
            return (Movie.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Movie.Builder addDateModified(DateTime value) {
            return (Movie.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Movie.Builder addDateModified(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public Movie.Builder addDatePublished(Date value) {
            return (Movie.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public Movie.Builder addDatePublished(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public Movie.Builder addDescription(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Movie.Builder addDescription(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Movie.Builder addDirector(Person value) {
            return (Movie.Builder)this.addProperty("http://schema.org/director", value);
        }

        @Override
        public Movie.Builder addDirector(Person.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/director", value.build());
        }

        @Override
        public Movie.Builder addDirector(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/director", Text.of(value));
        }

        @Override
        public Movie.Builder addDirectors(Person value) {
            return (Movie.Builder)this.addProperty("http://schema.org/directors", value);
        }

        @Override
        public Movie.Builder addDirectors(Person.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/directors", value.build());
        }

        @Override
        public Movie.Builder addDirectors(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/directors", Text.of(value));
        }

        @Override
        public Movie.Builder addDiscussionUrl(URL value) {
            return (Movie.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public Movie.Builder addDiscussionUrl(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public Movie.Builder addDuration(Duration value) {
            return (Movie.Builder)this.addProperty("http://schema.org/duration", value);
        }

        @Override
        public Movie.Builder addDuration(Duration.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/duration", value.build());
        }

        @Override
        public Movie.Builder addDuration(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/duration", Text.of(value));
        }

        @Override
        public Movie.Builder addEditor(Person value) {
            return (Movie.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public Movie.Builder addEditor(Person.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public Movie.Builder addEditor(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public Movie.Builder addEducationalAlignment(AlignmentObject value) {
            return (Movie.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public Movie.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public Movie.Builder addEducationalAlignment(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public Movie.Builder addEducationalUse(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public Movie.Builder addEducationalUse(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public Movie.Builder addEncoding(MediaObject value) {
            return (Movie.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public Movie.Builder addEncoding(MediaObject.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public Movie.Builder addEncoding(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public Movie.Builder addEncodings(MediaObject value) {
            return (Movie.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public Movie.Builder addEncodings(MediaObject.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public Movie.Builder addEncodings(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public Movie.Builder addExampleOfWork(CreativeWork value) {
            return (Movie.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public Movie.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public Movie.Builder addExampleOfWork(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public Movie.Builder addFileFormat(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public Movie.Builder addFileFormat(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public Movie.Builder addGenre(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Movie.Builder addGenre(URL value) {
            return (Movie.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Movie.Builder addGenre(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public Movie.Builder addHasPart(CreativeWork value) {
            return (Movie.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public Movie.Builder addHasPart(CreativeWork.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public Movie.Builder addHasPart(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public Movie.Builder addHeadline(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public Movie.Builder addHeadline(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public Movie.Builder addImage(ImageObject value) {
            return (Movie.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Movie.Builder addImage(ImageObject.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Movie.Builder addImage(URL value) {
            return (Movie.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Movie.Builder addImage(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Movie.Builder addInLanguage(Language value) {
            return (Movie.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Movie.Builder addInLanguage(Language.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public Movie.Builder addInLanguage(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Movie.Builder addInLanguage(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public Movie.Builder addInteractionStatistic(InteractionCounter value) {
            return (Movie.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public Movie.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public Movie.Builder addInteractionStatistic(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public Movie.Builder addInteractivityType(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public Movie.Builder addInteractivityType(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public Movie.Builder addIsBasedOnUrl(URL value) {
            return (Movie.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public Movie.Builder addIsBasedOnUrl(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public Movie.Builder addIsFamilyFriendly(Boolean value) {
            return (Movie.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public Movie.Builder addIsFamilyFriendly(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public Movie.Builder addIsPartOf(CreativeWork value) {
            return (Movie.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public Movie.Builder addIsPartOf(CreativeWork.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public Movie.Builder addIsPartOf(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public Movie.Builder addKeywords(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public Movie.Builder addKeywords(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public Movie.Builder addLearningResourceType(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public Movie.Builder addLearningResourceType(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public Movie.Builder addLicense(CreativeWork value) {
            return (Movie.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Movie.Builder addLicense(CreativeWork.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public Movie.Builder addLicense(URL value) {
            return (Movie.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Movie.Builder addLicense(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public Movie.Builder addLocationCreated(Place value) {
            return (Movie.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public Movie.Builder addLocationCreated(Place.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public Movie.Builder addLocationCreated(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public Movie.Builder addMainEntity(Thing value) {
            return (Movie.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public Movie.Builder addMainEntity(Thing.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public Movie.Builder addMainEntity(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public Movie.Builder addMainEntityOfPage(CreativeWork value) {
            return (Movie.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Movie.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Movie.Builder addMainEntityOfPage(URL value) {
            return (Movie.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Movie.Builder addMainEntityOfPage(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Movie.Builder addMentions(Thing value) {
            return (Movie.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public Movie.Builder addMentions(Thing.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public Movie.Builder addMentions(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public Movie.Builder addMusicBy(MusicGroup value) {
            return (Movie.Builder)this.addProperty("http://schema.org/musicBy", value);
        }

        @Override
        public Movie.Builder addMusicBy(MusicGroup.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/musicBy", value.build());
        }

        @Override
        public Movie.Builder addMusicBy(Person value) {
            return (Movie.Builder)this.addProperty("http://schema.org/musicBy", value);
        }

        @Override
        public Movie.Builder addMusicBy(Person.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/musicBy", value.build());
        }

        @Override
        public Movie.Builder addMusicBy(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/musicBy", Text.of(value));
        }

        @Override
        public Movie.Builder addName(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Movie.Builder addName(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Movie.Builder addOffers(Offer value) {
            return (Movie.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public Movie.Builder addOffers(Offer.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public Movie.Builder addOffers(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public Movie.Builder addPosition(Integer value) {
            return (Movie.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Movie.Builder addPosition(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Movie.Builder addPosition(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public Movie.Builder addPotentialAction(Action value) {
            return (Movie.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Movie.Builder addPotentialAction(Action.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Movie.Builder addPotentialAction(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Movie.Builder addProducer(Organization value) {
            return (Movie.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Movie.Builder addProducer(Organization.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Movie.Builder addProducer(Person value) {
            return (Movie.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Movie.Builder addProducer(Person.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Movie.Builder addProducer(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public Movie.Builder addProductionCompany(Organization value) {
            return (Movie.Builder)this.addProperty("http://schema.org/productionCompany", value);
        }

        @Override
        public Movie.Builder addProductionCompany(Organization.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/productionCompany", value.build());
        }

        @Override
        public Movie.Builder addProductionCompany(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/productionCompany", Text.of(value));
        }

        @Override
        public Movie.Builder addProvider(Organization value) {
            return (Movie.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Movie.Builder addProvider(Organization.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Movie.Builder addProvider(Person value) {
            return (Movie.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Movie.Builder addProvider(Person.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Movie.Builder addProvider(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public Movie.Builder addPublication(PublicationEvent value) {
            return (Movie.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public Movie.Builder addPublication(PublicationEvent.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public Movie.Builder addPublication(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public Movie.Builder addPublisher(Organization value) {
            return (Movie.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Movie.Builder addPublisher(Organization.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Movie.Builder addPublisher(Person value) {
            return (Movie.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Movie.Builder addPublisher(Person.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Movie.Builder addPublisher(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public Movie.Builder addPublishingPrinciples(URL value) {
            return (Movie.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public Movie.Builder addPublishingPrinciples(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public Movie.Builder addRecordedAt(Event value) {
            return (Movie.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public Movie.Builder addRecordedAt(Event.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public Movie.Builder addRecordedAt(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public Movie.Builder addReleasedEvent(PublicationEvent value) {
            return (Movie.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public Movie.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public Movie.Builder addReleasedEvent(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public Movie.Builder addReview(Review value) {
            return (Movie.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public Movie.Builder addReview(Review.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public Movie.Builder addReview(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public Movie.Builder addReviews(Review value) {
            return (Movie.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public Movie.Builder addReviews(Review.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public Movie.Builder addReviews(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public Movie.Builder addSameAs(URL value) {
            return (Movie.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Movie.Builder addSameAs(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Movie.Builder addSchemaVersion(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Movie.Builder addSchemaVersion(URL value) {
            return (Movie.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Movie.Builder addSchemaVersion(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public Movie.Builder addSourceOrganization(Organization value) {
            return (Movie.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public Movie.Builder addSourceOrganization(Organization.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public Movie.Builder addSourceOrganization(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public Movie.Builder addSubtitleLanguage(Language value) {
            return (Movie.Builder)this.addProperty("http://schema.org/subtitleLanguage", value);
        }

        @Override
        public Movie.Builder addSubtitleLanguage(Language.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/subtitleLanguage", value.build());
        }

        @Override
        public Movie.Builder addSubtitleLanguage(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/subtitleLanguage", value);
        }

        @Override
        public Movie.Builder addSubtitleLanguage(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/subtitleLanguage", Text.of(value));
        }

        @Override
        public Movie.Builder addText(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public Movie.Builder addText(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public Movie.Builder addThumbnailUrl(URL value) {
            return (Movie.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public Movie.Builder addThumbnailUrl(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public Movie.Builder addTimeRequired(Duration value) {
            return (Movie.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public Movie.Builder addTimeRequired(Duration.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public Movie.Builder addTimeRequired(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public Movie.Builder addTrailer(VideoObject value) {
            return (Movie.Builder)this.addProperty("http://schema.org/trailer", value);
        }

        @Override
        public Movie.Builder addTrailer(VideoObject.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/trailer", value.build());
        }

        @Override
        public Movie.Builder addTrailer(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/trailer", Text.of(value));
        }

        @Override
        public Movie.Builder addTranslator(Organization value) {
            return (Movie.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Movie.Builder addTranslator(Organization.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Movie.Builder addTranslator(Person value) {
            return (Movie.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Movie.Builder addTranslator(Person.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Movie.Builder addTranslator(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public Movie.Builder addTypicalAgeRange(Text value) {
            return (Movie.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public Movie.Builder addTypicalAgeRange(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public Movie.Builder addUrl(URL value) {
            return (Movie.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Movie.Builder addUrl(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Movie.Builder addVersion(Number value) {
            return (Movie.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public Movie.Builder addVersion(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public Movie.Builder addVideo(VideoObject value) {
            return (Movie.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public Movie.Builder addVideo(VideoObject.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public Movie.Builder addVideo(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public Movie.Builder addWorkExample(CreativeWork value) {
            return (Movie.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public Movie.Builder addWorkExample(CreativeWork.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public Movie.Builder addWorkExample(String value) {
            return (Movie.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public Movie.Builder addDetailedDescription(Article value) {
            return (Movie.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Movie.Builder addDetailedDescription(Article.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Movie.Builder addDetailedDescription(String value) {
            return (Movie.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Movie.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Movie.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Movie.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Movie.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Movie.Builder addPopularityScore(String value) {
            return (Movie.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Movie build() {
            return new MovieImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

