/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkImpl;
import com.google.schemaorg.core.CreativeWorkSeason;
import com.google.schemaorg.core.CreativeWorkSeries;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Episode;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.MusicGroup;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class EpisodeImpl
extends CreativeWorkImpl
implements Episode {
    private static final ImmutableSet<String> PROPERTY_SET = EpisodeImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/actor");
        builder.add((Object)"http://schema.org/actors");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/director");
        builder.add((Object)"http://schema.org/directors");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/episodeNumber");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/musicBy");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/partOfSeason");
        builder.add((Object)"http://schema.org/partOfSeries");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/productionCompany");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/trailer");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public EpisodeImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Episode";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getActorList() {
        return this.getProperty("http://schema.org/actor");
    }

    @Override
    public ImmutableList<SchemaOrgType> getActorsList() {
        return this.getProperty("http://schema.org/actors");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDirectorList() {
        return this.getProperty("http://schema.org/director");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDirectorsList() {
        return this.getProperty("http://schema.org/directors");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEpisodeNumberList() {
        return this.getProperty("http://schema.org/episodeNumber");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMusicByList() {
        return this.getProperty("http://schema.org/musicBy");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPartOfSeasonList() {
        return this.getProperty("http://schema.org/partOfSeason");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPartOfSeriesList() {
        return this.getProperty("http://schema.org/partOfSeries");
    }

    @Override
    public ImmutableList<SchemaOrgType> getProductionCompanyList() {
        return this.getProperty("http://schema.org/productionCompany");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTrailerList() {
        return this.getProperty("http://schema.org/trailer");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Episode.Builder>
    implements Episode.Builder {
        BuilderImpl() {
        }

        @Override
        public Episode.Builder addAbout(Thing value) {
            return (Episode.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public Episode.Builder addAbout(Thing.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public Episode.Builder addAbout(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public Episode.Builder addAccessibilityAPI(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public Episode.Builder addAccessibilityAPI(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public Episode.Builder addAccessibilityControl(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public Episode.Builder addAccessibilityControl(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public Episode.Builder addAccessibilityFeature(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public Episode.Builder addAccessibilityFeature(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public Episode.Builder addAccessibilityHazard(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public Episode.Builder addAccessibilityHazard(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public Episode.Builder addAccountablePerson(Person value) {
            return (Episode.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public Episode.Builder addAccountablePerson(Person.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public Episode.Builder addAccountablePerson(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public Episode.Builder addActor(Person value) {
            return (Episode.Builder)this.addProperty("http://schema.org/actor", value);
        }

        @Override
        public Episode.Builder addActor(Person.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/actor", value.build());
        }

        @Override
        public Episode.Builder addActor(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/actor", Text.of(value));
        }

        @Override
        public Episode.Builder addActors(Person value) {
            return (Episode.Builder)this.addProperty("http://schema.org/actors", value);
        }

        @Override
        public Episode.Builder addActors(Person.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/actors", value.build());
        }

        @Override
        public Episode.Builder addActors(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/actors", Text.of(value));
        }

        @Override
        public Episode.Builder addAdditionalType(URL value) {
            return (Episode.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Episode.Builder addAdditionalType(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Episode.Builder addAggregateRating(AggregateRating value) {
            return (Episode.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public Episode.Builder addAggregateRating(AggregateRating.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public Episode.Builder addAggregateRating(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public Episode.Builder addAlternateName(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Episode.Builder addAlternateName(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Episode.Builder addAlternativeHeadline(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public Episode.Builder addAlternativeHeadline(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public Episode.Builder addAssociatedMedia(MediaObject value) {
            return (Episode.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public Episode.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public Episode.Builder addAssociatedMedia(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public Episode.Builder addAudience(Audience value) {
            return (Episode.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public Episode.Builder addAudience(Audience.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public Episode.Builder addAudience(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public Episode.Builder addAudio(AudioObject value) {
            return (Episode.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public Episode.Builder addAudio(AudioObject.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public Episode.Builder addAudio(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public Episode.Builder addAuthor(Organization value) {
            return (Episode.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Episode.Builder addAuthor(Organization.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Episode.Builder addAuthor(Person value) {
            return (Episode.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Episode.Builder addAuthor(Person.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Episode.Builder addAuthor(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public Episode.Builder addAward(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public Episode.Builder addAward(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public Episode.Builder addAwards(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public Episode.Builder addAwards(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public Episode.Builder addCharacter(Person value) {
            return (Episode.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public Episode.Builder addCharacter(Person.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public Episode.Builder addCharacter(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public Episode.Builder addCitation(CreativeWork value) {
            return (Episode.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Episode.Builder addCitation(CreativeWork.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public Episode.Builder addCitation(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Episode.Builder addCitation(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public Episode.Builder addComment(Comment value) {
            return (Episode.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public Episode.Builder addComment(Comment.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public Episode.Builder addComment(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public Episode.Builder addCommentCount(Integer value) {
            return (Episode.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public Episode.Builder addCommentCount(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public Episode.Builder addContentLocation(Place value) {
            return (Episode.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public Episode.Builder addContentLocation(Place.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public Episode.Builder addContentLocation(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public Episode.Builder addContentRating(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public Episode.Builder addContentRating(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public Episode.Builder addContributor(Organization value) {
            return (Episode.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Episode.Builder addContributor(Organization.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Episode.Builder addContributor(Person value) {
            return (Episode.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Episode.Builder addContributor(Person.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Episode.Builder addContributor(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public Episode.Builder addCopyrightHolder(Organization value) {
            return (Episode.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Episode.Builder addCopyrightHolder(Organization.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Episode.Builder addCopyrightHolder(Person value) {
            return (Episode.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Episode.Builder addCopyrightHolder(Person.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Episode.Builder addCopyrightHolder(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public Episode.Builder addCopyrightYear(Number value) {
            return (Episode.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public Episode.Builder addCopyrightYear(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public Episode.Builder addCreator(Organization value) {
            return (Episode.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Episode.Builder addCreator(Organization.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Episode.Builder addCreator(Person value) {
            return (Episode.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Episode.Builder addCreator(Person.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Episode.Builder addCreator(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public Episode.Builder addDateCreated(Date value) {
            return (Episode.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Episode.Builder addDateCreated(DateTime value) {
            return (Episode.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Episode.Builder addDateCreated(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public Episode.Builder addDateModified(Date value) {
            return (Episode.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Episode.Builder addDateModified(DateTime value) {
            return (Episode.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Episode.Builder addDateModified(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public Episode.Builder addDatePublished(Date value) {
            return (Episode.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public Episode.Builder addDatePublished(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public Episode.Builder addDescription(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Episode.Builder addDescription(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Episode.Builder addDirector(Person value) {
            return (Episode.Builder)this.addProperty("http://schema.org/director", value);
        }

        @Override
        public Episode.Builder addDirector(Person.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/director", value.build());
        }

        @Override
        public Episode.Builder addDirector(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/director", Text.of(value));
        }

        @Override
        public Episode.Builder addDirectors(Person value) {
            return (Episode.Builder)this.addProperty("http://schema.org/directors", value);
        }

        @Override
        public Episode.Builder addDirectors(Person.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/directors", value.build());
        }

        @Override
        public Episode.Builder addDirectors(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/directors", Text.of(value));
        }

        @Override
        public Episode.Builder addDiscussionUrl(URL value) {
            return (Episode.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public Episode.Builder addDiscussionUrl(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public Episode.Builder addEditor(Person value) {
            return (Episode.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public Episode.Builder addEditor(Person.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public Episode.Builder addEditor(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public Episode.Builder addEducationalAlignment(AlignmentObject value) {
            return (Episode.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public Episode.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public Episode.Builder addEducationalAlignment(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public Episode.Builder addEducationalUse(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public Episode.Builder addEducationalUse(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public Episode.Builder addEncoding(MediaObject value) {
            return (Episode.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public Episode.Builder addEncoding(MediaObject.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public Episode.Builder addEncoding(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public Episode.Builder addEncodings(MediaObject value) {
            return (Episode.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public Episode.Builder addEncodings(MediaObject.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public Episode.Builder addEncodings(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public Episode.Builder addEpisodeNumber(Integer value) {
            return (Episode.Builder)this.addProperty("http://schema.org/episodeNumber", value);
        }

        @Override
        public Episode.Builder addEpisodeNumber(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/episodeNumber", value);
        }

        @Override
        public Episode.Builder addEpisodeNumber(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/episodeNumber", Text.of(value));
        }

        @Override
        public Episode.Builder addExampleOfWork(CreativeWork value) {
            return (Episode.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public Episode.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public Episode.Builder addExampleOfWork(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public Episode.Builder addFileFormat(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public Episode.Builder addFileFormat(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public Episode.Builder addGenre(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Episode.Builder addGenre(URL value) {
            return (Episode.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Episode.Builder addGenre(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public Episode.Builder addHasPart(CreativeWork value) {
            return (Episode.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public Episode.Builder addHasPart(CreativeWork.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public Episode.Builder addHasPart(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public Episode.Builder addHeadline(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public Episode.Builder addHeadline(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public Episode.Builder addImage(ImageObject value) {
            return (Episode.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Episode.Builder addImage(ImageObject.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Episode.Builder addImage(URL value) {
            return (Episode.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Episode.Builder addImage(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Episode.Builder addInLanguage(Language value) {
            return (Episode.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Episode.Builder addInLanguage(Language.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public Episode.Builder addInLanguage(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Episode.Builder addInLanguage(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public Episode.Builder addInteractionStatistic(InteractionCounter value) {
            return (Episode.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public Episode.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public Episode.Builder addInteractionStatistic(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public Episode.Builder addInteractivityType(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public Episode.Builder addInteractivityType(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public Episode.Builder addIsBasedOnUrl(URL value) {
            return (Episode.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public Episode.Builder addIsBasedOnUrl(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public Episode.Builder addIsFamilyFriendly(Boolean value) {
            return (Episode.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public Episode.Builder addIsFamilyFriendly(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public Episode.Builder addIsPartOf(CreativeWork value) {
            return (Episode.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public Episode.Builder addIsPartOf(CreativeWork.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public Episode.Builder addIsPartOf(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public Episode.Builder addKeywords(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public Episode.Builder addKeywords(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public Episode.Builder addLearningResourceType(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public Episode.Builder addLearningResourceType(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public Episode.Builder addLicense(CreativeWork value) {
            return (Episode.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Episode.Builder addLicense(CreativeWork.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public Episode.Builder addLicense(URL value) {
            return (Episode.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Episode.Builder addLicense(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public Episode.Builder addLocationCreated(Place value) {
            return (Episode.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public Episode.Builder addLocationCreated(Place.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public Episode.Builder addLocationCreated(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public Episode.Builder addMainEntity(Thing value) {
            return (Episode.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public Episode.Builder addMainEntity(Thing.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public Episode.Builder addMainEntity(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public Episode.Builder addMainEntityOfPage(CreativeWork value) {
            return (Episode.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Episode.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Episode.Builder addMainEntityOfPage(URL value) {
            return (Episode.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Episode.Builder addMainEntityOfPage(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Episode.Builder addMentions(Thing value) {
            return (Episode.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public Episode.Builder addMentions(Thing.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public Episode.Builder addMentions(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public Episode.Builder addMusicBy(MusicGroup value) {
            return (Episode.Builder)this.addProperty("http://schema.org/musicBy", value);
        }

        @Override
        public Episode.Builder addMusicBy(MusicGroup.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/musicBy", value.build());
        }

        @Override
        public Episode.Builder addMusicBy(Person value) {
            return (Episode.Builder)this.addProperty("http://schema.org/musicBy", value);
        }

        @Override
        public Episode.Builder addMusicBy(Person.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/musicBy", value.build());
        }

        @Override
        public Episode.Builder addMusicBy(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/musicBy", Text.of(value));
        }

        @Override
        public Episode.Builder addName(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Episode.Builder addName(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Episode.Builder addOffers(Offer value) {
            return (Episode.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public Episode.Builder addOffers(Offer.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public Episode.Builder addOffers(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public Episode.Builder addPartOfSeason(CreativeWorkSeason value) {
            return (Episode.Builder)this.addProperty("http://schema.org/partOfSeason", value);
        }

        @Override
        public Episode.Builder addPartOfSeason(CreativeWorkSeason.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/partOfSeason", value.build());
        }

        @Override
        public Episode.Builder addPartOfSeason(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/partOfSeason", Text.of(value));
        }

        @Override
        public Episode.Builder addPartOfSeries(CreativeWorkSeries value) {
            return (Episode.Builder)this.addProperty("http://schema.org/partOfSeries", value);
        }

        @Override
        public Episode.Builder addPartOfSeries(CreativeWorkSeries.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/partOfSeries", value.build());
        }

        @Override
        public Episode.Builder addPartOfSeries(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/partOfSeries", Text.of(value));
        }

        @Override
        public Episode.Builder addPosition(Integer value) {
            return (Episode.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Episode.Builder addPosition(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Episode.Builder addPosition(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public Episode.Builder addPotentialAction(Action value) {
            return (Episode.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Episode.Builder addPotentialAction(Action.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Episode.Builder addPotentialAction(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Episode.Builder addProducer(Organization value) {
            return (Episode.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Episode.Builder addProducer(Organization.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Episode.Builder addProducer(Person value) {
            return (Episode.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Episode.Builder addProducer(Person.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Episode.Builder addProducer(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public Episode.Builder addProductionCompany(Organization value) {
            return (Episode.Builder)this.addProperty("http://schema.org/productionCompany", value);
        }

        @Override
        public Episode.Builder addProductionCompany(Organization.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/productionCompany", value.build());
        }

        @Override
        public Episode.Builder addProductionCompany(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/productionCompany", Text.of(value));
        }

        @Override
        public Episode.Builder addProvider(Organization value) {
            return (Episode.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Episode.Builder addProvider(Organization.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Episode.Builder addProvider(Person value) {
            return (Episode.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Episode.Builder addProvider(Person.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Episode.Builder addProvider(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public Episode.Builder addPublication(PublicationEvent value) {
            return (Episode.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public Episode.Builder addPublication(PublicationEvent.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public Episode.Builder addPublication(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public Episode.Builder addPublisher(Organization value) {
            return (Episode.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Episode.Builder addPublisher(Organization.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Episode.Builder addPublisher(Person value) {
            return (Episode.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Episode.Builder addPublisher(Person.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Episode.Builder addPublisher(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public Episode.Builder addPublishingPrinciples(URL value) {
            return (Episode.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public Episode.Builder addPublishingPrinciples(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public Episode.Builder addRecordedAt(Event value) {
            return (Episode.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public Episode.Builder addRecordedAt(Event.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public Episode.Builder addRecordedAt(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public Episode.Builder addReleasedEvent(PublicationEvent value) {
            return (Episode.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public Episode.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public Episode.Builder addReleasedEvent(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public Episode.Builder addReview(Review value) {
            return (Episode.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public Episode.Builder addReview(Review.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public Episode.Builder addReview(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public Episode.Builder addReviews(Review value) {
            return (Episode.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public Episode.Builder addReviews(Review.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public Episode.Builder addReviews(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public Episode.Builder addSameAs(URL value) {
            return (Episode.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Episode.Builder addSameAs(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Episode.Builder addSchemaVersion(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Episode.Builder addSchemaVersion(URL value) {
            return (Episode.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Episode.Builder addSchemaVersion(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public Episode.Builder addSourceOrganization(Organization value) {
            return (Episode.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public Episode.Builder addSourceOrganization(Organization.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public Episode.Builder addSourceOrganization(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public Episode.Builder addText(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public Episode.Builder addText(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public Episode.Builder addThumbnailUrl(URL value) {
            return (Episode.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public Episode.Builder addThumbnailUrl(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public Episode.Builder addTimeRequired(Duration value) {
            return (Episode.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public Episode.Builder addTimeRequired(Duration.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public Episode.Builder addTimeRequired(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public Episode.Builder addTrailer(VideoObject value) {
            return (Episode.Builder)this.addProperty("http://schema.org/trailer", value);
        }

        @Override
        public Episode.Builder addTrailer(VideoObject.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/trailer", value.build());
        }

        @Override
        public Episode.Builder addTrailer(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/trailer", Text.of(value));
        }

        @Override
        public Episode.Builder addTranslator(Organization value) {
            return (Episode.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Episode.Builder addTranslator(Organization.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Episode.Builder addTranslator(Person value) {
            return (Episode.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Episode.Builder addTranslator(Person.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Episode.Builder addTranslator(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public Episode.Builder addTypicalAgeRange(Text value) {
            return (Episode.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public Episode.Builder addTypicalAgeRange(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public Episode.Builder addUrl(URL value) {
            return (Episode.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Episode.Builder addUrl(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Episode.Builder addVersion(Number value) {
            return (Episode.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public Episode.Builder addVersion(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public Episode.Builder addVideo(VideoObject value) {
            return (Episode.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public Episode.Builder addVideo(VideoObject.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public Episode.Builder addVideo(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public Episode.Builder addWorkExample(CreativeWork value) {
            return (Episode.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public Episode.Builder addWorkExample(CreativeWork.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public Episode.Builder addWorkExample(String value) {
            return (Episode.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public Episode.Builder addDetailedDescription(Article value) {
            return (Episode.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Episode.Builder addDetailedDescription(Article.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Episode.Builder addDetailedDescription(String value) {
            return (Episode.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Episode.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Episode.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Episode.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Episode.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Episode.Builder addPopularityScore(String value) {
            return (Episode.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Episode build() {
            return new EpisodeImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

