/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.DiagnosticProcedure;
import com.google.schemaorg.core.Drug;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalCondition;
import com.google.schemaorg.core.MedicalDevice;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalProcedureImpl;
import com.google.schemaorg.core.MedicalProcedureType;
import com.google.schemaorg.core.MedicalSign;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class DiagnosticProcedureImpl
extends MedicalProcedureImpl
implements DiagnosticProcedure {
    private static final ImmutableSet<String> PROPERTY_SET = DiagnosticProcedureImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/affectedBy");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/followup");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/howPerformed");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/normalRange");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/preparation");
        builder.add((Object)"http://schema.org/procedureType");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/signDetected");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/usedToDiagnose");
        builder.add((Object)"http://schema.org/usesDevice");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public DiagnosticProcedureImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/DiagnosticProcedure";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAffectedByList() {
        return this.getProperty("http://schema.org/affectedBy");
    }

    @Override
    public ImmutableList<SchemaOrgType> getNormalRangeList() {
        return this.getProperty("http://schema.org/normalRange");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSignDetectedList() {
        return this.getProperty("http://schema.org/signDetected");
    }

    @Override
    public ImmutableList<SchemaOrgType> getUsedToDiagnoseList() {
        return this.getProperty("http://schema.org/usedToDiagnose");
    }

    @Override
    public ImmutableList<SchemaOrgType> getUsesDeviceList() {
        return this.getProperty("http://schema.org/usesDevice");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<DiagnosticProcedure.Builder>
    implements DiagnosticProcedure.Builder {
        BuilderImpl() {
        }

        @Override
        public DiagnosticProcedure.Builder addAdditionalType(URL value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public DiagnosticProcedure.Builder addAdditionalType(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addAffectedBy(Drug value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/affectedBy", value);
        }

        @Override
        public DiagnosticProcedure.Builder addAffectedBy(Drug.Builder value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/affectedBy", value.build());
        }

        @Override
        public DiagnosticProcedure.Builder addAffectedBy(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/affectedBy", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addAlternateName(Text value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public DiagnosticProcedure.Builder addAlternateName(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addCode(MedicalCode value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public DiagnosticProcedure.Builder addCode(MedicalCode.Builder value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public DiagnosticProcedure.Builder addCode(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addDescription(Text value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public DiagnosticProcedure.Builder addDescription(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addFollowup(Text value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/followup", value);
        }

        @Override
        public DiagnosticProcedure.Builder addFollowup(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/followup", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addGuideline(MedicalGuideline value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public DiagnosticProcedure.Builder addGuideline(MedicalGuideline.Builder value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public DiagnosticProcedure.Builder addGuideline(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addHowPerformed(Text value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/howPerformed", value);
        }

        @Override
        public DiagnosticProcedure.Builder addHowPerformed(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/howPerformed", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addImage(ImageObject value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public DiagnosticProcedure.Builder addImage(ImageObject.Builder value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public DiagnosticProcedure.Builder addImage(URL value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public DiagnosticProcedure.Builder addImage(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addMainEntityOfPage(CreativeWork value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public DiagnosticProcedure.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public DiagnosticProcedure.Builder addMainEntityOfPage(URL value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public DiagnosticProcedure.Builder addMainEntityOfPage(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addMedicineSystem(MedicineSystem value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public DiagnosticProcedure.Builder addMedicineSystem(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addName(Text value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public DiagnosticProcedure.Builder addName(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addNormalRange(Text value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/normalRange", value);
        }

        @Override
        public DiagnosticProcedure.Builder addNormalRange(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/normalRange", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addPotentialAction(Action value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public DiagnosticProcedure.Builder addPotentialAction(Action.Builder value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public DiagnosticProcedure.Builder addPotentialAction(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addPreparation(Text value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/preparation", value);
        }

        @Override
        public DiagnosticProcedure.Builder addPreparation(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/preparation", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addProcedureType(MedicalProcedureType value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/procedureType", value);
        }

        @Override
        public DiagnosticProcedure.Builder addProcedureType(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/procedureType", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addRecognizingAuthority(Organization value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public DiagnosticProcedure.Builder addRecognizingAuthority(Organization.Builder value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public DiagnosticProcedure.Builder addRecognizingAuthority(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public DiagnosticProcedure.Builder addRelevantSpecialty(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addSameAs(URL value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public DiagnosticProcedure.Builder addSameAs(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addSignDetected(MedicalSign value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/signDetected", value);
        }

        @Override
        public DiagnosticProcedure.Builder addSignDetected(MedicalSign.Builder value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/signDetected", value.build());
        }

        @Override
        public DiagnosticProcedure.Builder addSignDetected(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/signDetected", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addStudy(MedicalStudy value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public DiagnosticProcedure.Builder addStudy(MedicalStudy.Builder value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public DiagnosticProcedure.Builder addStudy(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addUrl(URL value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public DiagnosticProcedure.Builder addUrl(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addUsedToDiagnose(MedicalCondition value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/usedToDiagnose", value);
        }

        @Override
        public DiagnosticProcedure.Builder addUsedToDiagnose(MedicalCondition.Builder value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/usedToDiagnose", value.build());
        }

        @Override
        public DiagnosticProcedure.Builder addUsedToDiagnose(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/usedToDiagnose", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addUsesDevice(MedicalDevice value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/usesDevice", value);
        }

        @Override
        public DiagnosticProcedure.Builder addUsesDevice(MedicalDevice.Builder value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/usesDevice", value.build());
        }

        @Override
        public DiagnosticProcedure.Builder addUsesDevice(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.org/usesDevice", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addDetailedDescription(Article value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public DiagnosticProcedure.Builder addDetailedDescription(Article.Builder value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public DiagnosticProcedure.Builder addDetailedDescription(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public DiagnosticProcedure.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public DiagnosticProcedure.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public DiagnosticProcedure.Builder addPopularityScore(String value) {
            return (DiagnosticProcedure.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public DiagnosticProcedure build() {
            return new DiagnosticProcedureImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

