/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkImpl;
import com.google.schemaorg.core.CreativeWorkSeries;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class CreativeWorkSeriesImpl
extends CreativeWorkImpl
implements CreativeWorkSeries {
    private static final ImmutableSet<String> PROPERTY_SET = CreativeWorkSeriesImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/endDate");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/startDate");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public CreativeWorkSeriesImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/CreativeWorkSeries";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getEndDateList() {
        return this.getProperty("http://schema.org/endDate");
    }

    @Override
    public ImmutableList<SchemaOrgType> getStartDateList() {
        return this.getProperty("http://schema.org/startDate");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<CreativeWorkSeries.Builder>
    implements CreativeWorkSeries.Builder {
        BuilderImpl() {
        }

        @Override
        public CreativeWorkSeries.Builder addAbout(Thing value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public CreativeWorkSeries.Builder addAbout(Thing.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addAbout(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addAccessibilityAPI(Text value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public CreativeWorkSeries.Builder addAccessibilityAPI(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addAccessibilityControl(Text value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public CreativeWorkSeries.Builder addAccessibilityControl(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addAccessibilityFeature(Text value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public CreativeWorkSeries.Builder addAccessibilityFeature(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addAccessibilityHazard(Text value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public CreativeWorkSeries.Builder addAccessibilityHazard(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addAccountablePerson(Person value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public CreativeWorkSeries.Builder addAccountablePerson(Person.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addAccountablePerson(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addAdditionalType(URL value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public CreativeWorkSeries.Builder addAdditionalType(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addAggregateRating(AggregateRating value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public CreativeWorkSeries.Builder addAggregateRating(AggregateRating.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addAggregateRating(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addAlternateName(Text value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public CreativeWorkSeries.Builder addAlternateName(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addAlternativeHeadline(Text value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public CreativeWorkSeries.Builder addAlternativeHeadline(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addAssociatedMedia(MediaObject value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public CreativeWorkSeries.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addAssociatedMedia(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addAudience(Audience value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public CreativeWorkSeries.Builder addAudience(Audience.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addAudience(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addAudio(AudioObject value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public CreativeWorkSeries.Builder addAudio(AudioObject.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addAudio(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addAuthor(Organization value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public CreativeWorkSeries.Builder addAuthor(Organization.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addAuthor(Person value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public CreativeWorkSeries.Builder addAuthor(Person.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addAuthor(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addAward(Text value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public CreativeWorkSeries.Builder addAward(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addAwards(Text value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public CreativeWorkSeries.Builder addAwards(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addCharacter(Person value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public CreativeWorkSeries.Builder addCharacter(Person.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addCharacter(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addCitation(CreativeWork value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public CreativeWorkSeries.Builder addCitation(CreativeWork.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addCitation(Text value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public CreativeWorkSeries.Builder addCitation(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addComment(Comment value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public CreativeWorkSeries.Builder addComment(Comment.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addComment(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addCommentCount(Integer value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public CreativeWorkSeries.Builder addCommentCount(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addContentLocation(Place value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public CreativeWorkSeries.Builder addContentLocation(Place.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addContentLocation(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addContentRating(Text value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public CreativeWorkSeries.Builder addContentRating(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addContributor(Organization value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public CreativeWorkSeries.Builder addContributor(Organization.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addContributor(Person value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public CreativeWorkSeries.Builder addContributor(Person.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addContributor(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addCopyrightHolder(Organization value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public CreativeWorkSeries.Builder addCopyrightHolder(Organization.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addCopyrightHolder(Person value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public CreativeWorkSeries.Builder addCopyrightHolder(Person.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addCopyrightHolder(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addCopyrightYear(Number value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public CreativeWorkSeries.Builder addCopyrightYear(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addCreator(Organization value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public CreativeWorkSeries.Builder addCreator(Organization.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addCreator(Person value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public CreativeWorkSeries.Builder addCreator(Person.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addCreator(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addDateCreated(Date value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public CreativeWorkSeries.Builder addDateCreated(DateTime value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public CreativeWorkSeries.Builder addDateCreated(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addDateModified(Date value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public CreativeWorkSeries.Builder addDateModified(DateTime value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public CreativeWorkSeries.Builder addDateModified(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addDatePublished(Date value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public CreativeWorkSeries.Builder addDatePublished(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addDescription(Text value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public CreativeWorkSeries.Builder addDescription(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addDiscussionUrl(URL value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public CreativeWorkSeries.Builder addDiscussionUrl(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addEditor(Person value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public CreativeWorkSeries.Builder addEditor(Person.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addEditor(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addEducationalAlignment(AlignmentObject value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public CreativeWorkSeries.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addEducationalAlignment(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addEducationalUse(Text value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public CreativeWorkSeries.Builder addEducationalUse(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addEncoding(MediaObject value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public CreativeWorkSeries.Builder addEncoding(MediaObject.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addEncoding(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addEncodings(MediaObject value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public CreativeWorkSeries.Builder addEncodings(MediaObject.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addEncodings(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addEndDate(Date value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/endDate", value);
        }

        @Override
        public CreativeWorkSeries.Builder addEndDate(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/endDate", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addExampleOfWork(CreativeWork value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public CreativeWorkSeries.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addExampleOfWork(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addFileFormat(Text value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public CreativeWorkSeries.Builder addFileFormat(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addGenre(Text value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public CreativeWorkSeries.Builder addGenre(URL value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public CreativeWorkSeries.Builder addGenre(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addHasPart(CreativeWork value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public CreativeWorkSeries.Builder addHasPart(CreativeWork.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addHasPart(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addHeadline(Text value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public CreativeWorkSeries.Builder addHeadline(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addImage(ImageObject value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public CreativeWorkSeries.Builder addImage(ImageObject.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addImage(URL value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public CreativeWorkSeries.Builder addImage(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addInLanguage(Language value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public CreativeWorkSeries.Builder addInLanguage(Language.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addInLanguage(Text value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public CreativeWorkSeries.Builder addInLanguage(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addInteractionStatistic(InteractionCounter value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public CreativeWorkSeries.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addInteractionStatistic(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addInteractivityType(Text value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public CreativeWorkSeries.Builder addInteractivityType(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addIsBasedOnUrl(URL value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public CreativeWorkSeries.Builder addIsBasedOnUrl(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addIsFamilyFriendly(Boolean value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public CreativeWorkSeries.Builder addIsFamilyFriendly(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addIsPartOf(CreativeWork value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public CreativeWorkSeries.Builder addIsPartOf(CreativeWork.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addIsPartOf(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addKeywords(Text value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public CreativeWorkSeries.Builder addKeywords(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addLearningResourceType(Text value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public CreativeWorkSeries.Builder addLearningResourceType(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addLicense(CreativeWork value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public CreativeWorkSeries.Builder addLicense(CreativeWork.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addLicense(URL value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public CreativeWorkSeries.Builder addLicense(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addLocationCreated(Place value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public CreativeWorkSeries.Builder addLocationCreated(Place.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addLocationCreated(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addMainEntity(Thing value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public CreativeWorkSeries.Builder addMainEntity(Thing.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addMainEntity(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addMainEntityOfPage(CreativeWork value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public CreativeWorkSeries.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addMainEntityOfPage(URL value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public CreativeWorkSeries.Builder addMainEntityOfPage(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addMentions(Thing value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public CreativeWorkSeries.Builder addMentions(Thing.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addMentions(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addName(Text value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public CreativeWorkSeries.Builder addName(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addOffers(Offer value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public CreativeWorkSeries.Builder addOffers(Offer.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addOffers(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addPosition(Integer value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public CreativeWorkSeries.Builder addPosition(Text value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public CreativeWorkSeries.Builder addPosition(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addPotentialAction(Action value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public CreativeWorkSeries.Builder addPotentialAction(Action.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addPotentialAction(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addProducer(Organization value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public CreativeWorkSeries.Builder addProducer(Organization.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addProducer(Person value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public CreativeWorkSeries.Builder addProducer(Person.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addProducer(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addProvider(Organization value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public CreativeWorkSeries.Builder addProvider(Organization.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addProvider(Person value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public CreativeWorkSeries.Builder addProvider(Person.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addProvider(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addPublication(PublicationEvent value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public CreativeWorkSeries.Builder addPublication(PublicationEvent.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addPublication(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addPublisher(Organization value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public CreativeWorkSeries.Builder addPublisher(Organization.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addPublisher(Person value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public CreativeWorkSeries.Builder addPublisher(Person.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addPublisher(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addPublishingPrinciples(URL value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public CreativeWorkSeries.Builder addPublishingPrinciples(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addRecordedAt(Event value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public CreativeWorkSeries.Builder addRecordedAt(Event.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addRecordedAt(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addReleasedEvent(PublicationEvent value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public CreativeWorkSeries.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addReleasedEvent(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addReview(Review value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public CreativeWorkSeries.Builder addReview(Review.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addReview(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addReviews(Review value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public CreativeWorkSeries.Builder addReviews(Review.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addReviews(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addSameAs(URL value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public CreativeWorkSeries.Builder addSameAs(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addSchemaVersion(Text value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public CreativeWorkSeries.Builder addSchemaVersion(URL value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public CreativeWorkSeries.Builder addSchemaVersion(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addSourceOrganization(Organization value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public CreativeWorkSeries.Builder addSourceOrganization(Organization.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addSourceOrganization(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addStartDate(Date value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/startDate", value);
        }

        @Override
        public CreativeWorkSeries.Builder addStartDate(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/startDate", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addText(Text value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public CreativeWorkSeries.Builder addText(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addThumbnailUrl(URL value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public CreativeWorkSeries.Builder addThumbnailUrl(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addTimeRequired(Duration value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public CreativeWorkSeries.Builder addTimeRequired(Duration.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addTimeRequired(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addTranslator(Organization value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public CreativeWorkSeries.Builder addTranslator(Organization.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addTranslator(Person value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public CreativeWorkSeries.Builder addTranslator(Person.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addTranslator(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addTypicalAgeRange(Text value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public CreativeWorkSeries.Builder addTypicalAgeRange(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addUrl(URL value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public CreativeWorkSeries.Builder addUrl(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addVersion(Number value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public CreativeWorkSeries.Builder addVersion(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addVideo(VideoObject value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public CreativeWorkSeries.Builder addVideo(VideoObject.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addVideo(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addWorkExample(CreativeWork value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public CreativeWorkSeries.Builder addWorkExample(CreativeWork.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addWorkExample(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addDetailedDescription(Article value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public CreativeWorkSeries.Builder addDetailedDescription(Article.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addDetailedDescription(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public CreativeWorkSeries.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public CreativeWorkSeries.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public CreativeWorkSeries.Builder addPopularityScore(String value) {
            return (CreativeWorkSeries.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public CreativeWorkSeries build() {
            return new CreativeWorkSeriesImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

