/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.ThingImpl;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class CreativeWorkImpl
extends ThingImpl
implements CreativeWork {
    private static final ImmutableSet<String> PROPERTY_SET = CreativeWorkImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public CreativeWorkImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/CreativeWork";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAboutList() {
        return this.getProperty("http://schema.org/about");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAccessibilityAPIList() {
        return this.getProperty("http://schema.org/accessibilityAPI");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAccessibilityControlList() {
        return this.getProperty("http://schema.org/accessibilityControl");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAccessibilityFeatureList() {
        return this.getProperty("http://schema.org/accessibilityFeature");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAccessibilityHazardList() {
        return this.getProperty("http://schema.org/accessibilityHazard");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAccountablePersonList() {
        return this.getProperty("http://schema.org/accountablePerson");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAggregateRatingList() {
        return this.getProperty("http://schema.org/aggregateRating");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAlternativeHeadlineList() {
        return this.getProperty("http://schema.org/alternativeHeadline");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAssociatedMediaList() {
        return this.getProperty("http://schema.org/associatedMedia");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAudienceList() {
        return this.getProperty("http://schema.org/audience");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAudioList() {
        return this.getProperty("http://schema.org/audio");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAuthorList() {
        return this.getProperty("http://schema.org/author");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAwardList() {
        return this.getProperty("http://schema.org/award");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAwardsList() {
        return this.getProperty("http://schema.org/awards");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCharacterList() {
        return this.getProperty("http://schema.org/character");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCitationList() {
        return this.getProperty("http://schema.org/citation");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCommentList() {
        return this.getProperty("http://schema.org/comment");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCommentCountList() {
        return this.getProperty("http://schema.org/commentCount");
    }

    @Override
    public ImmutableList<SchemaOrgType> getContentLocationList() {
        return this.getProperty("http://schema.org/contentLocation");
    }

    @Override
    public ImmutableList<SchemaOrgType> getContentRatingList() {
        return this.getProperty("http://schema.org/contentRating");
    }

    @Override
    public ImmutableList<SchemaOrgType> getContributorList() {
        return this.getProperty("http://schema.org/contributor");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCopyrightHolderList() {
        return this.getProperty("http://schema.org/copyrightHolder");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCopyrightYearList() {
        return this.getProperty("http://schema.org/copyrightYear");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCreatorList() {
        return this.getProperty("http://schema.org/creator");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDateCreatedList() {
        return this.getProperty("http://schema.org/dateCreated");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDateModifiedList() {
        return this.getProperty("http://schema.org/dateModified");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDatePublishedList() {
        return this.getProperty("http://schema.org/datePublished");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDiscussionUrlList() {
        return this.getProperty("http://schema.org/discussionUrl");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEditorList() {
        return this.getProperty("http://schema.org/editor");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEducationalAlignmentList() {
        return this.getProperty("http://schema.org/educationalAlignment");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEducationalUseList() {
        return this.getProperty("http://schema.org/educationalUse");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEncodingList() {
        return this.getProperty("http://schema.org/encoding");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEncodingsList() {
        return this.getProperty("http://schema.org/encodings");
    }

    @Override
    public ImmutableList<SchemaOrgType> getExampleOfWorkList() {
        return this.getProperty("http://schema.org/exampleOfWork");
    }

    @Override
    public ImmutableList<SchemaOrgType> getFileFormatList() {
        return this.getProperty("http://schema.org/fileFormat");
    }

    @Override
    public ImmutableList<SchemaOrgType> getGenreList() {
        return this.getProperty("http://schema.org/genre");
    }

    @Override
    public ImmutableList<SchemaOrgType> getHasPartList() {
        return this.getProperty("http://schema.org/hasPart");
    }

    @Override
    public ImmutableList<SchemaOrgType> getHeadlineList() {
        return this.getProperty("http://schema.org/headline");
    }

    @Override
    public ImmutableList<SchemaOrgType> getInLanguageList() {
        return this.getProperty("http://schema.org/inLanguage");
    }

    @Override
    public ImmutableList<SchemaOrgType> getInteractionStatisticList() {
        return this.getProperty("http://schema.org/interactionStatistic");
    }

    @Override
    public ImmutableList<SchemaOrgType> getInteractivityTypeList() {
        return this.getProperty("http://schema.org/interactivityType");
    }

    @Override
    public ImmutableList<SchemaOrgType> getIsBasedOnUrlList() {
        return this.getProperty("http://schema.org/isBasedOnUrl");
    }

    @Override
    public ImmutableList<SchemaOrgType> getIsFamilyFriendlyList() {
        return this.getProperty("http://schema.org/isFamilyFriendly");
    }

    @Override
    public ImmutableList<SchemaOrgType> getIsPartOfList() {
        return this.getProperty("http://schema.org/isPartOf");
    }

    @Override
    public ImmutableList<SchemaOrgType> getKeywordsList() {
        return this.getProperty("http://schema.org/keywords");
    }

    @Override
    public ImmutableList<SchemaOrgType> getLearningResourceTypeList() {
        return this.getProperty("http://schema.org/learningResourceType");
    }

    @Override
    public ImmutableList<SchemaOrgType> getLicenseList() {
        return this.getProperty("http://schema.org/license");
    }

    @Override
    public ImmutableList<SchemaOrgType> getLocationCreatedList() {
        return this.getProperty("http://schema.org/locationCreated");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMainEntityList() {
        return this.getProperty("http://schema.org/mainEntity");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMentionsList() {
        return this.getProperty("http://schema.org/mentions");
    }

    @Override
    public ImmutableList<SchemaOrgType> getOffersList() {
        return this.getProperty("http://schema.org/offers");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPositionList() {
        return this.getProperty("http://schema.org/position");
    }

    @Override
    public ImmutableList<SchemaOrgType> getProducerList() {
        return this.getProperty("http://schema.org/producer");
    }

    @Override
    public ImmutableList<SchemaOrgType> getProviderList() {
        return this.getProperty("http://schema.org/provider");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPublicationList() {
        return this.getProperty("http://schema.org/publication");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPublisherList() {
        return this.getProperty("http://schema.org/publisher");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPublishingPrinciplesList() {
        return this.getProperty("http://schema.org/publishingPrinciples");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRecordedAtList() {
        return this.getProperty("http://schema.org/recordedAt");
    }

    @Override
    public ImmutableList<SchemaOrgType> getReleasedEventList() {
        return this.getProperty("http://schema.org/releasedEvent");
    }

    @Override
    public ImmutableList<SchemaOrgType> getReviewList() {
        return this.getProperty("http://schema.org/review");
    }

    @Override
    public ImmutableList<SchemaOrgType> getReviewsList() {
        return this.getProperty("http://schema.org/reviews");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSchemaVersionList() {
        return this.getProperty("http://schema.org/schemaVersion");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSourceOrganizationList() {
        return this.getProperty("http://schema.org/sourceOrganization");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTextList() {
        return this.getProperty("http://schema.org/text");
    }

    @Override
    public ImmutableList<SchemaOrgType> getThumbnailUrlList() {
        return this.getProperty("http://schema.org/thumbnailUrl");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTimeRequiredList() {
        return this.getProperty("http://schema.org/timeRequired");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTranslatorList() {
        return this.getProperty("http://schema.org/translator");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTypicalAgeRangeList() {
        return this.getProperty("http://schema.org/typicalAgeRange");
    }

    @Override
    public ImmutableList<SchemaOrgType> getVersionList() {
        return this.getProperty("http://schema.org/version");
    }

    @Override
    public ImmutableList<SchemaOrgType> getVideoList() {
        return this.getProperty("http://schema.org/video");
    }

    @Override
    public ImmutableList<SchemaOrgType> getWorkExampleList() {
        return this.getProperty("http://schema.org/workExample");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<CreativeWork.Builder>
    implements CreativeWork.Builder {
        BuilderImpl() {
        }

        @Override
        public CreativeWork.Builder addAbout(Thing value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public CreativeWork.Builder addAbout(Thing.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public CreativeWork.Builder addAbout(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addAccessibilityAPI(Text value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public CreativeWork.Builder addAccessibilityAPI(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addAccessibilityControl(Text value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public CreativeWork.Builder addAccessibilityControl(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addAccessibilityFeature(Text value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public CreativeWork.Builder addAccessibilityFeature(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addAccessibilityHazard(Text value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public CreativeWork.Builder addAccessibilityHazard(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addAccountablePerson(Person value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public CreativeWork.Builder addAccountablePerson(Person.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public CreativeWork.Builder addAccountablePerson(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addAdditionalType(URL value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public CreativeWork.Builder addAdditionalType(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addAggregateRating(AggregateRating value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public CreativeWork.Builder addAggregateRating(AggregateRating.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public CreativeWork.Builder addAggregateRating(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addAlternateName(Text value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public CreativeWork.Builder addAlternateName(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addAlternativeHeadline(Text value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public CreativeWork.Builder addAlternativeHeadline(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addAssociatedMedia(MediaObject value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public CreativeWork.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public CreativeWork.Builder addAssociatedMedia(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addAudience(Audience value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public CreativeWork.Builder addAudience(Audience.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public CreativeWork.Builder addAudience(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addAudio(AudioObject value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public CreativeWork.Builder addAudio(AudioObject.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public CreativeWork.Builder addAudio(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addAuthor(Organization value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public CreativeWork.Builder addAuthor(Organization.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public CreativeWork.Builder addAuthor(Person value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public CreativeWork.Builder addAuthor(Person.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public CreativeWork.Builder addAuthor(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addAward(Text value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public CreativeWork.Builder addAward(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addAwards(Text value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public CreativeWork.Builder addAwards(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addCharacter(Person value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public CreativeWork.Builder addCharacter(Person.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public CreativeWork.Builder addCharacter(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addCitation(CreativeWork value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public CreativeWork.Builder addCitation(CreativeWork.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public CreativeWork.Builder addCitation(Text value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public CreativeWork.Builder addCitation(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addComment(Comment value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public CreativeWork.Builder addComment(Comment.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public CreativeWork.Builder addComment(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addCommentCount(Integer value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public CreativeWork.Builder addCommentCount(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addContentLocation(Place value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public CreativeWork.Builder addContentLocation(Place.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public CreativeWork.Builder addContentLocation(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addContentRating(Text value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public CreativeWork.Builder addContentRating(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addContributor(Organization value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public CreativeWork.Builder addContributor(Organization.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public CreativeWork.Builder addContributor(Person value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public CreativeWork.Builder addContributor(Person.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public CreativeWork.Builder addContributor(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addCopyrightHolder(Organization value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public CreativeWork.Builder addCopyrightHolder(Organization.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public CreativeWork.Builder addCopyrightHolder(Person value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public CreativeWork.Builder addCopyrightHolder(Person.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public CreativeWork.Builder addCopyrightHolder(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addCopyrightYear(Number value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public CreativeWork.Builder addCopyrightYear(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addCreator(Organization value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public CreativeWork.Builder addCreator(Organization.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public CreativeWork.Builder addCreator(Person value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public CreativeWork.Builder addCreator(Person.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public CreativeWork.Builder addCreator(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addDateCreated(Date value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public CreativeWork.Builder addDateCreated(DateTime value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public CreativeWork.Builder addDateCreated(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addDateModified(Date value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public CreativeWork.Builder addDateModified(DateTime value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public CreativeWork.Builder addDateModified(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addDatePublished(Date value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public CreativeWork.Builder addDatePublished(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addDescription(Text value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public CreativeWork.Builder addDescription(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addDiscussionUrl(URL value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public CreativeWork.Builder addDiscussionUrl(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addEditor(Person value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public CreativeWork.Builder addEditor(Person.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public CreativeWork.Builder addEditor(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addEducationalAlignment(AlignmentObject value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public CreativeWork.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public CreativeWork.Builder addEducationalAlignment(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addEducationalUse(Text value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public CreativeWork.Builder addEducationalUse(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addEncoding(MediaObject value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public CreativeWork.Builder addEncoding(MediaObject.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public CreativeWork.Builder addEncoding(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addEncodings(MediaObject value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public CreativeWork.Builder addEncodings(MediaObject.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public CreativeWork.Builder addEncodings(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addExampleOfWork(CreativeWork value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public CreativeWork.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public CreativeWork.Builder addExampleOfWork(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addFileFormat(Text value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public CreativeWork.Builder addFileFormat(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addGenre(Text value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public CreativeWork.Builder addGenre(URL value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public CreativeWork.Builder addGenre(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addHasPart(CreativeWork value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public CreativeWork.Builder addHasPart(CreativeWork.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public CreativeWork.Builder addHasPart(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addHeadline(Text value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public CreativeWork.Builder addHeadline(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addImage(ImageObject value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public CreativeWork.Builder addImage(ImageObject.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public CreativeWork.Builder addImage(URL value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public CreativeWork.Builder addImage(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addInLanguage(Language value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public CreativeWork.Builder addInLanguage(Language.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public CreativeWork.Builder addInLanguage(Text value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public CreativeWork.Builder addInLanguage(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addInteractionStatistic(InteractionCounter value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public CreativeWork.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public CreativeWork.Builder addInteractionStatistic(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addInteractivityType(Text value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public CreativeWork.Builder addInteractivityType(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addIsBasedOnUrl(URL value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public CreativeWork.Builder addIsBasedOnUrl(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addIsFamilyFriendly(Boolean value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public CreativeWork.Builder addIsFamilyFriendly(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addIsPartOf(CreativeWork value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public CreativeWork.Builder addIsPartOf(CreativeWork.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public CreativeWork.Builder addIsPartOf(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addKeywords(Text value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public CreativeWork.Builder addKeywords(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addLearningResourceType(Text value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public CreativeWork.Builder addLearningResourceType(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addLicense(CreativeWork value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public CreativeWork.Builder addLicense(CreativeWork.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public CreativeWork.Builder addLicense(URL value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public CreativeWork.Builder addLicense(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addLocationCreated(Place value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public CreativeWork.Builder addLocationCreated(Place.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public CreativeWork.Builder addLocationCreated(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addMainEntity(Thing value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public CreativeWork.Builder addMainEntity(Thing.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public CreativeWork.Builder addMainEntity(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addMainEntityOfPage(CreativeWork value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public CreativeWork.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public CreativeWork.Builder addMainEntityOfPage(URL value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public CreativeWork.Builder addMainEntityOfPage(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addMentions(Thing value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public CreativeWork.Builder addMentions(Thing.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public CreativeWork.Builder addMentions(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addName(Text value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public CreativeWork.Builder addName(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addOffers(Offer value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public CreativeWork.Builder addOffers(Offer.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public CreativeWork.Builder addOffers(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addPosition(Integer value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public CreativeWork.Builder addPosition(Text value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public CreativeWork.Builder addPosition(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addPotentialAction(Action value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public CreativeWork.Builder addPotentialAction(Action.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public CreativeWork.Builder addPotentialAction(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addProducer(Organization value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public CreativeWork.Builder addProducer(Organization.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public CreativeWork.Builder addProducer(Person value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public CreativeWork.Builder addProducer(Person.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public CreativeWork.Builder addProducer(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addProvider(Organization value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public CreativeWork.Builder addProvider(Organization.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public CreativeWork.Builder addProvider(Person value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public CreativeWork.Builder addProvider(Person.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public CreativeWork.Builder addProvider(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addPublication(PublicationEvent value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public CreativeWork.Builder addPublication(PublicationEvent.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public CreativeWork.Builder addPublication(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addPublisher(Organization value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public CreativeWork.Builder addPublisher(Organization.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public CreativeWork.Builder addPublisher(Person value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public CreativeWork.Builder addPublisher(Person.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public CreativeWork.Builder addPublisher(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addPublishingPrinciples(URL value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public CreativeWork.Builder addPublishingPrinciples(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addRecordedAt(Event value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public CreativeWork.Builder addRecordedAt(Event.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public CreativeWork.Builder addRecordedAt(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addReleasedEvent(PublicationEvent value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public CreativeWork.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public CreativeWork.Builder addReleasedEvent(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addReview(Review value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public CreativeWork.Builder addReview(Review.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public CreativeWork.Builder addReview(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addReviews(Review value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public CreativeWork.Builder addReviews(Review.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public CreativeWork.Builder addReviews(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addSameAs(URL value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public CreativeWork.Builder addSameAs(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addSchemaVersion(Text value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public CreativeWork.Builder addSchemaVersion(URL value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public CreativeWork.Builder addSchemaVersion(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addSourceOrganization(Organization value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public CreativeWork.Builder addSourceOrganization(Organization.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public CreativeWork.Builder addSourceOrganization(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addText(Text value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public CreativeWork.Builder addText(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addThumbnailUrl(URL value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public CreativeWork.Builder addThumbnailUrl(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addTimeRequired(Duration value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public CreativeWork.Builder addTimeRequired(Duration.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public CreativeWork.Builder addTimeRequired(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addTranslator(Organization value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public CreativeWork.Builder addTranslator(Organization.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public CreativeWork.Builder addTranslator(Person value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public CreativeWork.Builder addTranslator(Person.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public CreativeWork.Builder addTranslator(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addTypicalAgeRange(Text value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public CreativeWork.Builder addTypicalAgeRange(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addUrl(URL value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public CreativeWork.Builder addUrl(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addVersion(Number value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public CreativeWork.Builder addVersion(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addVideo(VideoObject value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public CreativeWork.Builder addVideo(VideoObject.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public CreativeWork.Builder addVideo(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addWorkExample(CreativeWork value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public CreativeWork.Builder addWorkExample(CreativeWork.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public CreativeWork.Builder addWorkExample(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addDetailedDescription(Article value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public CreativeWork.Builder addDetailedDescription(Article.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public CreativeWork.Builder addDetailedDescription(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public CreativeWork.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public CreativeWork.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public CreativeWork.Builder addPopularityScore(String value) {
            return (CreativeWork.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public CreativeWork build() {
            return new CreativeWorkImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

