/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AdministrativeArea;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class AudienceImpl
extends IntangibleImpl
implements Audience {
    private static final ImmutableSet<String> PROPERTY_SET = AudienceImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/audienceType");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/geographicArea");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public AudienceImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Audience";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAudienceTypeList() {
        return this.getProperty("http://schema.org/audienceType");
    }

    @Override
    public ImmutableList<SchemaOrgType> getGeographicAreaList() {
        return this.getProperty("http://schema.org/geographicArea");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Audience.Builder>
    implements Audience.Builder {
        BuilderImpl() {
        }

        @Override
        public Audience.Builder addAdditionalType(URL value) {
            return (Audience.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Audience.Builder addAdditionalType(String value) {
            return (Audience.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Audience.Builder addAlternateName(Text value) {
            return (Audience.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Audience.Builder addAlternateName(String value) {
            return (Audience.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Audience.Builder addAudienceType(Text value) {
            return (Audience.Builder)this.addProperty("http://schema.org/audienceType", value);
        }

        @Override
        public Audience.Builder addAudienceType(String value) {
            return (Audience.Builder)this.addProperty("http://schema.org/audienceType", Text.of(value));
        }

        @Override
        public Audience.Builder addDescription(Text value) {
            return (Audience.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Audience.Builder addDescription(String value) {
            return (Audience.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Audience.Builder addGeographicArea(AdministrativeArea value) {
            return (Audience.Builder)this.addProperty("http://schema.org/geographicArea", value);
        }

        @Override
        public Audience.Builder addGeographicArea(AdministrativeArea.Builder value) {
            return (Audience.Builder)this.addProperty("http://schema.org/geographicArea", value.build());
        }

        @Override
        public Audience.Builder addGeographicArea(String value) {
            return (Audience.Builder)this.addProperty("http://schema.org/geographicArea", Text.of(value));
        }

        @Override
        public Audience.Builder addImage(ImageObject value) {
            return (Audience.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Audience.Builder addImage(ImageObject.Builder value) {
            return (Audience.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Audience.Builder addImage(URL value) {
            return (Audience.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Audience.Builder addImage(String value) {
            return (Audience.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Audience.Builder addMainEntityOfPage(CreativeWork value) {
            return (Audience.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Audience.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Audience.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Audience.Builder addMainEntityOfPage(URL value) {
            return (Audience.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Audience.Builder addMainEntityOfPage(String value) {
            return (Audience.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Audience.Builder addName(Text value) {
            return (Audience.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Audience.Builder addName(String value) {
            return (Audience.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Audience.Builder addPotentialAction(Action value) {
            return (Audience.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Audience.Builder addPotentialAction(Action.Builder value) {
            return (Audience.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Audience.Builder addPotentialAction(String value) {
            return (Audience.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Audience.Builder addSameAs(URL value) {
            return (Audience.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Audience.Builder addSameAs(String value) {
            return (Audience.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Audience.Builder addUrl(URL value) {
            return (Audience.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Audience.Builder addUrl(String value) {
            return (Audience.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Audience.Builder addDetailedDescription(Article value) {
            return (Audience.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Audience.Builder addDetailedDescription(Article.Builder value) {
            return (Audience.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Audience.Builder addDetailedDescription(String value) {
            return (Audience.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Audience.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Audience.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Audience.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Audience.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Audience.Builder addPopularityScore(String value) {
            return (Audience.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Audience build() {
            return new AudienceImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

