/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AnatomicalStructure;
import com.google.schemaorg.core.AnatomicalSystem;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalCondition;
import com.google.schemaorg.core.MedicalEntityImpl;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalTherapy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class AnatomicalStructureImpl
extends MedicalEntityImpl
implements AnatomicalStructure {
    private static final ImmutableSet<String> PROPERTY_SET = AnatomicalStructureImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/associatedPathophysiology");
        builder.add((Object)"http://schema.org/bodyLocation");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/connectedTo");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/diagram");
        builder.add((Object)"http://schema.org/function");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/partOfSystem");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relatedCondition");
        builder.add((Object)"http://schema.org/relatedTherapy");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/subStructure");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public AnatomicalStructureImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/AnatomicalStructure";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAssociatedPathophysiologyList() {
        return this.getProperty("http://schema.org/associatedPathophysiology");
    }

    @Override
    public ImmutableList<SchemaOrgType> getBodyLocationList() {
        return this.getProperty("http://schema.org/bodyLocation");
    }

    @Override
    public ImmutableList<SchemaOrgType> getConnectedToList() {
        return this.getProperty("http://schema.org/connectedTo");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDiagramList() {
        return this.getProperty("http://schema.org/diagram");
    }

    @Override
    public ImmutableList<SchemaOrgType> getFunctionList() {
        return this.getProperty("http://schema.org/function");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPartOfSystemList() {
        return this.getProperty("http://schema.org/partOfSystem");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRelatedConditionList() {
        return this.getProperty("http://schema.org/relatedCondition");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRelatedTherapyList() {
        return this.getProperty("http://schema.org/relatedTherapy");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSubStructureList() {
        return this.getProperty("http://schema.org/subStructure");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<AnatomicalStructure.Builder>
    implements AnatomicalStructure.Builder {
        BuilderImpl() {
        }

        @Override
        public AnatomicalStructure.Builder addAdditionalType(URL value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public AnatomicalStructure.Builder addAdditionalType(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addAlternateName(Text value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public AnatomicalStructure.Builder addAlternateName(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addAssociatedPathophysiology(Text value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/associatedPathophysiology", value);
        }

        @Override
        public AnatomicalStructure.Builder addAssociatedPathophysiology(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/associatedPathophysiology", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addBodyLocation(Text value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/bodyLocation", value);
        }

        @Override
        public AnatomicalStructure.Builder addBodyLocation(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/bodyLocation", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addCode(MedicalCode value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public AnatomicalStructure.Builder addCode(MedicalCode.Builder value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public AnatomicalStructure.Builder addCode(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addConnectedTo(AnatomicalStructure value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/connectedTo", value);
        }

        @Override
        public AnatomicalStructure.Builder addConnectedTo(AnatomicalStructure.Builder value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/connectedTo", value.build());
        }

        @Override
        public AnatomicalStructure.Builder addConnectedTo(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/connectedTo", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addDescription(Text value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public AnatomicalStructure.Builder addDescription(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addDiagram(ImageObject value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/diagram", value);
        }

        @Override
        public AnatomicalStructure.Builder addDiagram(ImageObject.Builder value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/diagram", value.build());
        }

        @Override
        public AnatomicalStructure.Builder addDiagram(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/diagram", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addFunction(Text value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/function", value);
        }

        @Override
        public AnatomicalStructure.Builder addFunction(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/function", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addGuideline(MedicalGuideline value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public AnatomicalStructure.Builder addGuideline(MedicalGuideline.Builder value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public AnatomicalStructure.Builder addGuideline(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addImage(ImageObject value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public AnatomicalStructure.Builder addImage(ImageObject.Builder value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public AnatomicalStructure.Builder addImage(URL value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public AnatomicalStructure.Builder addImage(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addMainEntityOfPage(CreativeWork value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public AnatomicalStructure.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public AnatomicalStructure.Builder addMainEntityOfPage(URL value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public AnatomicalStructure.Builder addMainEntityOfPage(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addMedicineSystem(MedicineSystem value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public AnatomicalStructure.Builder addMedicineSystem(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addName(Text value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public AnatomicalStructure.Builder addName(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addPartOfSystem(AnatomicalSystem value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/partOfSystem", value);
        }

        @Override
        public AnatomicalStructure.Builder addPartOfSystem(AnatomicalSystem.Builder value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/partOfSystem", value.build());
        }

        @Override
        public AnatomicalStructure.Builder addPartOfSystem(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/partOfSystem", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addPotentialAction(Action value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public AnatomicalStructure.Builder addPotentialAction(Action.Builder value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public AnatomicalStructure.Builder addPotentialAction(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addRecognizingAuthority(Organization value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public AnatomicalStructure.Builder addRecognizingAuthority(Organization.Builder value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public AnatomicalStructure.Builder addRecognizingAuthority(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addRelatedCondition(MedicalCondition value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/relatedCondition", value);
        }

        @Override
        public AnatomicalStructure.Builder addRelatedCondition(MedicalCondition.Builder value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/relatedCondition", value.build());
        }

        @Override
        public AnatomicalStructure.Builder addRelatedCondition(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/relatedCondition", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addRelatedTherapy(MedicalTherapy value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/relatedTherapy", value);
        }

        @Override
        public AnatomicalStructure.Builder addRelatedTherapy(MedicalTherapy.Builder value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/relatedTherapy", value.build());
        }

        @Override
        public AnatomicalStructure.Builder addRelatedTherapy(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/relatedTherapy", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public AnatomicalStructure.Builder addRelevantSpecialty(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addSameAs(URL value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public AnatomicalStructure.Builder addSameAs(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addStudy(MedicalStudy value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public AnatomicalStructure.Builder addStudy(MedicalStudy.Builder value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public AnatomicalStructure.Builder addStudy(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addSubStructure(AnatomicalStructure value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/subStructure", value);
        }

        @Override
        public AnatomicalStructure.Builder addSubStructure(AnatomicalStructure.Builder value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/subStructure", value.build());
        }

        @Override
        public AnatomicalStructure.Builder addSubStructure(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/subStructure", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addUrl(URL value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public AnatomicalStructure.Builder addUrl(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addDetailedDescription(Article value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public AnatomicalStructure.Builder addDetailedDescription(Article.Builder value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public AnatomicalStructure.Builder addDetailedDescription(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public AnatomicalStructure.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public AnatomicalStructure.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public AnatomicalStructure.Builder addPopularityScore(String value) {
            return (AnatomicalStructure.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public AnatomicalStructure build() {
            return new AnatomicalStructureImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

