/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.PriceSpecification;
import com.google.schemaorg.core.ProgramMembership;
import com.google.schemaorg.core.Reservation;
import com.google.schemaorg.core.ReservationStatusType;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.Ticket;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class ReservationImpl
extends IntangibleImpl
implements Reservation {
    private static final ImmutableSet<String> PROPERTY_SET = ReservationImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/bookingAgent");
        builder.add((Object)"http://schema.org/bookingTime");
        builder.add((Object)"http://schema.org/broker");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/modifiedTime");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/priceCurrency");
        builder.add((Object)"http://schema.org/programMembershipUsed");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/reservationFor");
        builder.add((Object)"http://schema.org/reservationId");
        builder.add((Object)"http://schema.org/reservationStatus");
        builder.add((Object)"http://schema.org/reservedTicket");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/totalPrice");
        builder.add((Object)"http://schema.org/underName");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public ReservationImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Reservation";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getBookingAgentList() {
        return this.getProperty("http://schema.org/bookingAgent");
    }

    @Override
    public ImmutableList<SchemaOrgType> getBookingTimeList() {
        return this.getProperty("http://schema.org/bookingTime");
    }

    @Override
    public ImmutableList<SchemaOrgType> getBrokerList() {
        return this.getProperty("http://schema.org/broker");
    }

    @Override
    public ImmutableList<SchemaOrgType> getModifiedTimeList() {
        return this.getProperty("http://schema.org/modifiedTime");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPriceCurrencyList() {
        return this.getProperty("http://schema.org/priceCurrency");
    }

    @Override
    public ImmutableList<SchemaOrgType> getProgramMembershipUsedList() {
        return this.getProperty("http://schema.org/programMembershipUsed");
    }

    @Override
    public ImmutableList<SchemaOrgType> getProviderList() {
        return this.getProperty("http://schema.org/provider");
    }

    @Override
    public ImmutableList<SchemaOrgType> getReservationForList() {
        return this.getProperty("http://schema.org/reservationFor");
    }

    @Override
    public ImmutableList<SchemaOrgType> getReservationIdList() {
        return this.getProperty("http://schema.org/reservationId");
    }

    @Override
    public ImmutableList<SchemaOrgType> getReservationStatusList() {
        return this.getProperty("http://schema.org/reservationStatus");
    }

    @Override
    public ImmutableList<SchemaOrgType> getReservedTicketList() {
        return this.getProperty("http://schema.org/reservedTicket");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTotalPriceList() {
        return this.getProperty("http://schema.org/totalPrice");
    }

    @Override
    public ImmutableList<SchemaOrgType> getUnderNameList() {
        return this.getProperty("http://schema.org/underName");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Reservation.Builder>
    implements Reservation.Builder {
        BuilderImpl() {
        }

        @Override
        public Reservation.Builder addAdditionalType(URL value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Reservation.Builder addAdditionalType(String value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Reservation.Builder addAlternateName(Text value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Reservation.Builder addAlternateName(String value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Reservation.Builder addBookingAgent(Organization value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/bookingAgent", value);
        }

        @Override
        public Reservation.Builder addBookingAgent(Organization.Builder value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/bookingAgent", value.build());
        }

        @Override
        public Reservation.Builder addBookingAgent(Person value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/bookingAgent", value);
        }

        @Override
        public Reservation.Builder addBookingAgent(Person.Builder value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/bookingAgent", value.build());
        }

        @Override
        public Reservation.Builder addBookingAgent(String value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/bookingAgent", Text.of(value));
        }

        @Override
        public Reservation.Builder addBookingTime(DateTime value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/bookingTime", value);
        }

        @Override
        public Reservation.Builder addBookingTime(String value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/bookingTime", Text.of(value));
        }

        @Override
        public Reservation.Builder addBroker(Organization value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/broker", value);
        }

        @Override
        public Reservation.Builder addBroker(Organization.Builder value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/broker", value.build());
        }

        @Override
        public Reservation.Builder addBroker(Person value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/broker", value);
        }

        @Override
        public Reservation.Builder addBroker(Person.Builder value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/broker", value.build());
        }

        @Override
        public Reservation.Builder addBroker(String value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/broker", Text.of(value));
        }

        @Override
        public Reservation.Builder addDescription(Text value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Reservation.Builder addDescription(String value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Reservation.Builder addImage(ImageObject value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Reservation.Builder addImage(ImageObject.Builder value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Reservation.Builder addImage(URL value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Reservation.Builder addImage(String value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Reservation.Builder addMainEntityOfPage(CreativeWork value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Reservation.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Reservation.Builder addMainEntityOfPage(URL value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Reservation.Builder addMainEntityOfPage(String value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Reservation.Builder addModifiedTime(DateTime value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/modifiedTime", value);
        }

        @Override
        public Reservation.Builder addModifiedTime(String value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/modifiedTime", Text.of(value));
        }

        @Override
        public Reservation.Builder addName(Text value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Reservation.Builder addName(String value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Reservation.Builder addPotentialAction(Action value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Reservation.Builder addPotentialAction(Action.Builder value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Reservation.Builder addPotentialAction(String value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Reservation.Builder addPriceCurrency(Text value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/priceCurrency", value);
        }

        @Override
        public Reservation.Builder addPriceCurrency(String value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/priceCurrency", Text.of(value));
        }

        @Override
        public Reservation.Builder addProgramMembershipUsed(ProgramMembership value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/programMembershipUsed", value);
        }

        @Override
        public Reservation.Builder addProgramMembershipUsed(ProgramMembership.Builder value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/programMembershipUsed", value.build());
        }

        @Override
        public Reservation.Builder addProgramMembershipUsed(String value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/programMembershipUsed", Text.of(value));
        }

        @Override
        public Reservation.Builder addProvider(Organization value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Reservation.Builder addProvider(Organization.Builder value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Reservation.Builder addProvider(Person value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Reservation.Builder addProvider(Person.Builder value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Reservation.Builder addProvider(String value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public Reservation.Builder addReservationFor(Thing value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/reservationFor", value);
        }

        @Override
        public Reservation.Builder addReservationFor(Thing.Builder value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/reservationFor", value.build());
        }

        @Override
        public Reservation.Builder addReservationFor(String value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/reservationFor", Text.of(value));
        }

        @Override
        public Reservation.Builder addReservationId(Text value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/reservationId", value);
        }

        @Override
        public Reservation.Builder addReservationId(String value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/reservationId", Text.of(value));
        }

        @Override
        public Reservation.Builder addReservationStatus(ReservationStatusType value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/reservationStatus", value);
        }

        @Override
        public Reservation.Builder addReservationStatus(String value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/reservationStatus", Text.of(value));
        }

        @Override
        public Reservation.Builder addReservedTicket(Ticket value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/reservedTicket", value);
        }

        @Override
        public Reservation.Builder addReservedTicket(Ticket.Builder value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/reservedTicket", value.build());
        }

        @Override
        public Reservation.Builder addReservedTicket(String value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/reservedTicket", Text.of(value));
        }

        @Override
        public Reservation.Builder addSameAs(URL value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Reservation.Builder addSameAs(String value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Reservation.Builder addTotalPrice(Number value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/totalPrice", value);
        }

        @Override
        public Reservation.Builder addTotalPrice(PriceSpecification value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/totalPrice", value);
        }

        @Override
        public Reservation.Builder addTotalPrice(PriceSpecification.Builder value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/totalPrice", value.build());
        }

        @Override
        public Reservation.Builder addTotalPrice(Text value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/totalPrice", value);
        }

        @Override
        public Reservation.Builder addTotalPrice(String value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/totalPrice", Text.of(value));
        }

        @Override
        public Reservation.Builder addUnderName(Organization value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/underName", value);
        }

        @Override
        public Reservation.Builder addUnderName(Organization.Builder value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/underName", value.build());
        }

        @Override
        public Reservation.Builder addUnderName(Person value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/underName", value);
        }

        @Override
        public Reservation.Builder addUnderName(Person.Builder value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/underName", value.build());
        }

        @Override
        public Reservation.Builder addUnderName(String value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/underName", Text.of(value));
        }

        @Override
        public Reservation.Builder addUrl(URL value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Reservation.Builder addUrl(String value) {
            return (Reservation.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Reservation.Builder addDetailedDescription(Article value) {
            return (Reservation.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Reservation.Builder addDetailedDescription(Article.Builder value) {
            return (Reservation.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Reservation.Builder addDetailedDescription(String value) {
            return (Reservation.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Reservation.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Reservation.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Reservation.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Reservation.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Reservation.Builder addPopularityScore(String value) {
            return (Reservation.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Reservation build() {
            return new ReservationImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

