/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Drug;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalCondition;
import com.google.schemaorg.core.MedicalDevice;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalSign;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalTest;
import com.google.schemaorg.core.MedicalTestImpl;
import com.google.schemaorg.core.MedicalTestPanel;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MedicalTestPanelImpl
extends MedicalTestImpl
implements MedicalTestPanel {
    private static final ImmutableSet<String> PROPERTY_SET = MedicalTestPanelImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/affectedBy");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/normalRange");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/signDetected");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/subTest");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/usedToDiagnose");
        builder.add((Object)"http://schema.org/usesDevice");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MedicalTestPanelImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MedicalTestPanel";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getSubTestList() {
        return this.getProperty("http://schema.org/subTest");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MedicalTestPanel.Builder>
    implements MedicalTestPanel.Builder {
        BuilderImpl() {
        }

        @Override
        public MedicalTestPanel.Builder addAdditionalType(URL value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MedicalTestPanel.Builder addAdditionalType(String value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MedicalTestPanel.Builder addAffectedBy(Drug value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/affectedBy", value);
        }

        @Override
        public MedicalTestPanel.Builder addAffectedBy(Drug.Builder value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/affectedBy", value.build());
        }

        @Override
        public MedicalTestPanel.Builder addAffectedBy(String value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/affectedBy", Text.of(value));
        }

        @Override
        public MedicalTestPanel.Builder addAlternateName(Text value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MedicalTestPanel.Builder addAlternateName(String value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MedicalTestPanel.Builder addCode(MedicalCode value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public MedicalTestPanel.Builder addCode(MedicalCode.Builder value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public MedicalTestPanel.Builder addCode(String value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public MedicalTestPanel.Builder addDescription(Text value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MedicalTestPanel.Builder addDescription(String value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MedicalTestPanel.Builder addGuideline(MedicalGuideline value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public MedicalTestPanel.Builder addGuideline(MedicalGuideline.Builder value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public MedicalTestPanel.Builder addGuideline(String value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public MedicalTestPanel.Builder addImage(ImageObject value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalTestPanel.Builder addImage(ImageObject.Builder value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MedicalTestPanel.Builder addImage(URL value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalTestPanel.Builder addImage(String value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MedicalTestPanel.Builder addMainEntityOfPage(CreativeWork value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalTestPanel.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MedicalTestPanel.Builder addMainEntityOfPage(URL value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalTestPanel.Builder addMainEntityOfPage(String value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MedicalTestPanel.Builder addMedicineSystem(MedicineSystem value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public MedicalTestPanel.Builder addMedicineSystem(String value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public MedicalTestPanel.Builder addName(Text value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MedicalTestPanel.Builder addName(String value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MedicalTestPanel.Builder addNormalRange(Text value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/normalRange", value);
        }

        @Override
        public MedicalTestPanel.Builder addNormalRange(String value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/normalRange", Text.of(value));
        }

        @Override
        public MedicalTestPanel.Builder addPotentialAction(Action value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MedicalTestPanel.Builder addPotentialAction(Action.Builder value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MedicalTestPanel.Builder addPotentialAction(String value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MedicalTestPanel.Builder addRecognizingAuthority(Organization value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public MedicalTestPanel.Builder addRecognizingAuthority(Organization.Builder value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public MedicalTestPanel.Builder addRecognizingAuthority(String value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public MedicalTestPanel.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public MedicalTestPanel.Builder addRelevantSpecialty(String value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public MedicalTestPanel.Builder addSameAs(URL value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MedicalTestPanel.Builder addSameAs(String value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MedicalTestPanel.Builder addSignDetected(MedicalSign value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/signDetected", value);
        }

        @Override
        public MedicalTestPanel.Builder addSignDetected(MedicalSign.Builder value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/signDetected", value.build());
        }

        @Override
        public MedicalTestPanel.Builder addSignDetected(String value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/signDetected", Text.of(value));
        }

        @Override
        public MedicalTestPanel.Builder addStudy(MedicalStudy value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public MedicalTestPanel.Builder addStudy(MedicalStudy.Builder value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public MedicalTestPanel.Builder addStudy(String value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public MedicalTestPanel.Builder addSubTest(MedicalTest value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/subTest", value);
        }

        @Override
        public MedicalTestPanel.Builder addSubTest(MedicalTest.Builder value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/subTest", value.build());
        }

        @Override
        public MedicalTestPanel.Builder addSubTest(String value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/subTest", Text.of(value));
        }

        @Override
        public MedicalTestPanel.Builder addUrl(URL value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MedicalTestPanel.Builder addUrl(String value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MedicalTestPanel.Builder addUsedToDiagnose(MedicalCondition value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/usedToDiagnose", value);
        }

        @Override
        public MedicalTestPanel.Builder addUsedToDiagnose(MedicalCondition.Builder value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/usedToDiagnose", value.build());
        }

        @Override
        public MedicalTestPanel.Builder addUsedToDiagnose(String value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/usedToDiagnose", Text.of(value));
        }

        @Override
        public MedicalTestPanel.Builder addUsesDevice(MedicalDevice value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/usesDevice", value);
        }

        @Override
        public MedicalTestPanel.Builder addUsesDevice(MedicalDevice.Builder value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/usesDevice", value.build());
        }

        @Override
        public MedicalTestPanel.Builder addUsesDevice(String value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.org/usesDevice", Text.of(value));
        }

        @Override
        public MedicalTestPanel.Builder addDetailedDescription(Article value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MedicalTestPanel.Builder addDetailedDescription(Article.Builder value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MedicalTestPanel.Builder addDetailedDescription(String value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MedicalTestPanel.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MedicalTestPanel.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MedicalTestPanel.Builder addPopularityScore(String value) {
            return (MedicalTestPanel.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MedicalTestPanel build() {
            return new MedicalTestPanelImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

