/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCause;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalSign;
import com.google.schemaorg.core.MedicalSignOrSymptomImpl;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalTest;
import com.google.schemaorg.core.MedicalTherapy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.PhysicalExam;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MedicalSignImpl
extends MedicalSignOrSymptomImpl
implements MedicalSign {
    private static final ImmutableSet<String> PROPERTY_SET = MedicalSignImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/cause");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/identifyingExam");
        builder.add((Object)"http://schema.org/identifyingTest");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/possibleTreatment");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MedicalSignImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MedicalSign";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getIdentifyingExamList() {
        return this.getProperty("http://schema.org/identifyingExam");
    }

    @Override
    public ImmutableList<SchemaOrgType> getIdentifyingTestList() {
        return this.getProperty("http://schema.org/identifyingTest");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MedicalSign.Builder>
    implements MedicalSign.Builder {
        BuilderImpl() {
        }

        @Override
        public MedicalSign.Builder addAdditionalType(URL value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MedicalSign.Builder addAdditionalType(String value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MedicalSign.Builder addAlternateName(Text value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MedicalSign.Builder addAlternateName(String value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MedicalSign.Builder addCause(MedicalCause value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/cause", value);
        }

        @Override
        public MedicalSign.Builder addCause(MedicalCause.Builder value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/cause", value.build());
        }

        @Override
        public MedicalSign.Builder addCause(String value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/cause", Text.of(value));
        }

        @Override
        public MedicalSign.Builder addCode(MedicalCode value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public MedicalSign.Builder addCode(MedicalCode.Builder value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public MedicalSign.Builder addCode(String value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public MedicalSign.Builder addDescription(Text value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MedicalSign.Builder addDescription(String value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MedicalSign.Builder addGuideline(MedicalGuideline value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public MedicalSign.Builder addGuideline(MedicalGuideline.Builder value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public MedicalSign.Builder addGuideline(String value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public MedicalSign.Builder addIdentifyingExam(PhysicalExam value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/identifyingExam", value);
        }

        @Override
        public MedicalSign.Builder addIdentifyingExam(String value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/identifyingExam", Text.of(value));
        }

        @Override
        public MedicalSign.Builder addIdentifyingTest(MedicalTest value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/identifyingTest", value);
        }

        @Override
        public MedicalSign.Builder addIdentifyingTest(MedicalTest.Builder value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/identifyingTest", value.build());
        }

        @Override
        public MedicalSign.Builder addIdentifyingTest(String value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/identifyingTest", Text.of(value));
        }

        @Override
        public MedicalSign.Builder addImage(ImageObject value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalSign.Builder addImage(ImageObject.Builder value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MedicalSign.Builder addImage(URL value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalSign.Builder addImage(String value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MedicalSign.Builder addMainEntityOfPage(CreativeWork value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalSign.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MedicalSign.Builder addMainEntityOfPage(URL value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalSign.Builder addMainEntityOfPage(String value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MedicalSign.Builder addMedicineSystem(MedicineSystem value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public MedicalSign.Builder addMedicineSystem(String value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public MedicalSign.Builder addName(Text value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MedicalSign.Builder addName(String value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MedicalSign.Builder addPossibleTreatment(MedicalTherapy value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/possibleTreatment", value);
        }

        @Override
        public MedicalSign.Builder addPossibleTreatment(MedicalTherapy.Builder value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/possibleTreatment", value.build());
        }

        @Override
        public MedicalSign.Builder addPossibleTreatment(String value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/possibleTreatment", Text.of(value));
        }

        @Override
        public MedicalSign.Builder addPotentialAction(Action value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MedicalSign.Builder addPotentialAction(Action.Builder value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MedicalSign.Builder addPotentialAction(String value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MedicalSign.Builder addRecognizingAuthority(Organization value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public MedicalSign.Builder addRecognizingAuthority(Organization.Builder value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public MedicalSign.Builder addRecognizingAuthority(String value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public MedicalSign.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public MedicalSign.Builder addRelevantSpecialty(String value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public MedicalSign.Builder addSameAs(URL value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MedicalSign.Builder addSameAs(String value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MedicalSign.Builder addStudy(MedicalStudy value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public MedicalSign.Builder addStudy(MedicalStudy.Builder value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public MedicalSign.Builder addStudy(String value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public MedicalSign.Builder addUrl(URL value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MedicalSign.Builder addUrl(String value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MedicalSign.Builder addDetailedDescription(Article value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MedicalSign.Builder addDetailedDescription(Article.Builder value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MedicalSign.Builder addDetailedDescription(String value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MedicalSign.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MedicalSign.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MedicalSign.Builder addPopularityScore(String value) {
            return (MedicalSign.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MedicalSign build() {
            return new MedicalSignImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

