/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Invoice;
import com.google.schemaorg.core.Order;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.PaymentMethod;
import com.google.schemaorg.core.PaymentStatusType;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.PhysicalActivityCategory;
import com.google.schemaorg.core.PriceSpecification;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class InvoiceImpl
extends IntangibleImpl
implements Invoice {
    private static final ImmutableSet<String> PROPERTY_SET = InvoiceImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/accountId");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/billingPeriod");
        builder.add((Object)"http://schema.org/broker");
        builder.add((Object)"http://schema.org/category");
        builder.add((Object)"http://schema.org/confirmationNumber");
        builder.add((Object)"http://schema.org/customer");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/minimumPaymentDue");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/paymentDue");
        builder.add((Object)"http://schema.org/paymentDueDate");
        builder.add((Object)"http://schema.org/paymentMethod");
        builder.add((Object)"http://schema.org/paymentMethodId");
        builder.add((Object)"http://schema.org/paymentStatus");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/referencesOrder");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/scheduledPaymentDate");
        builder.add((Object)"http://schema.org/totalPaymentDue");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public InvoiceImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Invoice";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAccountIdList() {
        return this.getProperty("http://schema.org/accountId");
    }

    @Override
    public ImmutableList<SchemaOrgType> getBillingPeriodList() {
        return this.getProperty("http://schema.org/billingPeriod");
    }

    @Override
    public ImmutableList<SchemaOrgType> getBrokerList() {
        return this.getProperty("http://schema.org/broker");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCategoryList() {
        return this.getProperty("http://schema.org/category");
    }

    @Override
    public ImmutableList<SchemaOrgType> getConfirmationNumberList() {
        return this.getProperty("http://schema.org/confirmationNumber");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCustomerList() {
        return this.getProperty("http://schema.org/customer");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMinimumPaymentDueList() {
        return this.getProperty("http://schema.org/minimumPaymentDue");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPaymentDueList() {
        return this.getProperty("http://schema.org/paymentDue");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPaymentDueDateList() {
        return this.getProperty("http://schema.org/paymentDueDate");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPaymentMethodList() {
        return this.getProperty("http://schema.org/paymentMethod");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPaymentMethodIdList() {
        return this.getProperty("http://schema.org/paymentMethodId");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPaymentStatusList() {
        return this.getProperty("http://schema.org/paymentStatus");
    }

    @Override
    public ImmutableList<SchemaOrgType> getProviderList() {
        return this.getProperty("http://schema.org/provider");
    }

    @Override
    public ImmutableList<SchemaOrgType> getReferencesOrderList() {
        return this.getProperty("http://schema.org/referencesOrder");
    }

    @Override
    public ImmutableList<SchemaOrgType> getScheduledPaymentDateList() {
        return this.getProperty("http://schema.org/scheduledPaymentDate");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTotalPaymentDueList() {
        return this.getProperty("http://schema.org/totalPaymentDue");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Invoice.Builder>
    implements Invoice.Builder {
        BuilderImpl() {
        }

        @Override
        public Invoice.Builder addAccountId(Text value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/accountId", value);
        }

        @Override
        public Invoice.Builder addAccountId(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/accountId", Text.of(value));
        }

        @Override
        public Invoice.Builder addAdditionalType(URL value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Invoice.Builder addAdditionalType(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Invoice.Builder addAlternateName(Text value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Invoice.Builder addAlternateName(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Invoice.Builder addBillingPeriod(Duration value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/billingPeriod", value);
        }

        @Override
        public Invoice.Builder addBillingPeriod(Duration.Builder value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/billingPeriod", value.build());
        }

        @Override
        public Invoice.Builder addBillingPeriod(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/billingPeriod", Text.of(value));
        }

        @Override
        public Invoice.Builder addBroker(Organization value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/broker", value);
        }

        @Override
        public Invoice.Builder addBroker(Organization.Builder value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/broker", value.build());
        }

        @Override
        public Invoice.Builder addBroker(Person value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/broker", value);
        }

        @Override
        public Invoice.Builder addBroker(Person.Builder value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/broker", value.build());
        }

        @Override
        public Invoice.Builder addBroker(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/broker", Text.of(value));
        }

        @Override
        public Invoice.Builder addCategory(PhysicalActivityCategory value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/category", value);
        }

        @Override
        public Invoice.Builder addCategory(Text value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/category", value);
        }

        @Override
        public Invoice.Builder addCategory(Thing value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/category", value);
        }

        @Override
        public Invoice.Builder addCategory(Thing.Builder value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/category", value.build());
        }

        @Override
        public Invoice.Builder addCategory(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/category", Text.of(value));
        }

        @Override
        public Invoice.Builder addConfirmationNumber(Text value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/confirmationNumber", value);
        }

        @Override
        public Invoice.Builder addConfirmationNumber(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/confirmationNumber", Text.of(value));
        }

        @Override
        public Invoice.Builder addCustomer(Organization value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/customer", value);
        }

        @Override
        public Invoice.Builder addCustomer(Organization.Builder value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/customer", value.build());
        }

        @Override
        public Invoice.Builder addCustomer(Person value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/customer", value);
        }

        @Override
        public Invoice.Builder addCustomer(Person.Builder value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/customer", value.build());
        }

        @Override
        public Invoice.Builder addCustomer(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/customer", Text.of(value));
        }

        @Override
        public Invoice.Builder addDescription(Text value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Invoice.Builder addDescription(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Invoice.Builder addImage(ImageObject value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Invoice.Builder addImage(ImageObject.Builder value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Invoice.Builder addImage(URL value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Invoice.Builder addImage(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Invoice.Builder addMainEntityOfPage(CreativeWork value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Invoice.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Invoice.Builder addMainEntityOfPage(URL value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Invoice.Builder addMainEntityOfPage(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Invoice.Builder addMinimumPaymentDue(PriceSpecification value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/minimumPaymentDue", value);
        }

        @Override
        public Invoice.Builder addMinimumPaymentDue(PriceSpecification.Builder value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/minimumPaymentDue", value.build());
        }

        @Override
        public Invoice.Builder addMinimumPaymentDue(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/minimumPaymentDue", Text.of(value));
        }

        @Override
        public Invoice.Builder addName(Text value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Invoice.Builder addName(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Invoice.Builder addPaymentDue(DateTime value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/paymentDue", value);
        }

        @Override
        public Invoice.Builder addPaymentDue(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/paymentDue", Text.of(value));
        }

        @Override
        public Invoice.Builder addPaymentDueDate(DateTime value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/paymentDueDate", value);
        }

        @Override
        public Invoice.Builder addPaymentDueDate(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/paymentDueDate", Text.of(value));
        }

        @Override
        public Invoice.Builder addPaymentMethod(PaymentMethod value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/paymentMethod", value);
        }

        @Override
        public Invoice.Builder addPaymentMethod(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/paymentMethod", Text.of(value));
        }

        @Override
        public Invoice.Builder addPaymentMethodId(Text value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/paymentMethodId", value);
        }

        @Override
        public Invoice.Builder addPaymentMethodId(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/paymentMethodId", Text.of(value));
        }

        @Override
        public Invoice.Builder addPaymentStatus(PaymentStatusType value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/paymentStatus", value);
        }

        @Override
        public Invoice.Builder addPaymentStatus(Text value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/paymentStatus", value);
        }

        @Override
        public Invoice.Builder addPaymentStatus(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/paymentStatus", Text.of(value));
        }

        @Override
        public Invoice.Builder addPotentialAction(Action value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Invoice.Builder addPotentialAction(Action.Builder value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Invoice.Builder addPotentialAction(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Invoice.Builder addProvider(Organization value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Invoice.Builder addProvider(Organization.Builder value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Invoice.Builder addProvider(Person value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Invoice.Builder addProvider(Person.Builder value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Invoice.Builder addProvider(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public Invoice.Builder addReferencesOrder(Order value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/referencesOrder", value);
        }

        @Override
        public Invoice.Builder addReferencesOrder(Order.Builder value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/referencesOrder", value.build());
        }

        @Override
        public Invoice.Builder addReferencesOrder(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/referencesOrder", Text.of(value));
        }

        @Override
        public Invoice.Builder addSameAs(URL value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Invoice.Builder addSameAs(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Invoice.Builder addScheduledPaymentDate(Date value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/scheduledPaymentDate", value);
        }

        @Override
        public Invoice.Builder addScheduledPaymentDate(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/scheduledPaymentDate", Text.of(value));
        }

        @Override
        public Invoice.Builder addTotalPaymentDue(PriceSpecification value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/totalPaymentDue", value);
        }

        @Override
        public Invoice.Builder addTotalPaymentDue(PriceSpecification.Builder value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/totalPaymentDue", value.build());
        }

        @Override
        public Invoice.Builder addTotalPaymentDue(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/totalPaymentDue", Text.of(value));
        }

        @Override
        public Invoice.Builder addUrl(URL value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Invoice.Builder addUrl(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Invoice.Builder addDetailedDescription(Article value) {
            return (Invoice.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Invoice.Builder addDetailedDescription(Article.Builder value) {
            return (Invoice.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Invoice.Builder addDetailedDescription(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Invoice.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Invoice.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Invoice.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Invoice.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Invoice.Builder addPopularityScore(String value) {
            return (Invoice.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Invoice build() {
            return new InvoiceImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

