/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkImpl;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Question;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class CommentImpl
extends CreativeWorkImpl
implements Comment {
    private static final ImmutableSet<String> PROPERTY_SET = CommentImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/downvoteCount");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/parentItem");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/upvoteCount");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public CommentImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Comment";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getDownvoteCountList() {
        return this.getProperty("http://schema.org/downvoteCount");
    }

    @Override
    public ImmutableList<SchemaOrgType> getParentItemList() {
        return this.getProperty("http://schema.org/parentItem");
    }

    @Override
    public ImmutableList<SchemaOrgType> getUpvoteCountList() {
        return this.getProperty("http://schema.org/upvoteCount");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Comment.Builder>
    implements Comment.Builder {
        BuilderImpl() {
        }

        @Override
        public Comment.Builder addAbout(Thing value) {
            return (Comment.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public Comment.Builder addAbout(Thing.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public Comment.Builder addAbout(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public Comment.Builder addAccessibilityAPI(Text value) {
            return (Comment.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public Comment.Builder addAccessibilityAPI(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public Comment.Builder addAccessibilityControl(Text value) {
            return (Comment.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public Comment.Builder addAccessibilityControl(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public Comment.Builder addAccessibilityFeature(Text value) {
            return (Comment.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public Comment.Builder addAccessibilityFeature(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public Comment.Builder addAccessibilityHazard(Text value) {
            return (Comment.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public Comment.Builder addAccessibilityHazard(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public Comment.Builder addAccountablePerson(Person value) {
            return (Comment.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public Comment.Builder addAccountablePerson(Person.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public Comment.Builder addAccountablePerson(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public Comment.Builder addAdditionalType(URL value) {
            return (Comment.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Comment.Builder addAdditionalType(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Comment.Builder addAggregateRating(AggregateRating value) {
            return (Comment.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public Comment.Builder addAggregateRating(AggregateRating.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public Comment.Builder addAggregateRating(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public Comment.Builder addAlternateName(Text value) {
            return (Comment.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Comment.Builder addAlternateName(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Comment.Builder addAlternativeHeadline(Text value) {
            return (Comment.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public Comment.Builder addAlternativeHeadline(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public Comment.Builder addAssociatedMedia(MediaObject value) {
            return (Comment.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public Comment.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public Comment.Builder addAssociatedMedia(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public Comment.Builder addAudience(Audience value) {
            return (Comment.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public Comment.Builder addAudience(Audience.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public Comment.Builder addAudience(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public Comment.Builder addAudio(AudioObject value) {
            return (Comment.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public Comment.Builder addAudio(AudioObject.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public Comment.Builder addAudio(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public Comment.Builder addAuthor(Organization value) {
            return (Comment.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Comment.Builder addAuthor(Organization.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Comment.Builder addAuthor(Person value) {
            return (Comment.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Comment.Builder addAuthor(Person.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Comment.Builder addAuthor(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public Comment.Builder addAward(Text value) {
            return (Comment.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public Comment.Builder addAward(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public Comment.Builder addAwards(Text value) {
            return (Comment.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public Comment.Builder addAwards(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public Comment.Builder addCharacter(Person value) {
            return (Comment.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public Comment.Builder addCharacter(Person.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public Comment.Builder addCharacter(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public Comment.Builder addCitation(CreativeWork value) {
            return (Comment.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Comment.Builder addCitation(CreativeWork.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public Comment.Builder addCitation(Text value) {
            return (Comment.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Comment.Builder addCitation(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public Comment.Builder addComment(Comment value) {
            return (Comment.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public Comment.Builder addComment(Comment.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public Comment.Builder addComment(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public Comment.Builder addCommentCount(Integer value) {
            return (Comment.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public Comment.Builder addCommentCount(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public Comment.Builder addContentLocation(Place value) {
            return (Comment.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public Comment.Builder addContentLocation(Place.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public Comment.Builder addContentLocation(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public Comment.Builder addContentRating(Text value) {
            return (Comment.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public Comment.Builder addContentRating(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public Comment.Builder addContributor(Organization value) {
            return (Comment.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Comment.Builder addContributor(Organization.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Comment.Builder addContributor(Person value) {
            return (Comment.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Comment.Builder addContributor(Person.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Comment.Builder addContributor(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public Comment.Builder addCopyrightHolder(Organization value) {
            return (Comment.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Comment.Builder addCopyrightHolder(Organization.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Comment.Builder addCopyrightHolder(Person value) {
            return (Comment.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Comment.Builder addCopyrightHolder(Person.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Comment.Builder addCopyrightHolder(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public Comment.Builder addCopyrightYear(Number value) {
            return (Comment.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public Comment.Builder addCopyrightYear(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public Comment.Builder addCreator(Organization value) {
            return (Comment.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Comment.Builder addCreator(Organization.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Comment.Builder addCreator(Person value) {
            return (Comment.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Comment.Builder addCreator(Person.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Comment.Builder addCreator(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public Comment.Builder addDateCreated(Date value) {
            return (Comment.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Comment.Builder addDateCreated(DateTime value) {
            return (Comment.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Comment.Builder addDateCreated(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public Comment.Builder addDateModified(Date value) {
            return (Comment.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Comment.Builder addDateModified(DateTime value) {
            return (Comment.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Comment.Builder addDateModified(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public Comment.Builder addDatePublished(Date value) {
            return (Comment.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public Comment.Builder addDatePublished(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public Comment.Builder addDescription(Text value) {
            return (Comment.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Comment.Builder addDescription(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Comment.Builder addDiscussionUrl(URL value) {
            return (Comment.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public Comment.Builder addDiscussionUrl(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public Comment.Builder addDownvoteCount(Integer value) {
            return (Comment.Builder)this.addProperty("http://schema.org/downvoteCount", value);
        }

        @Override
        public Comment.Builder addDownvoteCount(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/downvoteCount", Text.of(value));
        }

        @Override
        public Comment.Builder addEditor(Person value) {
            return (Comment.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public Comment.Builder addEditor(Person.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public Comment.Builder addEditor(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public Comment.Builder addEducationalAlignment(AlignmentObject value) {
            return (Comment.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public Comment.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public Comment.Builder addEducationalAlignment(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public Comment.Builder addEducationalUse(Text value) {
            return (Comment.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public Comment.Builder addEducationalUse(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public Comment.Builder addEncoding(MediaObject value) {
            return (Comment.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public Comment.Builder addEncoding(MediaObject.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public Comment.Builder addEncoding(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public Comment.Builder addEncodings(MediaObject value) {
            return (Comment.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public Comment.Builder addEncodings(MediaObject.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public Comment.Builder addEncodings(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public Comment.Builder addExampleOfWork(CreativeWork value) {
            return (Comment.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public Comment.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public Comment.Builder addExampleOfWork(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public Comment.Builder addFileFormat(Text value) {
            return (Comment.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public Comment.Builder addFileFormat(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public Comment.Builder addGenre(Text value) {
            return (Comment.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Comment.Builder addGenre(URL value) {
            return (Comment.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Comment.Builder addGenre(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public Comment.Builder addHasPart(CreativeWork value) {
            return (Comment.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public Comment.Builder addHasPart(CreativeWork.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public Comment.Builder addHasPart(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public Comment.Builder addHeadline(Text value) {
            return (Comment.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public Comment.Builder addHeadline(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public Comment.Builder addImage(ImageObject value) {
            return (Comment.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Comment.Builder addImage(ImageObject.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Comment.Builder addImage(URL value) {
            return (Comment.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Comment.Builder addImage(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Comment.Builder addInLanguage(Language value) {
            return (Comment.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Comment.Builder addInLanguage(Language.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public Comment.Builder addInLanguage(Text value) {
            return (Comment.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Comment.Builder addInLanguage(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public Comment.Builder addInteractionStatistic(InteractionCounter value) {
            return (Comment.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public Comment.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public Comment.Builder addInteractionStatistic(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public Comment.Builder addInteractivityType(Text value) {
            return (Comment.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public Comment.Builder addInteractivityType(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public Comment.Builder addIsBasedOnUrl(URL value) {
            return (Comment.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public Comment.Builder addIsBasedOnUrl(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public Comment.Builder addIsFamilyFriendly(Boolean value) {
            return (Comment.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public Comment.Builder addIsFamilyFriendly(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public Comment.Builder addIsPartOf(CreativeWork value) {
            return (Comment.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public Comment.Builder addIsPartOf(CreativeWork.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public Comment.Builder addIsPartOf(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public Comment.Builder addKeywords(Text value) {
            return (Comment.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public Comment.Builder addKeywords(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public Comment.Builder addLearningResourceType(Text value) {
            return (Comment.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public Comment.Builder addLearningResourceType(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public Comment.Builder addLicense(CreativeWork value) {
            return (Comment.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Comment.Builder addLicense(CreativeWork.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public Comment.Builder addLicense(URL value) {
            return (Comment.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Comment.Builder addLicense(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public Comment.Builder addLocationCreated(Place value) {
            return (Comment.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public Comment.Builder addLocationCreated(Place.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public Comment.Builder addLocationCreated(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public Comment.Builder addMainEntity(Thing value) {
            return (Comment.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public Comment.Builder addMainEntity(Thing.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public Comment.Builder addMainEntity(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public Comment.Builder addMainEntityOfPage(CreativeWork value) {
            return (Comment.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Comment.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Comment.Builder addMainEntityOfPage(URL value) {
            return (Comment.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Comment.Builder addMainEntityOfPage(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Comment.Builder addMentions(Thing value) {
            return (Comment.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public Comment.Builder addMentions(Thing.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public Comment.Builder addMentions(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public Comment.Builder addName(Text value) {
            return (Comment.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Comment.Builder addName(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Comment.Builder addOffers(Offer value) {
            return (Comment.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public Comment.Builder addOffers(Offer.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public Comment.Builder addOffers(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public Comment.Builder addParentItem(Question value) {
            return (Comment.Builder)this.addProperty("http://schema.org/parentItem", value);
        }

        @Override
        public Comment.Builder addParentItem(Question.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/parentItem", value.build());
        }

        @Override
        public Comment.Builder addParentItem(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/parentItem", Text.of(value));
        }

        @Override
        public Comment.Builder addPosition(Integer value) {
            return (Comment.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Comment.Builder addPosition(Text value) {
            return (Comment.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Comment.Builder addPosition(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public Comment.Builder addPotentialAction(Action value) {
            return (Comment.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Comment.Builder addPotentialAction(Action.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Comment.Builder addPotentialAction(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Comment.Builder addProducer(Organization value) {
            return (Comment.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Comment.Builder addProducer(Organization.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Comment.Builder addProducer(Person value) {
            return (Comment.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Comment.Builder addProducer(Person.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Comment.Builder addProducer(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public Comment.Builder addProvider(Organization value) {
            return (Comment.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Comment.Builder addProvider(Organization.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Comment.Builder addProvider(Person value) {
            return (Comment.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Comment.Builder addProvider(Person.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Comment.Builder addProvider(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public Comment.Builder addPublication(PublicationEvent value) {
            return (Comment.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public Comment.Builder addPublication(PublicationEvent.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public Comment.Builder addPublication(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public Comment.Builder addPublisher(Organization value) {
            return (Comment.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Comment.Builder addPublisher(Organization.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Comment.Builder addPublisher(Person value) {
            return (Comment.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Comment.Builder addPublisher(Person.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Comment.Builder addPublisher(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public Comment.Builder addPublishingPrinciples(URL value) {
            return (Comment.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public Comment.Builder addPublishingPrinciples(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public Comment.Builder addRecordedAt(Event value) {
            return (Comment.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public Comment.Builder addRecordedAt(Event.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public Comment.Builder addRecordedAt(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public Comment.Builder addReleasedEvent(PublicationEvent value) {
            return (Comment.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public Comment.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public Comment.Builder addReleasedEvent(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public Comment.Builder addReview(Review value) {
            return (Comment.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public Comment.Builder addReview(Review.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public Comment.Builder addReview(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public Comment.Builder addReviews(Review value) {
            return (Comment.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public Comment.Builder addReviews(Review.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public Comment.Builder addReviews(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public Comment.Builder addSameAs(URL value) {
            return (Comment.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Comment.Builder addSameAs(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Comment.Builder addSchemaVersion(Text value) {
            return (Comment.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Comment.Builder addSchemaVersion(URL value) {
            return (Comment.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Comment.Builder addSchemaVersion(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public Comment.Builder addSourceOrganization(Organization value) {
            return (Comment.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public Comment.Builder addSourceOrganization(Organization.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public Comment.Builder addSourceOrganization(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public Comment.Builder addText(Text value) {
            return (Comment.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public Comment.Builder addText(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public Comment.Builder addThumbnailUrl(URL value) {
            return (Comment.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public Comment.Builder addThumbnailUrl(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public Comment.Builder addTimeRequired(Duration value) {
            return (Comment.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public Comment.Builder addTimeRequired(Duration.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public Comment.Builder addTimeRequired(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public Comment.Builder addTranslator(Organization value) {
            return (Comment.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Comment.Builder addTranslator(Organization.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Comment.Builder addTranslator(Person value) {
            return (Comment.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Comment.Builder addTranslator(Person.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Comment.Builder addTranslator(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public Comment.Builder addTypicalAgeRange(Text value) {
            return (Comment.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public Comment.Builder addTypicalAgeRange(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public Comment.Builder addUpvoteCount(Integer value) {
            return (Comment.Builder)this.addProperty("http://schema.org/upvoteCount", value);
        }

        @Override
        public Comment.Builder addUpvoteCount(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/upvoteCount", Text.of(value));
        }

        @Override
        public Comment.Builder addUrl(URL value) {
            return (Comment.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Comment.Builder addUrl(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Comment.Builder addVersion(Number value) {
            return (Comment.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public Comment.Builder addVersion(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public Comment.Builder addVideo(VideoObject value) {
            return (Comment.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public Comment.Builder addVideo(VideoObject.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public Comment.Builder addVideo(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public Comment.Builder addWorkExample(CreativeWork value) {
            return (Comment.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public Comment.Builder addWorkExample(CreativeWork.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public Comment.Builder addWorkExample(String value) {
            return (Comment.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public Comment.Builder addDetailedDescription(Article value) {
            return (Comment.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Comment.Builder addDetailedDescription(Article.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Comment.Builder addDetailedDescription(String value) {
            return (Comment.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Comment.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Comment.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Comment.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Comment.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Comment.Builder addPopularityScore(String value) {
            return (Comment.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Comment build() {
            return new CommentImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

