/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.BroadcastChannel;
import com.google.schemaorg.core.BroadcastService;
import com.google.schemaorg.core.CableOrSatelliteService;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class BroadcastChannelImpl
extends IntangibleImpl
implements BroadcastChannel {
    private static final ImmutableSet<String> PROPERTY_SET = BroadcastChannelImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/broadcastChannelId");
        builder.add((Object)"http://schema.org/broadcastServiceTier");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inBroadcastLineup");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/providesBroadcastService");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public BroadcastChannelImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/BroadcastChannel";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getBroadcastChannelIdList() {
        return this.getProperty("http://schema.org/broadcastChannelId");
    }

    @Override
    public ImmutableList<SchemaOrgType> getBroadcastServiceTierList() {
        return this.getProperty("http://schema.org/broadcastServiceTier");
    }

    @Override
    public ImmutableList<SchemaOrgType> getInBroadcastLineupList() {
        return this.getProperty("http://schema.org/inBroadcastLineup");
    }

    @Override
    public ImmutableList<SchemaOrgType> getProvidesBroadcastServiceList() {
        return this.getProperty("http://schema.org/providesBroadcastService");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<BroadcastChannel.Builder>
    implements BroadcastChannel.Builder {
        BuilderImpl() {
        }

        @Override
        public BroadcastChannel.Builder addAdditionalType(URL value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public BroadcastChannel.Builder addAdditionalType(String value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public BroadcastChannel.Builder addAlternateName(Text value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public BroadcastChannel.Builder addAlternateName(String value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public BroadcastChannel.Builder addBroadcastChannelId(Text value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/broadcastChannelId", value);
        }

        @Override
        public BroadcastChannel.Builder addBroadcastChannelId(String value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/broadcastChannelId", Text.of(value));
        }

        @Override
        public BroadcastChannel.Builder addBroadcastServiceTier(Text value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/broadcastServiceTier", value);
        }

        @Override
        public BroadcastChannel.Builder addBroadcastServiceTier(String value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/broadcastServiceTier", Text.of(value));
        }

        @Override
        public BroadcastChannel.Builder addDescription(Text value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public BroadcastChannel.Builder addDescription(String value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public BroadcastChannel.Builder addImage(ImageObject value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public BroadcastChannel.Builder addImage(ImageObject.Builder value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public BroadcastChannel.Builder addImage(URL value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public BroadcastChannel.Builder addImage(String value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public BroadcastChannel.Builder addInBroadcastLineup(CableOrSatelliteService value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/inBroadcastLineup", value);
        }

        @Override
        public BroadcastChannel.Builder addInBroadcastLineup(CableOrSatelliteService.Builder value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/inBroadcastLineup", value.build());
        }

        @Override
        public BroadcastChannel.Builder addInBroadcastLineup(String value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/inBroadcastLineup", Text.of(value));
        }

        @Override
        public BroadcastChannel.Builder addMainEntityOfPage(CreativeWork value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public BroadcastChannel.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public BroadcastChannel.Builder addMainEntityOfPage(URL value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public BroadcastChannel.Builder addMainEntityOfPage(String value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public BroadcastChannel.Builder addName(Text value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public BroadcastChannel.Builder addName(String value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public BroadcastChannel.Builder addPotentialAction(Action value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public BroadcastChannel.Builder addPotentialAction(Action.Builder value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public BroadcastChannel.Builder addPotentialAction(String value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public BroadcastChannel.Builder addProvidesBroadcastService(BroadcastService value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/providesBroadcastService", value);
        }

        @Override
        public BroadcastChannel.Builder addProvidesBroadcastService(BroadcastService.Builder value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/providesBroadcastService", value.build());
        }

        @Override
        public BroadcastChannel.Builder addProvidesBroadcastService(String value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/providesBroadcastService", Text.of(value));
        }

        @Override
        public BroadcastChannel.Builder addSameAs(URL value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public BroadcastChannel.Builder addSameAs(String value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public BroadcastChannel.Builder addUrl(URL value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public BroadcastChannel.Builder addUrl(String value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public BroadcastChannel.Builder addDetailedDescription(Article value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public BroadcastChannel.Builder addDetailedDescription(Article.Builder value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public BroadcastChannel.Builder addDetailedDescription(String value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public BroadcastChannel.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public BroadcastChannel.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public BroadcastChannel.Builder addPopularityScore(String value) {
            return (BroadcastChannel.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public BroadcastChannel build() {
            return new BroadcastChannelImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

