/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.contrib.gtfs;

import java.util.ArrayList;
import org.matsim.api.core.v01.Id;
import org.matsim.pt.transitSchedule.api.Departure;
import org.matsim.pt.transitSchedule.api.TransitLine;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.pt.transitSchedule.api.TransitRouteStop;
import org.matsim.pt.transitSchedule.api.TransitSchedule;

public class TransitSchedulePostProcessTools {
    public static void copyLateDeparturesToStartOfDay(TransitSchedule schedule, double startTimeOfCopying, String departureExclusionMarker, boolean copyDespiteArrivalBeforeMidnight) {
        for (TransitLine line : schedule.getTransitLines().values()) {
            for (TransitRoute route : line.getRoutes().values()) {
                ArrayList<Departure> departuresToBeAdded = new ArrayList<Departure>();
                for (Departure dep : route.getDepartures().values()) {
                    double oldDepartureTime = dep.getDepartureTime();
                    double arrivalAtLastStop = dep.getDepartureTime() + ((TransitRouteStop)route.getStops().get(route.getStops().size() - 1)).getArrivalOffset().seconds();
                    if (!(oldDepartureTime > startTimeOfCopying) || departureExclusionMarker != null && dep.getId().toString().contains(departureExclusionMarker) || !copyDespiteArrivalBeforeMidnight && !(arrivalAtLastStop >= 86400.0)) continue;
                    Departure copiedDep = schedule.getFactory().createDeparture(Id.create((String)("copied-24h_" + dep.getId().toString()), Departure.class), oldDepartureTime - 86400.0);
                    departuresToBeAdded.add(copiedDep);
                }
                for (Departure copiedDep : departuresToBeAdded) {
                    route.addDeparture(copiedDep);
                }
            }
        }
    }

    public static void copyEarlyDeparturesToFollowingNight(TransitSchedule schedule, double endTimeOfCopying, String departureExclusionMarker) {
        for (TransitLine line : schedule.getTransitLines().values()) {
            for (TransitRoute route : line.getRoutes().values()) {
                ArrayList<Departure> departuresToBeAdded = new ArrayList<Departure>();
                for (Departure dep : route.getDepartures().values()) {
                    double oldDepartureTime = dep.getDepartureTime();
                    if (!(oldDepartureTime < endTimeOfCopying) || departureExclusionMarker != null && dep.getId().toString().contains(departureExclusionMarker)) continue;
                    Departure copiedDep = schedule.getFactory().createDeparture(Id.create((String)("copied+24h_" + dep.getId().toString()), Departure.class), oldDepartureTime + 86400.0);
                    departuresToBeAdded.add(copiedDep);
                }
                for (Departure copiedDep : departuresToBeAdded) {
                    route.addDeparture(copiedDep);
                }
            }
        }
    }
}

