/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.contrib.gtfs;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Frequency;
import com.conveyal.gtfs.model.Route;
import com.conveyal.gtfs.model.Service;
import com.conveyal.gtfs.model.Stop;
import com.conveyal.gtfs.model.StopTime;
import com.conveyal.gtfs.model.Trip;
import java.nio.file.Path;
import java.text.Normalizer;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.contrib.gtfs.RouteType;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.misc.Time;
import org.matsim.pt.transitSchedule.api.Departure;
import org.matsim.pt.transitSchedule.api.TransitLine;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.pt.transitSchedule.api.TransitRouteStop;
import org.matsim.pt.transitSchedule.api.TransitSchedule;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;

public class GtfsConverter {
    private static final Logger log = LogManager.getLogger(GtfsConverter.class);
    private final GTFSFeed feed;
    private final CoordinateTransformation transform;
    private final TransitSchedule ts;
    private final Predicate<Trip> includeTrip;
    private final Predicate<Stop> includeStop;
    private final Predicate<String> includeAgency;
    private final Predicate<Integer> includeRouteType;
    private final boolean useExtendedRouteTypes;
    private final boolean mergeStops;
    private LocalDate date = LocalDate.now();
    private final Map<String, Id<TransitStopFacility>> mappedStops = new HashMap<String, Id<TransitStopFacility>>();

    @Deprecated
    public GtfsConverter(GTFSFeed feed, Scenario scenario, CoordinateTransformation transform, boolean useExtendedRouteTypes) {
        this.feed = Objects.requireNonNull(feed, "Gtfs feed is required");
        this.transform = Objects.requireNonNull(transform, "Coordinate transformation is required");
        this.ts = scenario.getTransitSchedule();
        this.useExtendedRouteTypes = useExtendedRouteTypes;
        this.includeTrip = t -> true;
        this.includeStop = t -> true;
        this.includeAgency = t -> true;
        this.includeRouteType = t -> true;
        this.mergeStops = false;
    }

    private GtfsConverter(GTFSFeed feed, CoordinateTransformation transform, Scenario scenario, LocalDate date, boolean useExtendedRouteTypes, Predicate<Trip> includeTrips, Predicate<Stop> includeStops, Predicate<String> includeAgency, Predicate<Integer> includeRouteType, boolean mergeStops) {
        this.feed = Objects.requireNonNull(feed, "Gtfs feed is required, use .setFeed(...)");
        this.transform = Objects.requireNonNull(transform, "Coordinate transformation is required, use .setTransform(...)");
        this.ts = Objects.requireNonNull(scenario, "Scenario is required, use .setScenario(...)").getTransitSchedule();
        this.date = date;
        this.useExtendedRouteTypes = useExtendedRouteTypes;
        this.includeTrip = includeTrips;
        this.includeStop = includeStops;
        this.includeAgency = includeAgency;
        this.includeRouteType = includeRouteType;
        this.mergeStops = mergeStops;
    }

    @Deprecated
    public void setDate(LocalDate date) {
        this.date = date;
    }

    public void convert() {
        this.convertStops();
        LocalDate startDate = LocalDate.MAX;
        for (Object service : this.feed.services.values()) {
            if (((Service)service).calendar != null && ((Service)service).calendar.start_date.isBefore(startDate)) {
                startDate = ((Service)service).calendar.start_date;
            }
            if (((Service)service).calendar_dates == null) continue;
            for (LocalDate exceptionDate : ((Service)service).calendar_dates.keySet()) {
                if (!exceptionDate.isBefore(startDate)) continue;
                startDate = exceptionDate;
            }
        }
        log.info("Earliest date mentioned in feed: " + startDate);
        LocalDate endDate = LocalDate.MIN;
        for (Service service : this.feed.services.values()) {
            if (service.calendar != null && service.calendar.end_date.isAfter(endDate)) {
                endDate = service.calendar.end_date;
            }
            if (service.calendar_dates == null) continue;
            for (LocalDate exceptionDate : service.calendar_dates.keySet()) {
                if (!exceptionDate.isAfter(endDate)) continue;
                endDate = exceptionDate;
            }
        }
        log.info("Latest date mentioned in feed: " + endDate);
        List<String> activeServiceIds = this.getActiveServiceIds((Map<String, Service>)this.feed.services);
        log.info(String.format("Active Services: %d %s", activeServiceIds.size(), activeServiceIds));
        List<Trip> activeTrips = this.feed.trips.values().stream().filter(trip -> ((Service)this.feed.services.get((Object)trip.service_id)).activeOn(this.date)).filter(this.includeTrip).filter(this::filterAgencyAndType).collect(Collectors.toList());
        log.info(String.format("Active Trips: %d %s", activeTrips.size(), activeTrips.stream().map(trip -> trip.trip_id).collect(Collectors.toList())));
        activeTrips.stream().map(trip -> (Route)this.feed.routes.get(trip.route_id)).distinct().forEach(route -> {
            TransitLine tl = this.ts.getFactory().createTransitLine(this.getReadableTransitLineId((Route)route));
            this.ts.addTransitLine(tl);
            if (route.agency_id != null) {
                tl.getAttributes().putAttribute("gtfs_agency_id", (Object)String.valueOf(route.agency_id));
            }
            tl.getAttributes().putAttribute("gtfs_route_type", (Object)String.valueOf(route.route_type));
            String routeShortName = null;
            routeShortName = route.route_short_name != null ? route.route_short_name : String.valueOf(route.route_id);
            tl.getAttributes().putAttribute("gtfs_route_short_name", (Object)Normalizer.normalize(routeShortName, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", ""));
        });
        this.convertTrips(activeTrips);
        if (activeTrips.isEmpty()) {
            log.warn("There are no converted trips. You might need to change the date for better results.");
        }
        log.info("Conversion successful");
    }

    private boolean filterAgencyAndType(Trip trip) {
        Route route = (Route)this.feed.routes.get(trip.route_id);
        return this.includeRouteType.test(route.route_type) && this.includeAgency.test(route.agency_id);
    }

    private void convertStops() {
        HashMap<Coord, Id> coords = new HashMap<Coord, Id>();
        for (Stop stop : this.feed.stops.values()) {
            if (!this.includeStop.test(stop)) continue;
            Coord coord = this.transform.transform(new Coord(stop.stop_lon, stop.stop_lat));
            if (this.mergeStops && coords.containsKey(coord)) {
                this.mappedStops.put(stop.stop_id, (Id<TransitStopFacility>)((Id)coords.get(coord)));
                continue;
            }
            TransitStopFacility t = this.ts.getFactory().createTransitStopFacility(Id.create((String)stop.stop_id, TransitStopFacility.class), coord, false);
            t.setName(stop.stop_name);
            if (!this.ts.getFacilities().containsKey(t.getId())) {
                this.ts.addStopFacility(t);
            }
            coords.put(coord, t.getId());
        }
    }

    private List<String> getActiveServiceIds(Map<String, Service> services) {
        ArrayList<String> serviceIds = new ArrayList<String>();
        log.info("Used Date for active schedules: " + this.date.toString() + " (weekday: " + this.date.getDayOfWeek().toString() + "). If you want to choose another date, please specify it, before running the converter");
        for (Service service : services.values()) {
            if (!service.activeOn(this.date)) continue;
            serviceIds.add(service.service_id);
        }
        return serviceIds;
    }

    private void convertTrips(List<Trip> trips) {
        int scheduleDepartures = 0;
        int frequencyDepartures = 0;
        for (Trip trip : trips) {
            if (this.feed.getFrequencies(trip.trip_id).isEmpty()) {
                if (this.feed.getOrderedStopTimesForTrip(trip.trip_id) == null || !this.feed.getOrderedStopTimesForTrip(trip.trip_id).iterator().hasNext()) {
                    log.error("Found a trip with neither frequency nor ordered stop times. Will not add any Matsim TransitRoute/Departure for that trip. GTFS trip_id=" + trip.trip_id);
                    continue;
                }
                StopTime firstStopTime = (StopTime)this.feed.getOrderedStopTimesForTrip(trip.trip_id).iterator().next();
                Double departureTime = Time.parseTime((String)String.valueOf(firstStopTime.departure_time));
                ArrayList<TransitRouteStop> stops = new ArrayList<TransitRouteStop>();
                try {
                    for (StopTime stopTime : this.feed.getInterpolatedStopTimesForTrip(trip.trip_id)) {
                        Id<TransitStopFacility> stopId = this.findTransitStop(stopTime);
                        TransitStopFacility stop = (TransitStopFacility)this.ts.getFacilities().get(stopId);
                        if (stop == null) continue;
                        TransitRouteStop.Builder builder = this.ts.getFactory().createTransitRouteStopBuilder(stop);
                        if (stopTime.arrival_time != Integer.MIN_VALUE) {
                            double arrivalOffset = Time.parseTime((String)String.valueOf(stopTime.arrival_time)) - departureTime;
                            builder.arrivalOffset(arrivalOffset);
                        }
                        if (stopTime.departure_time != Integer.MIN_VALUE) {
                            double departureOffset = Time.parseTime((String)String.valueOf(stopTime.departure_time)) - departureTime;
                            builder.departureOffset(departureOffset);
                        }
                        TransitRouteStop routeStop = builder.build();
                        routeStop.setAwaitDepartureTime(true);
                        stops.add(routeStop);
                    }
                }
                catch (GTFSFeed.FirstAndLastStopsDoNotHaveTimes firstAndLastStopsDoNotHaveTimes) {
                    throw new RuntimeException(firstAndLastStopsDoNotHaveTimes);
                }
                TransitLine tl = (TransitLine)this.ts.getTransitLines().get(this.getReadableTransitLineId(trip));
                TransitRoute tr = this.findOrAddTransitRoute(tl, (Route)this.feed.routes.get(trip.route_id), stops);
                Departure departure = this.ts.getFactory().createDeparture(Id.create((String)trip.trip_id, Departure.class), departureTime.doubleValue());
                tr.addDeparture(departure);
                ++scheduleDepartures;
                continue;
            }
            ArrayList<TransitRouteStop> stops = new ArrayList<TransitRouteStop>();
            for (StopTime stopTime : this.feed.getOrderedStopTimesForTrip(trip.trip_id)) {
                Id<TransitStopFacility> stopId = this.findTransitStop(stopTime);
                TransitStopFacility stop = (TransitStopFacility)this.ts.getFacilities().get(stopId);
                if (stop == null) continue;
                TransitRouteStop routeStop = this.ts.getFactory().createTransitRouteStop(stop, Time.parseTime((String)String.valueOf(stopTime.arrival_time)), Time.parseTime((String)String.valueOf(stopTime.departure_time)));
                routeStop.setAwaitDepartureTime(true);
                stops.add(routeStop);
            }
            for (Frequency frequency : this.feed.getFrequencies(trip.trip_id)) {
                for (int time = frequency.start_time; time < frequency.end_time; time += frequency.headway_secs) {
                    TransitLine tl = (TransitLine)this.ts.getTransitLines().get(this.getReadableTransitLineId(trip));
                    TransitRoute tr = this.findOrAddTransitRoute(tl, (Route)this.feed.routes.get(trip.route_id), stops);
                    Departure d = this.ts.getFactory().createDeparture(Id.create((String)(trip.trip_id + "." + time), Departure.class), (double)time);
                    tr.addDeparture(d);
                    ++frequencyDepartures;
                }
            }
        }
        log.info("Created schedule-based departures: " + scheduleDepartures);
        log.info("Created frequency-based departures: " + frequencyDepartures);
    }

    private Id<TransitStopFacility> findTransitStop(StopTime stopTime) {
        if (!this.mergeStops || !this.mappedStops.containsKey(stopTime.stop_id)) {
            return Id.create((String)stopTime.stop_id, TransitStopFacility.class);
        }
        return this.mappedStops.get(stopTime.stop_id);
    }

    private TransitRoute findOrAddTransitRoute(TransitLine tl, Route route, List<TransitRouteStop> stops) {
        for (TransitRoute tr : tl.getRoutes().values()) {
            if (!tr.getStops().equals(stops)) continue;
            return tr;
        }
        Id routeId = Id.create((String)(tl.getId().toString() + "_" + tl.getRoutes().size()), TransitRoute.class);
        RouteType routeType = RouteType.getRouteTypes().get(route.route_type);
        if (routeType == null) {
            throw new RuntimeException("This route type does not exist! Route type = " + route.route_type);
        }
        TransitRoute tr = null;
        tr = !this.useExtendedRouteTypes ? this.ts.getFactory().createTransitRoute(routeId, null, stops, routeType.getSimpleTypeName()) : this.ts.getFactory().createTransitRoute(routeId, null, stops, routeType.getTypeName());
        tl.addRoute(tr);
        return tr;
    }

    private Id<TransitLine> getReadableTransitLineId(Trip trip) {
        return this.getReadableTransitLineId((Route)this.feed.routes.get(trip.route_id));
    }

    private Id<TransitLine> getReadableTransitLineId(Route route) {
        String asciiShortName = "XXX";
        if (route.route_short_name != null && route.route_short_name.length() > 0) {
            asciiShortName = Normalizer.normalize(route.route_short_name, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
        }
        return Id.create((String)(asciiShortName + "---" + route.route_id), TransitLine.class);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private GTFSFeed feed;
        private CoordinateTransformation transform;
        private LocalDate date = LocalDate.now();
        private boolean useExtendedRouteTypes = false;
        private boolean mergeStops = false;
        private Scenario scenario;
        private Predicate<Trip> includeTrip = t -> true;
        private Predicate<Stop> includeStop = t -> true;
        private Predicate<String> includeAgency = t -> true;
        private Predicate<Integer> includeRouteType = t -> true;

        private Builder() {
        }

        public GtfsConverter build() {
            return new GtfsConverter(this.feed, this.transform, this.scenario, this.date, this.useExtendedRouteTypes, this.includeTrip, this.includeStop, this.includeAgency, this.includeRouteType, this.mergeStops);
        }

        public Builder setFeed(GTFSFeed feed) {
            this.feed = feed;
            return this;
        }

        public Builder setFeed(Path feed) {
            this.feed = GTFSFeed.fromFile((String)feed.toString());
            return this;
        }

        public Builder setTransform(CoordinateTransformation transform) {
            this.transform = transform;
            return this;
        }

        public Builder setDate(LocalDate date) {
            this.date = date;
            return this;
        }

        public Builder setScenario(Scenario scenario) {
            this.scenario = scenario;
            return this;
        }

        public Builder setIncludeTrip(Predicate<Trip> includeTrip) {
            this.includeTrip = includeTrip;
            return this;
        }

        public Builder setIncludeAgency(Predicate<String> includeAgency) {
            this.includeAgency = includeAgency;
            return this;
        }

        public Builder setIncludeRouteType(Predicate<Integer> includeRouteType) {
            this.includeRouteType = includeRouteType;
            return this;
        }

        public Builder setIncludeStop(Predicate<Stop> includeStop) {
            this.includeStop = includeStop;
            return this;
        }

        public Builder setUseExtendedRouteTypes(boolean useExtendedRouteTypes) {
            this.useExtendedRouteTypes = useExtendedRouteTypes;
            return this;
        }

        public Builder setMergeStops(boolean mergeStops) {
            this.mergeStops = mergeStops;
            return this;
        }
    }
}

