/*
 * Decompiled with CFR 0.152.
 */
package org.matomo.sdk.extra;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.File;
import org.matomo.sdk.Matomo;
import org.matomo.sdk.QueryParams;
import org.matomo.sdk.TrackMe;
import org.matomo.sdk.Tracker;
import org.matomo.sdk.tools.Checksum;
import timber.log.Timber;

public class DownloadTracker {
    protected static final String TAG = Matomo.tag(DownloadTracker.class);
    private static final String INSTALL_SOURCE_GOOGLE_PLAY = "com.android.vending";
    private final Tracker mTracker;
    private final Object mTrackOnceLock = new Object();
    private final PackageManager mPackMan;
    private final SharedPreferences mPreferences;
    private final Context mContext;
    private final boolean mInternalTracking;
    private String mVersion;
    private final PackageInfo mPkgInfo;

    public DownloadTracker(Tracker tracker) {
        this(tracker, DownloadTracker.getOurPackageInfo(tracker.getMatomo().getContext()));
    }

    private static PackageInfo getOurPackageInfo(Context context) {
        try {
            return context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Timber.tag((String)TAG).e((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public DownloadTracker(Tracker tracker, @NonNull PackageInfo packageInfo) {
        this.mTracker = tracker;
        this.mContext = tracker.getMatomo().getContext();
        this.mPreferences = tracker.getPreferences();
        this.mPackMan = tracker.getMatomo().getContext().getPackageManager();
        this.mPkgInfo = packageInfo;
        this.mInternalTracking = this.mPkgInfo.packageName.equals(this.mContext.getPackageName());
    }

    public void setVersion(@Nullable String version) {
        this.mVersion = version;
    }

    public String getVersion() {
        if (this.mVersion != null) {
            return this.mVersion;
        }
        return Integer.toString(this.mPkgInfo.versionCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackOnce(TrackMe baseTrackme, @NonNull Extra extra) {
        String firedKey = "downloaded:" + this.mPkgInfo.packageName + ":" + this.getVersion();
        Object object = this.mTrackOnceLock;
        synchronized (object) {
            if (!this.mPreferences.getBoolean(firedKey, false)) {
                this.mPreferences.edit().putBoolean(firedKey, true).apply();
                this.trackNewAppDownload(baseTrackme, extra);
            }
        }
    }

    public void trackNewAppDownload(TrackMe baseTrackme, @NonNull Extra extra) {
        boolean delay;
        boolean bl = delay = this.mInternalTracking && INSTALL_SOURCE_GOOGLE_PLAY.equals(this.mPackMan.getInstallerPackageName(this.mPkgInfo.packageName));
        if (delay) {
            Timber.tag((String)TAG).d("Google Play is install source, deferring tracking.", new Object[0]);
        }
        Thread trackTask = new Thread(() -> {
            if (delay) {
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception e) {
                    Timber.tag((String)"ContentValues").e((Throwable)e);
                }
            }
            this.trackNewAppDownloadInternal(baseTrackme, extra);
        });
        if (!delay && !extra.isIntensiveWork()) {
            trackTask.run();
        } else {
            trackTask.start();
        }
    }

    private void trackNewAppDownloadInternal(TrackMe baseTrackMe, @NonNull Extra extra) {
        String referrerExtras;
        String referringApp;
        Timber.tag((String)TAG).d("Tracking app download...", new Object[0]);
        StringBuilder installIdentifier = new StringBuilder();
        installIdentifier.append("http://").append(this.mPkgInfo.packageName).append(":").append(this.getVersion());
        String extraIdentifier = extra.buildExtraIdentifier();
        if (extraIdentifier != null) {
            installIdentifier.append("/").append(extraIdentifier);
        }
        if ((referringApp = this.mPackMan.getInstallerPackageName(this.mPkgInfo.packageName)) != null && referringApp.length() > 200) {
            referringApp = referringApp.substring(0, 200);
        }
        if (referringApp != null && referringApp.equals(INSTALL_SOURCE_GOOGLE_PLAY) && (referrerExtras = this.mTracker.getMatomo().getPreferences().getString("referrer.extras", null)) != null) {
            referringApp = referringApp + "/?" + referrerExtras;
        }
        if (referringApp != null) {
            referringApp = "http://" + referringApp;
        }
        this.mTracker.track(baseTrackMe.set(QueryParams.EVENT_CATEGORY, "Application").set(QueryParams.EVENT_ACTION, "downloaded").set(QueryParams.ACTION_NAME, "application/downloaded").set(QueryParams.URL_PATH, "/application/downloaded").set(QueryParams.DOWNLOAD, installIdentifier.toString()).set(QueryParams.REFERRER, referringApp));
        Timber.tag((String)TAG).d("... app download tracked.", new Object[0]);
    }

    public static interface Extra {
        public boolean isIntensiveWork();

        @Nullable
        public String buildExtraIdentifier();

        public static class None
        implements Extra {
            @Override
            public boolean isIntensiveWork() {
                return false;
            }

            @Override
            @Nullable
            public String buildExtraIdentifier() {
                return null;
            }
        }

        public static abstract class Custom
        implements Extra {
        }

        public static class ApkChecksum
        implements Extra {
            private PackageInfo mPackageInfo;

            public ApkChecksum(Context context) {
                try {
                    this.mPackageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                }
                catch (Exception e) {
                    Timber.tag((String)TAG).e((Throwable)e);
                    this.mPackageInfo = null;
                }
            }

            public ApkChecksum(PackageInfo packageInfo) {
                this.mPackageInfo = packageInfo;
            }

            @Override
            public boolean isIntensiveWork() {
                return true;
            }

            @Override
            @Nullable
            public String buildExtraIdentifier() {
                if (this.mPackageInfo != null && this.mPackageInfo.applicationInfo != null && this.mPackageInfo.applicationInfo.sourceDir != null) {
                    try {
                        return Checksum.getMD5Checksum(new File(this.mPackageInfo.applicationInfo.sourceDir));
                    }
                    catch (Exception e) {
                        Timber.tag((String)TAG).e((Throwable)e);
                    }
                }
                return null;
            }
        }
    }
}

