/*
 * Decompiled with CFR 0.152.
 */
package org.matomo.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import java.util.HashMap;
import java.util.Map;
import org.matomo.sdk.Tracker;
import org.matomo.sdk.dispatcher.DefaultDispatcherFactory;
import org.matomo.sdk.dispatcher.DispatcherFactory;
import org.matomo.sdk.tools.BuildInfo;
import org.matomo.sdk.tools.Checksum;
import org.matomo.sdk.tools.DeviceHelper;
import org.matomo.sdk.tools.PropertySource;
import timber.log.Timber;

public class Matomo {
    public static final String LOGGER_PREFIX = "MATOMO:";
    private static final String TAG = Matomo.tag(Matomo.class);
    private static final String BASE_PREFERENCE_FILE = "org.matomo.sdk";
    @SuppressLint(value={"StaticFieldLeak"})
    private static Matomo sInstance;
    private final Map<Tracker, SharedPreferences> mPreferenceMap = new HashMap<Tracker, SharedPreferences>();
    private final Context mContext;
    private final SharedPreferences mBasePreferences;
    private DispatcherFactory mDispatcherFactory = new DefaultDispatcherFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized Matomo getInstance(Context context) {
        if (sInstance != null) return sInstance;
        Class<Matomo> clazz = Matomo.class;
        synchronized (Matomo.class) {
            if (sInstance != null) return sInstance;
            sInstance = new Matomo(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    private Matomo(Context context) {
        this.mContext = context.getApplicationContext();
        this.mBasePreferences = context.getSharedPreferences(BASE_PREFERENCE_FILE, 0);
    }

    public Context getContext() {
        return this.mContext;
    }

    public SharedPreferences getPreferences() {
        return this.mBasePreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedPreferences getTrackerPreferences(@NonNull Tracker tracker) {
        Map<Tracker, SharedPreferences> map = this.mPreferenceMap;
        synchronized (map) {
            SharedPreferences newPrefs = this.mPreferenceMap.get(tracker);
            if (newPrefs == null) {
                String prefName;
                try {
                    prefName = "org.matomo.sdk_" + Checksum.getMD5Checksum(tracker.getName());
                }
                catch (Exception e) {
                    Timber.tag((String)TAG).e((Throwable)e);
                    prefName = "org.matomo.sdk_" + tracker.getName();
                }
                newPrefs = this.getContext().getSharedPreferences(prefName, 0);
                this.mPreferenceMap.put(tracker, newPrefs);
            }
            return newPrefs;
        }
    }

    public void setDispatcherFactory(DispatcherFactory dispatcherFactory) {
        this.mDispatcherFactory = dispatcherFactory;
    }

    public DispatcherFactory getDispatcherFactory() {
        return this.mDispatcherFactory;
    }

    DeviceHelper getDeviceHelper() {
        return new DeviceHelper(this.mContext, new PropertySource(), new BuildInfo());
    }

    public static String tag(Class ... classes) {
        String[] tags = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            tags[i] = classes[i].getSimpleName();
        }
        return Matomo.tag(tags);
    }

    public static String tag(String ... tags) {
        StringBuilder sb = new StringBuilder(LOGGER_PREFIX);
        for (int i = 0; i < tags.length; ++i) {
            sb.append(tags[i]);
            if (i >= tags.length - 1) continue;
            sb.append(":");
        }
        return sb.toString();
    }
}

