/*
 * Decompiled with CFR 0.152.
 */
package org.matomo.sdk.dispatcher;

import java.net.URLEncoder;
import java.util.Map;
import org.matomo.sdk.Matomo;
import timber.log.Timber;

public class Event {
    private static final String TAG = Matomo.tag(Event.class);
    private final long mTimestamp;
    private final String mQuery;

    public Event(Map<String, String> eventData) {
        this(Event.urlEncodeUTF8(eventData));
    }

    public Event(String query) {
        this(System.currentTimeMillis(), query);
    }

    public Event(long timestamp, String query) {
        this.mTimestamp = timestamp;
        this.mQuery = query;
    }

    public long getTimeStamp() {
        return this.mTimestamp;
    }

    public String getEncodedQuery() {
        return this.mQuery;
    }

    public String toString() {
        return this.getEncodedQuery();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return this.mTimestamp == event.mTimestamp && this.mQuery.equals(event.mQuery);
    }

    public int hashCode() {
        int result = (int)(this.mTimestamp ^ this.mTimestamp >>> 32);
        result = 31 * result + this.mQuery.hashCode();
        return result;
    }

    private static String urlEncodeUTF8(String param) {
        try {
            return URLEncoder.encode(param, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (Exception e) {
            Timber.tag((String)TAG).e((Throwable)e, "Cannot encode %s", new Object[]{param});
            return "";
        }
    }

    private static String urlEncodeUTF8(Map<String, String> map) {
        StringBuilder sb = new StringBuilder(100);
        sb.append('?');
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(Event.urlEncodeUTF8(entry.getKey()));
            sb.append('=');
            sb.append(Event.urlEncodeUTF8(entry.getValue()));
            sb.append('&');
        }
        return sb.substring(0, sb.length() - 1);
    }
}

