/*
 * Decompiled with CFR 0.152.
 */
package org.matomo.sdk.extra;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.matomo.sdk.Matomo;
import org.matomo.sdk.TrackMe;
import org.matomo.sdk.Tracker;
import org.matomo.sdk.extra.CustomDimension;
import timber.log.Timber;

public class DimensionQueue {
    private static final String TAG = Matomo.tag(DimensionQueue.class);
    private final List<CustomDimension> mOneTimeDimensions = new ArrayList<CustomDimension>();

    public DimensionQueue(Tracker tracker) {
        Tracker.Callback callback = this::onTrack;
        tracker.addTrackingCallback(callback);
    }

    public void add(int id, String value) {
        this.mOneTimeDimensions.add(new CustomDimension(id, value));
    }

    private TrackMe onTrack(TrackMe trackMe) {
        Iterator<CustomDimension> it = this.mOneTimeDimensions.iterator();
        while (it.hasNext()) {
            CustomDimension dim = it.next();
            String existing = CustomDimension.getDimension(trackMe, dim.getId());
            if (existing != null) {
                Timber.tag((String)TAG).d("Setting dimension %s to slot %d would overwrite %s, skipping!", new Object[]{dim.getValue(), dim.getId(), existing});
                continue;
            }
            CustomDimension.setDimension(trackMe, dim);
            it.remove();
        }
        return trackMe;
    }
}

