/*
 * Decompiled with CFR 0.152.
 */
package org.matomo.sdk.dispatcher;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPOutputStream;
import org.matomo.sdk.Matomo;
import org.matomo.sdk.dispatcher.Packet;
import org.matomo.sdk.dispatcher.PacketSender;
import timber.log.Timber;

public class DefaultPacketSender
implements PacketSender {
    private static final String TAG = Matomo.tag(DefaultPacketSender.class);
    private long mTimeout = 5000L;
    private boolean mGzip = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(Packet packet) {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)new URL(packet.getTargetURL()).openConnection();
            Timber.tag((String)TAG).v("Connection is open to %s", new Object[]{urlConnection.getURL().toExternalForm()});
            Timber.tag((String)TAG).v("Sending: %s", new Object[]{packet});
            urlConnection.setConnectTimeout((int)this.mTimeout);
            urlConnection.setReadTimeout((int)this.mTimeout);
            if (packet.getPostData() != null) {
                urlConnection.setDoOutput(true);
                urlConnection.setRequestProperty("Content-Type", "application/json");
                urlConnection.setRequestProperty("charset", "utf-8");
                String toPost = packet.getPostData().toString();
                if (this.mGzip) {
                    urlConnection.addRequestProperty("Content-Encoding", "gzip");
                    ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
                    try (GZIPOutputStream gzipStream = new GZIPOutputStream(byteArrayOS);){
                        gzipStream.write(toPost.getBytes(StandardCharsets.UTF_8));
                    }
                    OutputStream outputStream = null;
                    try {
                        outputStream = urlConnection.getOutputStream();
                        outputStream.write(byteArrayOS.toByteArray());
                    }
                    finally {
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException e) {
                                Timber.tag((String)TAG).d((Throwable)e, "Failed to close output stream after writing gzipped POST data.", new Object[0]);
                            }
                        }
                    }
                }
                BufferedWriter writer = null;
                try {
                    writer = new BufferedWriter(new OutputStreamWriter(urlConnection.getOutputStream(), StandardCharsets.UTF_8));
                    writer.write(toPost);
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            Timber.tag((String)TAG).d((Throwable)e, "Failed to close output stream after writing POST data.", new Object[0]);
                        }
                    }
                }
            }
            urlConnection.setDoOutput(false);
            int statusCode = urlConnection.getResponseCode();
            Timber.tag((String)TAG).v("Transmission finished (code=%d).", new Object[]{statusCode});
            boolean successful = DefaultPacketSender.checkResponseCode(statusCode);
            if (successful) {
                InputStream is = urlConnection.getInputStream();
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        Timber.tag((String)TAG).d((Throwable)e, "Failed to close the error stream.", new Object[0]);
                    }
                }
            } else {
                StringBuilder errorReason = new StringBuilder();
                BufferedReader errorReader = null;
                try {
                    String line;
                    errorReader = new BufferedReader(new InputStreamReader(urlConnection.getErrorStream()));
                    while ((line = errorReader.readLine()) != null) {
                        errorReason.append(line);
                    }
                }
                finally {
                    if (errorReader != null) {
                        try {
                            errorReader.close();
                        }
                        catch (IOException e) {
                            Timber.tag((String)TAG).d((Throwable)e, "Failed to close the error stream.", new Object[0]);
                        }
                    }
                }
                Timber.tag((String)TAG).w("Transmission failed (code=%d, reason=%s)", new Object[]{statusCode, errorReason.toString()});
            }
            boolean bl = successful;
            return bl;
        }
        catch (Exception e) {
            Timber.tag((String)TAG).e((Throwable)e, "Transmission failed unexpectedly.", new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    @Override
    public void setTimeout(long timeout) {
        this.mTimeout = timeout;
    }

    @Override
    public void setGzipData(boolean gzip) {
        this.mGzip = gzip;
    }

    private static boolean checkResponseCode(int code) {
        return code == 204 || code == 200;
    }
}

