/*
 * Decompiled with CFR 0.152.
 */
package org.matomo.sdk;

import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Pattern;
import org.matomo.sdk.LegacySettingsPorter;
import org.matomo.sdk.Matomo;
import org.matomo.sdk.QueryParams;
import org.matomo.sdk.TrackMe;
import org.matomo.sdk.TrackerBuilder;
import org.matomo.sdk.dispatcher.DispatchMode;
import org.matomo.sdk.dispatcher.Dispatcher;
import org.matomo.sdk.dispatcher.Packet;
import org.matomo.sdk.tools.DeviceHelper;
import timber.log.Timber;

public class Tracker {
    private static final String TAG = Matomo.tag(Tracker.class);
    private static final String DEFAULT_UNKNOWN_VALUE = "unknown";
    private static final String DEFAULT_TRUE_VALUE = "1";
    private static final String DEFAULT_RECORD_VALUE = "1";
    private static final String DEFAULT_API_VERSION_VALUE = "1";
    protected static final String PREF_KEY_TRACKER_OPTOUT = "tracker.optout";
    protected static final String PREF_KEY_TRACKER_USERID = "tracker.userid";
    protected static final String PREF_KEY_TRACKER_VISITORID = "tracker.visitorid";
    protected static final String PREF_KEY_TRACKER_FIRSTVISIT = "tracker.firstvisit";
    protected static final String PREF_KEY_TRACKER_VISITCOUNT = "tracker.visitcount";
    protected static final String PREF_KEY_TRACKER_PREVIOUSVISIT = "tracker.previousvisit";
    protected static final String PREF_KEY_OFFLINE_CACHE_AGE = "tracker.cache.age";
    protected static final String PREF_KEY_OFFLINE_CACHE_SIZE = "tracker.cache.size";
    protected static final String PREF_KEY_DISPATCHER_MODE = "tracker.dispatcher.mode";
    private static final Pattern VALID_URLS = Pattern.compile("^(\\w+)(?:://)(.+?)$");
    private final Matomo mMatomo;
    private final String mApiUrl;
    private final int mSiteId;
    private final String mDefaultApplicationBaseUrl;
    private final Object mTrackingLock = new Object();
    private final Dispatcher mDispatcher;
    private final String mName;
    private final Random mRandomAntiCachingValue = new Random(new Date().getTime());
    private final TrackMe mDefaultTrackMe = new TrackMe();
    private TrackMe mLastEvent;
    private long mSessionTimeout = 1800000L;
    private long mSessionStartTime = 0L;
    private boolean mOptOut;
    private SharedPreferences mPreferences;
    private final LinkedHashSet<Callback> mTrackingCallbacks = new LinkedHashSet();
    private DispatchMode mDispatchMode;
    private static final Pattern PATTERN_VISITOR_ID = Pattern.compile("^[0-9a-f]{16}$");

    protected Tracker(Matomo matomo, TrackerBuilder config) {
        this.mMatomo = matomo;
        this.mApiUrl = config.getApiUrl();
        this.mSiteId = config.getSiteId();
        this.mName = config.getTrackerName();
        this.mDefaultApplicationBaseUrl = config.getApplicationBaseUrl();
        new LegacySettingsPorter(this.mMatomo).port(this);
        this.mOptOut = this.getPreferences().getBoolean(PREF_KEY_TRACKER_OPTOUT, false);
        this.mDispatcher = this.mMatomo.getDispatcherFactory().build(this);
        this.mDispatcher.setDispatchMode(this.getDispatchMode());
        String userId = this.getPreferences().getString(PREF_KEY_TRACKER_USERID, null);
        this.mDefaultTrackMe.set(QueryParams.USER_ID, userId);
        String visitorId = this.getPreferences().getString(PREF_KEY_TRACKER_VISITORID, null);
        if (visitorId == null) {
            visitorId = Tracker.makeRandomVisitorId();
            this.getPreferences().edit().putString(PREF_KEY_TRACKER_VISITORID, visitorId).apply();
        }
        this.mDefaultTrackMe.set(QueryParams.VISITOR_ID, visitorId);
        this.mDefaultTrackMe.set(QueryParams.SESSION_START, "1");
        DeviceHelper deviceHelper = this.mMatomo.getDeviceHelper();
        String resolution = DEFAULT_UNKNOWN_VALUE;
        int[] res = deviceHelper.getResolution();
        if (res != null) {
            resolution = String.format("%sx%s", res[0], res[1]);
        }
        this.mDefaultTrackMe.set(QueryParams.SCREEN_RESOLUTION, resolution);
        this.mDefaultTrackMe.set(QueryParams.USER_AGENT, deviceHelper.getUserAgent());
        this.mDefaultTrackMe.set(QueryParams.LANGUAGE, deviceHelper.getUserLanguage());
        this.mDefaultTrackMe.set(QueryParams.URL_PATH, config.getApplicationBaseUrl());
    }

    public void addTrackingCallback(Callback callback) {
        this.mTrackingCallbacks.add(callback);
    }

    public void removeTrackingCallback(Callback callback) {
        this.mTrackingCallbacks.remove(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        SharedPreferences prefs;
        this.dispatch();
        String visitorId = Tracker.makeRandomVisitorId();
        SharedPreferences sharedPreferences = prefs = this.getPreferences();
        synchronized (sharedPreferences) {
            SharedPreferences.Editor editor = this.mPreferences.edit();
            editor.remove(PREF_KEY_TRACKER_VISITCOUNT);
            editor.remove(PREF_KEY_TRACKER_PREVIOUSVISIT);
            editor.remove(PREF_KEY_TRACKER_FIRSTVISIT);
            editor.remove(PREF_KEY_TRACKER_USERID);
            editor.remove(PREF_KEY_TRACKER_OPTOUT);
            editor.putString(PREF_KEY_TRACKER_VISITORID, visitorId);
            editor.apply();
        }
        this.mDefaultTrackMe.set(QueryParams.VISITOR_ID, visitorId);
        this.mDefaultTrackMe.set(QueryParams.USER_ID, null);
        this.mDefaultTrackMe.set(QueryParams.FIRST_VISIT_TIMESTAMP, null);
        this.mDefaultTrackMe.set(QueryParams.TOTAL_NUMBER_OF_VISITS, null);
        this.mDefaultTrackMe.set(QueryParams.PREVIOUS_VISIT_TIMESTAMP, null);
        this.mDefaultTrackMe.set(QueryParams.SESSION_START, "1");
        this.mDefaultTrackMe.set(QueryParams.VISIT_SCOPE_CUSTOM_VARIABLES, null);
        this.mDefaultTrackMe.set(QueryParams.CAMPAIGN_NAME, null);
        this.mDefaultTrackMe.set(QueryParams.CAMPAIGN_KEYWORD, null);
        this.startNewSession();
    }

    public void setOptOut(boolean optOut) {
        this.mOptOut = optOut;
        this.getPreferences().edit().putBoolean(PREF_KEY_TRACKER_OPTOUT, optOut).apply();
        this.mDispatcher.clear();
    }

    public boolean isOptOut() {
        return this.mOptOut;
    }

    public String getName() {
        return this.mName;
    }

    public Matomo getMatomo() {
        return this.mMatomo;
    }

    public String getAPIUrl() {
        return this.mApiUrl;
    }

    protected int getSiteId() {
        return this.mSiteId;
    }

    public TrackMe getDefaultTrackMe() {
        return this.mDefaultTrackMe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNewSession() {
        Object object = this.mTrackingLock;
        synchronized (object) {
            this.mSessionStartTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionTimeout(int milliseconds) {
        Object object = this.mTrackingLock;
        synchronized (object) {
            this.mSessionTimeout = milliseconds;
        }
    }

    public long getSessionTimeout() {
        return this.mSessionTimeout;
    }

    public int getDispatchTimeout() {
        return this.mDispatcher.getConnectionTimeOut();
    }

    public void setDispatchTimeout(int timeout) {
        this.mDispatcher.setConnectionTimeOut(timeout);
    }

    public void dispatch() {
        if (this.mOptOut) {
            return;
        }
        this.mDispatcher.forceDispatch();
    }

    public void dispatchBlocking() {
        if (this.mOptOut) {
            return;
        }
        this.mDispatcher.forceDispatchBlocking();
    }

    public Tracker setDispatchInterval(long dispatchInterval) {
        this.mDispatcher.setDispatchInterval(dispatchInterval);
        return this;
    }

    public Tracker setDispatchGzipped(boolean dispatchGzipped) {
        this.mDispatcher.setDispatchGzipped(dispatchGzipped);
        return this;
    }

    public long getDispatchInterval() {
        return this.mDispatcher.getDispatchInterval();
    }

    public void setOfflineCacheAge(long age) {
        this.getPreferences().edit().putLong(PREF_KEY_OFFLINE_CACHE_AGE, age).apply();
    }

    public long getOfflineCacheAge() {
        return this.getPreferences().getLong(PREF_KEY_OFFLINE_CACHE_AGE, 86400000L);
    }

    public void setOfflineCacheSize(long size) {
        this.getPreferences().edit().putLong(PREF_KEY_OFFLINE_CACHE_SIZE, size).apply();
    }

    public long getOfflineCacheSize() {
        return this.getPreferences().getLong(PREF_KEY_OFFLINE_CACHE_SIZE, 0x400000L);
    }

    public DispatchMode getDispatchMode() {
        if (this.mDispatchMode == null) {
            String raw = this.getPreferences().getString(PREF_KEY_DISPATCHER_MODE, null);
            this.mDispatchMode = DispatchMode.fromString(raw);
            if (this.mDispatchMode == null) {
                this.mDispatchMode = DispatchMode.ALWAYS;
            }
        }
        return this.mDispatchMode;
    }

    public void setDispatchMode(DispatchMode mode) {
        this.mDispatchMode = mode;
        if (mode != DispatchMode.EXCEPTION) {
            this.getPreferences().edit().putString(PREF_KEY_DISPATCHER_MODE, mode.toString()).apply();
        }
        this.mDispatcher.setDispatchMode(mode);
    }

    public Tracker setUserId(String userId) {
        this.mDefaultTrackMe.set(QueryParams.USER_ID, userId);
        this.getPreferences().edit().putString(PREF_KEY_TRACKER_USERID, userId).apply();
        return this;
    }

    public String getUserId() {
        return this.mDefaultTrackMe.get(QueryParams.USER_ID);
    }

    public Tracker setVisitorId(String visitorId) throws IllegalArgumentException {
        if (this.confirmVisitorIdFormat(visitorId)) {
            this.mDefaultTrackMe.set(QueryParams.VISITOR_ID, visitorId);
        }
        return this;
    }

    public String getVisitorId() {
        return this.mDefaultTrackMe.get(QueryParams.VISITOR_ID);
    }

    private boolean confirmVisitorIdFormat(String visitorId) throws IllegalArgumentException {
        if (PATTERN_VISITOR_ID.matcher(visitorId).matches()) {
            return true;
        }
        throw new IllegalArgumentException("VisitorId: " + visitorId + " is not of valid format,  the format must match the regular expression: " + PATTERN_VISITOR_ID.pattern());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void injectInitialParams(TrackMe trackMe) {
        long previousVisit;
        long firstVisitTime;
        long visitCount;
        SharedPreferences prefs;
        SharedPreferences sharedPreferences = prefs = this.getPreferences();
        synchronized (sharedPreferences) {
            SharedPreferences.Editor editor = prefs.edit();
            visitCount = 1L + this.getPreferences().getLong(PREF_KEY_TRACKER_VISITCOUNT, 0L);
            editor.putLong(PREF_KEY_TRACKER_VISITCOUNT, visitCount);
            firstVisitTime = prefs.getLong(PREF_KEY_TRACKER_FIRSTVISIT, -1L);
            if (firstVisitTime == -1L) {
                firstVisitTime = System.currentTimeMillis() / 1000L;
                editor.putLong(PREF_KEY_TRACKER_FIRSTVISIT, firstVisitTime);
            }
            previousVisit = prefs.getLong(PREF_KEY_TRACKER_PREVIOUSVISIT, -1L);
            editor.putLong(PREF_KEY_TRACKER_PREVIOUSVISIT, System.currentTimeMillis() / 1000L);
            editor.apply();
        }
        this.mDefaultTrackMe.trySet(QueryParams.FIRST_VISIT_TIMESTAMP, firstVisitTime);
        this.mDefaultTrackMe.trySet(QueryParams.TOTAL_NUMBER_OF_VISITS, visitCount);
        if (previousVisit != -1L) {
            this.mDefaultTrackMe.trySet(QueryParams.PREVIOUS_VISIT_TIMESTAMP, previousVisit);
        }
        trackMe.trySet(QueryParams.SESSION_START, this.mDefaultTrackMe.get(QueryParams.SESSION_START));
        trackMe.trySet(QueryParams.FIRST_VISIT_TIMESTAMP, this.mDefaultTrackMe.get(QueryParams.FIRST_VISIT_TIMESTAMP));
        trackMe.trySet(QueryParams.TOTAL_NUMBER_OF_VISITS, this.mDefaultTrackMe.get(QueryParams.TOTAL_NUMBER_OF_VISITS));
        trackMe.trySet(QueryParams.PREVIOUS_VISIT_TIMESTAMP, this.mDefaultTrackMe.get(QueryParams.PREVIOUS_VISIT_TIMESTAMP));
    }

    private void injectBaseParams(TrackMe trackMe) {
        trackMe.trySet(QueryParams.SITE_ID, this.mSiteId);
        trackMe.trySet(QueryParams.RECORD, "1");
        trackMe.trySet(QueryParams.API_VERSION, "1");
        trackMe.trySet(QueryParams.RANDOM_NUMBER, this.mRandomAntiCachingValue.nextInt(100000));
        trackMe.trySet(QueryParams.DATETIME_OF_REQUEST, new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ", Locale.US).format(new Date()));
        trackMe.trySet(QueryParams.SEND_IMAGE, "0");
        trackMe.trySet(QueryParams.VISITOR_ID, this.mDefaultTrackMe.get(QueryParams.VISITOR_ID));
        trackMe.trySet(QueryParams.USER_ID, this.mDefaultTrackMe.get(QueryParams.USER_ID));
        trackMe.trySet(QueryParams.SCREEN_RESOLUTION, this.mDefaultTrackMe.get(QueryParams.SCREEN_RESOLUTION));
        trackMe.trySet(QueryParams.USER_AGENT, this.mDefaultTrackMe.get(QueryParams.USER_AGENT));
        trackMe.trySet(QueryParams.LANGUAGE, this.mDefaultTrackMe.get(QueryParams.LANGUAGE));
        String urlPath = trackMe.get(QueryParams.URL_PATH);
        if (urlPath == null) {
            urlPath = this.mDefaultTrackMe.get(QueryParams.URL_PATH);
        } else if (!VALID_URLS.matcher(urlPath).matches()) {
            StringBuilder urlBuilder = new StringBuilder(this.mDefaultApplicationBaseUrl);
            if (!this.mDefaultApplicationBaseUrl.endsWith("/") && !urlPath.startsWith("/")) {
                urlBuilder.append("/");
            } else if (this.mDefaultApplicationBaseUrl.endsWith("/") && urlPath.startsWith("/")) {
                urlPath = urlPath.substring(1);
            }
            urlPath = urlBuilder.append(urlPath).toString();
        }
        this.mDefaultTrackMe.set(QueryParams.URL_PATH, urlPath);
        trackMe.set(QueryParams.URL_PATH, urlPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker track(TrackMe trackMe) {
        Object object = this.mTrackingLock;
        synchronized (object) {
            boolean newSession;
            boolean bl = newSession = System.currentTimeMillis() - this.mSessionStartTime > this.mSessionTimeout;
            if (newSession) {
                this.mSessionStartTime = System.currentTimeMillis();
                this.injectInitialParams(trackMe);
            }
            this.injectBaseParams(trackMe);
            for (Callback callback : this.mTrackingCallbacks) {
                trackMe = callback.onTrack(trackMe);
                if (trackMe != null) continue;
                Timber.tag((String)TAG).d("Tracking aborted by %s", new Object[]{callback});
                return this;
            }
            this.mLastEvent = trackMe;
            if (!this.mOptOut) {
                this.mDispatcher.submit(trackMe);
                Timber.tag((String)TAG).d("Event added to the queue: %s", new Object[]{trackMe});
            } else {
                Timber.tag((String)TAG).d("Event omitted due to opt out: %s", new Object[]{trackMe});
            }
            return this;
        }
    }

    public static String makeRandomVisitorId() {
        return UUID.randomUUID().toString().replaceAll("-", "").substring(0, 16);
    }

    public SharedPreferences getPreferences() {
        if (this.mPreferences == null) {
            this.mPreferences = this.mMatomo.getTrackerPreferences(this);
        }
        return this.mPreferences;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tracker tracker = (Tracker)o;
        if (this.mSiteId != tracker.mSiteId) {
            return false;
        }
        if (!this.mApiUrl.equals(tracker.mApiUrl)) {
            return false;
        }
        return this.mName.equals(tracker.mName);
    }

    public int hashCode() {
        int result = this.mApiUrl.hashCode();
        result = 31 * result + this.mSiteId;
        result = 31 * result + this.mName.hashCode();
        return result;
    }

    @VisibleForTesting
    public TrackMe getLastEventX() {
        return this.mLastEvent;
    }

    public void setDryRunTarget(List<Packet> dryRunTarget) {
        this.mDispatcher.setDryRunTarget(dryRunTarget);
    }

    public List<Packet> getDryRunTarget() {
        return this.mDispatcher.getDryRunTarget();
    }

    public static interface Callback {
        @Nullable
        public TrackMe onTrack(TrackMe var1);
    }
}

