/*
 * Decompiled with CFR 0.152.
 */
package org.matomo.sdk.extra;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import org.matomo.sdk.Matomo;
import org.matomo.sdk.TrackMe;
import timber.log.Timber;

public class CustomDimension {
    private static final String TAG = Matomo.tag(CustomDimension.class);
    private final int mId;
    private final String mValue;

    public CustomDimension(int id, String value) {
        this.mId = id;
        this.mValue = value;
    }

    public int getId() {
        return this.mId;
    }

    public String getValue() {
        return this.mValue;
    }

    public static boolean setDimension(@NonNull TrackMe trackMe, int dimensionId, @Nullable String dimensionValue) {
        if (dimensionId < 1) {
            Timber.tag((String)TAG).e("dimensionId should be great than 0 (arg: %d)", new Object[]{dimensionId});
            return false;
        }
        if (dimensionValue != null && dimensionValue.length() > 255) {
            dimensionValue = dimensionValue.substring(0, 255);
            Timber.tag((String)TAG).w("dimensionValue was truncated to 255 chars.", new Object[0]);
        }
        if (dimensionValue != null && dimensionValue.length() == 0) {
            dimensionValue = null;
        }
        trackMe.set(CustomDimension.formatDimensionId(dimensionId), dimensionValue);
        return true;
    }

    public static boolean setDimension(TrackMe trackMe, CustomDimension dimension) {
        return CustomDimension.setDimension(trackMe, dimension.getId(), dimension.getValue());
    }

    @Nullable
    public static String getDimension(TrackMe trackMe, int dimensionId) {
        return trackMe.get(CustomDimension.formatDimensionId(dimensionId));
    }

    private static String formatDimensionId(int id) {
        return "dimension" + id;
    }
}

