/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.sdk.extra;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.support.annotation.Nullable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.piwik.sdk.QueryParams;
import org.piwik.sdk.TrackMe;
import org.piwik.sdk.Tracker;
import org.piwik.sdk.extra.CustomDimension;
import org.piwik.sdk.extra.CustomVariables;
import org.piwik.sdk.extra.DownloadTracker;
import org.piwik.sdk.extra.EcommerceItems;
import org.piwik.sdk.extra.PiwikApplication;
import org.piwik.sdk.extra.PiwikExceptionHandler;
import org.piwik.sdk.tools.ActivityHelper;
import org.piwik.sdk.tools.CurrencyFormatter;
import timber.log.Timber;

public class TrackHelper {
    private static final String LOGGER_TAG = "PIWIK:TrackHelper";
    protected final TrackMe mBaseTrackMe;

    private TrackHelper() {
        this(null);
    }

    private TrackHelper(@Nullable TrackMe baseTrackMe) {
        if (baseTrackMe == null) {
            baseTrackMe = new TrackMe();
        }
        this.mBaseTrackMe = baseTrackMe;
    }

    public static TrackHelper track() {
        return new TrackHelper();
    }

    public static TrackHelper track(@Nullable TrackMe base) {
        return new TrackHelper(base);
    }

    public Screen screen(String path) {
        return new Screen(this, path);
    }

    public Screen screen(Activity activity) {
        String breadcrumbs = ActivityHelper.getBreadcrumbs(activity);
        return new Screen(this, ActivityHelper.breadcrumbsToPath(breadcrumbs)).title(breadcrumbs);
    }

    public EventBuilder event(String category, String action) {
        return new EventBuilder(this, category, action);
    }

    public Goal goal(int idGoal) {
        return new Goal(this, idGoal);
    }

    public Outlink outlink(URL url) {
        return new Outlink(this, url);
    }

    public Search search(String keyword) {
        return new Search(this, keyword);
    }

    public Download download(DownloadTracker downloadTracker) {
        return new Download(downloadTracker, this);
    }

    public Download download() {
        return new Download(null, this);
    }

    public ContentImpression impression(String contentName) {
        return new ContentImpression(this, contentName);
    }

    public ContentInteraction interaction(String contentName, String contentInteraction) {
        return new ContentInteraction(this, contentName, contentInteraction);
    }

    public CartUpdate cartUpdate(int grandTotal) {
        return new CartUpdate(this, grandTotal);
    }

    public Order order(String orderId, int grandTotal) {
        return new Order(this, orderId, grandTotal);
    }

    public Exception exception(Throwable throwable) {
        return new Exception(this, throwable);
    }

    public UncaughtExceptions uncaughtExceptions() {
        return new UncaughtExceptions(this);
    }

    @TargetApi(value=14)
    public AppTracking screens(Application app) {
        return new AppTracking(this, app);
    }

    public Dimension dimension(int id, String value) {
        return new Dimension(this.mBaseTrackMe).dimension(id, value);
    }

    @Deprecated
    public VisitVariables visitVariables(int id, String name, String value) {
        CustomVariables customVariables = new CustomVariables();
        customVariables.put(id, name, value);
        return this.visitVariables(customVariables);
    }

    @Deprecated
    public VisitVariables visitVariables(CustomVariables customVariables) {
        return new VisitVariables(this, customVariables);
    }

    public static class VisitVariables
    extends TrackHelper {
        public VisitVariables(TrackHelper baseBuilder, CustomVariables customVariables) {
            super(baseBuilder.mBaseTrackMe);
            CustomVariables mergedVariables = new CustomVariables(this.mBaseTrackMe.get(QueryParams.VISIT_SCOPE_CUSTOM_VARIABLES));
            mergedVariables.putAll(customVariables);
            this.mBaseTrackMe.set(QueryParams.VISIT_SCOPE_CUSTOM_VARIABLES, mergedVariables.toString());
        }

        @Override
        public VisitVariables visitVariables(int id, String name, String value) {
            CustomVariables customVariables = new CustomVariables(this.mBaseTrackMe.get(QueryParams.VISIT_SCOPE_CUSTOM_VARIABLES));
            customVariables.put(id, name, value);
            this.mBaseTrackMe.set(QueryParams.VISIT_SCOPE_CUSTOM_VARIABLES, customVariables.toString());
            return this;
        }
    }

    public static class Dimension
    extends TrackHelper {
        Dimension(TrackMe base) {
            super(base);
        }

        @Override
        public Dimension dimension(int id, String value) {
            CustomDimension.setDimension(this.mBaseTrackMe, id, value);
            return this;
        }
    }

    public static class AppTracking {
        private final Application mApplication;
        private final TrackHelper mBaseBuilder;

        public AppTracking(TrackHelper baseBuilder, Application application) {
            this.mBaseBuilder = baseBuilder;
            this.mApplication = application;
        }

        @TargetApi(value=14)
        public Application.ActivityLifecycleCallbacks with(final Tracker tracker) {
            Application.ActivityLifecycleCallbacks callback = new Application.ActivityLifecycleCallbacks(){

                public void onActivityCreated(Activity activity, Bundle bundle) {
                }

                public void onActivityStarted(Activity activity) {
                }

                public void onActivityResumed(Activity activity) {
                    mBaseBuilder.screen(activity).with(tracker);
                }

                public void onActivityPaused(Activity activity) {
                }

                public void onActivityStopped(Activity activity) {
                    if (activity != null && activity.isTaskRoot()) {
                        tracker.dispatch();
                    }
                }

                public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
                }

                public void onActivityDestroyed(Activity activity) {
                }
            };
            this.mApplication.registerActivityLifecycleCallbacks(callback);
            return callback;
        }
    }

    public static class UncaughtExceptions {
        private final TrackHelper mBaseBuilder;

        UncaughtExceptions(TrackHelper baseBuilder) {
            this.mBaseBuilder = baseBuilder;
        }

        public Thread.UncaughtExceptionHandler with(Tracker tracker) {
            if (Thread.getDefaultUncaughtExceptionHandler() instanceof PiwikExceptionHandler) {
                throw new RuntimeException("Trying to wrap an existing PiwikExceptionHandler.");
            }
            PiwikExceptionHandler handler = new PiwikExceptionHandler(tracker, this.mBaseBuilder.mBaseTrackMe);
            Thread.setDefaultUncaughtExceptionHandler(handler);
            return handler;
        }
    }

    public static class Exception
    extends BaseEvent {
        private final Throwable mThrowable;
        private String mDescription;
        private boolean mIsFatal;

        Exception(TrackHelper baseBuilder, Throwable throwable) {
            super(baseBuilder);
            this.mThrowable = throwable;
        }

        public Exception description(String description) {
            this.mDescription = description;
            return this;
        }

        public Exception fatal(boolean isFatal) {
            this.mIsFatal = isFatal;
            return this;
        }

        @Override
        public TrackMe build() {
            String className;
            try {
                StackTraceElement trace = this.mThrowable.getStackTrace()[0];
                className = trace.getClassName() + "/" + trace.getMethodName() + ":" + trace.getLineNumber();
            }
            catch (java.lang.Exception e) {
                Timber.tag((String)TrackHelper.LOGGER_TAG).w((Throwable)e, "Couldn't get stack info", new Object[0]);
                className = this.mThrowable.getClass().getName();
            }
            String actionName = "exception/" + (this.mIsFatal ? "fatal/" : "") + className + "/" + this.mDescription;
            return new TrackMe(this.getBaseTrackMe()).set(QueryParams.ACTION_NAME, actionName).set(QueryParams.EVENT_CATEGORY, "Exception").set(QueryParams.EVENT_ACTION, className).set(QueryParams.EVENT_NAME, this.mDescription).set(QueryParams.EVENT_VALUE, this.mIsFatal ? 1 : 0);
        }
    }

    public static class Order
    extends BaseEvent {
        private final String mOrderId;
        private final int mGrandTotal;
        private EcommerceItems mEcommerceItems;
        private Integer mDiscount;
        private Integer mShipping;
        private Integer mTax;
        private Integer mSubTotal;

        Order(TrackHelper baseBuilder, String orderId, int grandTotal) {
            super(baseBuilder);
            this.mOrderId = orderId;
            this.mGrandTotal = grandTotal;
        }

        public Order subTotal(Integer subTotal) {
            this.mSubTotal = subTotal;
            return this;
        }

        public Order tax(Integer tax) {
            this.mTax = tax;
            return this;
        }

        public Order shipping(Integer shipping) {
            this.mShipping = shipping;
            return this;
        }

        public Order discount(Integer discount) {
            this.mDiscount = discount;
            return this;
        }

        public Order items(EcommerceItems items) {
            this.mEcommerceItems = items;
            return this;
        }

        @Override
        public TrackMe build() {
            if (this.mEcommerceItems == null) {
                this.mEcommerceItems = new EcommerceItems();
            }
            return new TrackMe(this.getBaseTrackMe()).set(QueryParams.GOAL_ID, 0).set(QueryParams.ORDER_ID, this.mOrderId).set(QueryParams.REVENUE, CurrencyFormatter.priceString(this.mGrandTotal)).set(QueryParams.ECOMMERCE_ITEMS, this.mEcommerceItems.toJson()).set(QueryParams.SUBTOTAL, CurrencyFormatter.priceString(this.mSubTotal)).set(QueryParams.TAX, CurrencyFormatter.priceString(this.mTax)).set(QueryParams.SHIPPING, CurrencyFormatter.priceString(this.mShipping)).set(QueryParams.DISCOUNT, CurrencyFormatter.priceString(this.mDiscount));
        }
    }

    public static class CartUpdate
    extends BaseEvent {
        private final int mGrandTotal;
        private EcommerceItems mEcommerceItems;

        CartUpdate(TrackHelper baseBuilder, int grandTotal) {
            super(baseBuilder);
            this.mGrandTotal = grandTotal;
        }

        public CartUpdate items(EcommerceItems items) {
            this.mEcommerceItems = items;
            return this;
        }

        @Override
        public TrackMe build() {
            if (this.mEcommerceItems == null) {
                this.mEcommerceItems = new EcommerceItems();
            }
            return new TrackMe(this.getBaseTrackMe()).set(QueryParams.GOAL_ID, 0).set(QueryParams.REVENUE, CurrencyFormatter.priceString(this.mGrandTotal)).set(QueryParams.ECOMMERCE_ITEMS, this.mEcommerceItems.toJson());
        }
    }

    public static class ContentInteraction
    extends BaseEvent {
        private final String mContentName;
        private final String mInteraction;
        private String mContentPiece;
        private String mContentTarget;

        ContentInteraction(TrackHelper baseBuilder, String contentName, String interaction) {
            super(baseBuilder);
            this.mContentName = contentName;
            this.mInteraction = interaction;
        }

        public ContentInteraction piece(String contentPiece) {
            this.mContentPiece = contentPiece;
            return this;
        }

        public ContentInteraction target(String contentTarget) {
            this.mContentTarget = contentTarget;
            return this;
        }

        @Override
        public TrackMe build() {
            if (this.mContentName == null || this.mContentName.length() == 0) {
                throw new IllegalArgumentException("Content name needs to be non-empty");
            }
            if (this.mInteraction == null || this.mInteraction.length() == 0) {
                throw new IllegalArgumentException("Interaction name needs to be non-empty");
            }
            return new TrackMe(this.getBaseTrackMe()).set(QueryParams.CONTENT_NAME, this.mContentName).set(QueryParams.CONTENT_PIECE, this.mContentPiece).set(QueryParams.CONTENT_TARGET, this.mContentTarget).set(QueryParams.CONTENT_INTERACTION, this.mInteraction);
        }
    }

    public static class ContentImpression
    extends BaseEvent {
        private final String mContentName;
        private String mContentPiece;
        private String mContentTarget;

        ContentImpression(TrackHelper baseBuilder, String contentName) {
            super(baseBuilder);
            this.mContentName = contentName;
        }

        public ContentImpression piece(String contentPiece) {
            this.mContentPiece = contentPiece;
            return this;
        }

        public ContentImpression target(String contentTarget) {
            this.mContentTarget = contentTarget;
            return this;
        }

        @Override
        public TrackMe build() {
            if (this.mContentName == null || this.mContentName.length() == 0) {
                throw new IllegalArgumentException("Tracking content impressions requires a non-empty content-name");
            }
            return new TrackMe(this.getBaseTrackMe()).set(QueryParams.CONTENT_NAME, this.mContentName).set(QueryParams.CONTENT_PIECE, this.mContentPiece).set(QueryParams.CONTENT_TARGET, this.mContentTarget);
        }
    }

    public static class Download {
        private DownloadTracker mDownloadTracker;
        private final TrackHelper mBaseBuilder;
        private DownloadTracker.Extra mExtra = new DownloadTracker.Extra.None();
        private boolean mForced = false;
        private String mVersion;

        Download(DownloadTracker downloadTracker, TrackHelper baseBuilder) {
            this.mDownloadTracker = downloadTracker;
            this.mBaseBuilder = baseBuilder;
        }

        public Download identifier(DownloadTracker.Extra identifier) {
            this.mExtra = identifier;
            return this;
        }

        public Download force() {
            this.mForced = true;
            return this;
        }

        public Download version(String version) {
            this.mVersion = version;
            return this;
        }

        public void with(Tracker tracker) {
            if (this.mDownloadTracker == null) {
                this.mDownloadTracker = new DownloadTracker(tracker);
            }
            if (this.mVersion != null) {
                this.mDownloadTracker.setVersion(this.mVersion);
            }
            if (this.mForced) {
                this.mDownloadTracker.trackNewAppDownload(this.mBaseBuilder.mBaseTrackMe, this.mExtra);
            } else {
                this.mDownloadTracker.trackOnce(this.mBaseBuilder.mBaseTrackMe, this.mExtra);
            }
        }
    }

    public static class Search
    extends BaseEvent {
        private final String mKeyword;
        private String mCategory;
        private Integer mCount;

        Search(TrackHelper baseBuilder, String keyword) {
            super(baseBuilder);
            this.mKeyword = keyword;
        }

        public Search category(String category) {
            this.mCategory = category;
            return this;
        }

        public Search count(Integer count) {
            this.mCount = count;
            return this;
        }

        @Override
        public TrackMe build() {
            TrackMe trackMe = new TrackMe(this.getBaseTrackMe()).set(QueryParams.SEARCH_KEYWORD, this.mKeyword).set(QueryParams.SEARCH_CATEGORY, this.mCategory);
            if (this.mCount != null) {
                trackMe.set(QueryParams.SEARCH_NUMBER_OF_HITS, this.mCount);
            }
            return trackMe;
        }
    }

    public static class Outlink
    extends BaseEvent {
        private final URL mURL;

        Outlink(TrackHelper baseBuilder, URL url) {
            super(baseBuilder);
            this.mURL = url;
        }

        @Override
        public TrackMe build() {
            if (this.mURL == null || this.mURL.toExternalForm().length() == 0) {
                throw new IllegalArgumentException("Outlink tracking requires a non-empty URL");
            }
            if (!(this.mURL.getProtocol().equals("http") || this.mURL.getProtocol().equals("https") || this.mURL.getProtocol().equals("ftp"))) {
                throw new IllegalArgumentException("Only http|https|ftp is supported for outlinks");
            }
            return new TrackMe(this.getBaseTrackMe()).set(QueryParams.LINK, this.mURL.toExternalForm()).set(QueryParams.URL_PATH, this.mURL.toExternalForm());
        }
    }

    public static class Goal
    extends BaseEvent {
        private final int mIdGoal;
        private Float mRevenue;

        Goal(TrackHelper baseBuilder, int idGoal) {
            super(baseBuilder);
            this.mIdGoal = idGoal;
        }

        public Goal revenue(Float revenue) {
            this.mRevenue = revenue;
            return this;
        }

        @Override
        public TrackMe build() {
            if (this.mIdGoal < 0) {
                throw new IllegalArgumentException("Goal id needs to be >=0");
            }
            TrackMe trackMe = new TrackMe(this.getBaseTrackMe()).set(QueryParams.GOAL_ID, this.mIdGoal);
            if (this.mRevenue != null) {
                trackMe.set(QueryParams.REVENUE, this.mRevenue.floatValue());
            }
            return trackMe;
        }
    }

    public static class EventBuilder
    extends BaseEvent {
        private final String mCategory;
        private final String mAction;
        private String mPath;
        private String mName;
        private Float mValue;

        EventBuilder(TrackHelper builder, String category, String action) {
            super(builder);
            this.mCategory = category;
            this.mAction = action;
        }

        public EventBuilder path(String path) {
            this.mPath = path;
            return this;
        }

        public EventBuilder name(String name) {
            this.mName = name;
            return this;
        }

        public EventBuilder value(Float value) {
            this.mValue = value;
            return this;
        }

        @Override
        public TrackMe build() {
            TrackMe trackMe = new TrackMe(this.getBaseTrackMe()).set(QueryParams.URL_PATH, this.mPath).set(QueryParams.EVENT_CATEGORY, this.mCategory).set(QueryParams.EVENT_ACTION, this.mAction).set(QueryParams.EVENT_NAME, this.mName);
            if (this.mValue != null) {
                trackMe.set(QueryParams.EVENT_VALUE, this.mValue.floatValue());
            }
            return trackMe;
        }
    }

    public static class Screen
    extends BaseEvent {
        private final String mPath;
        private final CustomVariables mCustomVariables = new CustomVariables();
        private final Map<Integer, String> mCustomDimensions = new HashMap<Integer, String>();
        private String mTitle;

        Screen(TrackHelper baseBuilder, String path) {
            super(baseBuilder);
            this.mPath = path;
        }

        public Screen title(String title) {
            this.mTitle = title;
            return this;
        }

        public Screen dimension(int index, String dimensionValue) {
            this.mCustomDimensions.put(index, dimensionValue);
            return this;
        }

        @Deprecated
        public Screen variable(int index, String name, String value) {
            this.mCustomVariables.put(index, name, value);
            return this;
        }

        @Override
        public TrackMe build() {
            if (this.mPath == null) {
                throw new IllegalArgumentException("Screen tracking requires a non-empty path");
            }
            TrackMe trackMe = new TrackMe(this.getBaseTrackMe()).set(QueryParams.URL_PATH, this.mPath).set(QueryParams.ACTION_NAME, this.mTitle);
            if (this.mCustomVariables.size() > 0) {
                trackMe.set(QueryParams.SCREEN_SCOPE_CUSTOM_VARIABLES, this.mCustomVariables.toString());
            }
            for (Map.Entry<Integer, String> entry : this.mCustomDimensions.entrySet()) {
                CustomDimension.setDimension(trackMe, entry.getKey(), entry.getValue());
            }
            return trackMe;
        }
    }

    static abstract class BaseEvent {
        private final TrackHelper mBaseBuilder;

        BaseEvent(TrackHelper baseBuilder) {
            this.mBaseBuilder = baseBuilder;
        }

        TrackMe getBaseTrackMe() {
            return this.mBaseBuilder.mBaseTrackMe;
        }

        public abstract TrackMe build();

        public void with(PiwikApplication piwikApplication) {
            this.with(piwikApplication.getTracker());
        }

        public void with(Tracker tracker) {
            TrackMe trackMe = this.build();
            tracker.track(trackMe);
        }

        public boolean safelyWith(PiwikApplication piwikApplication) {
            return this.safelyWith(piwikApplication.getTracker());
        }

        public boolean safelyWith(Tracker tracker) {
            try {
                TrackMe trackMe = this.build();
                tracker.track(trackMe);
            }
            catch (IllegalArgumentException e) {
                Timber.e((Throwable)e);
                return false;
            }
            return true;
        }
    }
}

