/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.sdk.dispatcher;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.zip.GZIPOutputStream;
import org.piwik.sdk.dispatcher.Packet;
import org.piwik.sdk.dispatcher.PacketSender;
import timber.log.Timber;

public class DefaultPacketSender
implements PacketSender {
    private static final String LOGGER_TAG = "PIWIK:DefaultPacketSender";
    private long mTimeout = 5000L;
    private boolean mGzip = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean send(Packet packet) {
        HttpURLConnection urlConnection = null;
        try {
            block18: {
                block17: {
                    urlConnection = (HttpURLConnection)packet.getTargetURL().openConnection();
                    urlConnection.setConnectTimeout((int)this.mTimeout);
                    urlConnection.setReadTimeout((int)this.mTimeout);
                    if (packet.getPostData() == null) break block17;
                    urlConnection.setDoOutput(true);
                    urlConnection.setRequestProperty("Content-Type", "application/json");
                    urlConnection.setRequestProperty("charset", "utf-8");
                    String toPost = packet.getPostData().toString();
                    if (this.mGzip) {
                        urlConnection.addRequestProperty("Content-Encoding", "gzip");
                        ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
                        try (GZIPOutputStream gzipStream = null;){
                            gzipStream = new GZIPOutputStream(byteArrayOS);
                            gzipStream.write(toPost.getBytes(Charset.forName("UTF8")));
                        }
                        urlConnection.getOutputStream().write(byteArrayOS.toByteArray());
                        break block18;
                    } else {
                        try (BufferedWriter writer = null;){
                            writer = new BufferedWriter(new OutputStreamWriter(urlConnection.getOutputStream(), "UTF-8"));
                            writer.write(toPost);
                        }
                    }
                }
                urlConnection.setDoOutput(false);
            }
            int statusCode = urlConnection.getResponseCode();
            Timber.tag((String)LOGGER_TAG).d("status code %s", new Object[]{statusCode});
            boolean bl = DefaultPacketSender.checkResponseCode(statusCode);
            return bl;
        }
        catch (Exception e) {
            Timber.tag((String)LOGGER_TAG).e((Throwable)e, "Sending failed", new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    @Override
    public void setTimeout(long timeout) {
        this.mTimeout = timeout;
    }

    @Override
    public void setGzipData(boolean gzip) {
        this.mGzip = gzip;
    }

    public static boolean checkResponseCode(int code) {
        return code == 204 || code == 200;
    }
}

