/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.sdk.tools;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import java.lang.reflect.Method;
import java.util.Locale;
import org.piwik.sdk.tools.BuildInfo;
import org.piwik.sdk.tools.PropertySource;
import timber.log.Timber;

public class DeviceHelper {
    private static final String LOGGER_TAG = "PIWIK:DeviceHelper";
    private final Context mContext;
    private final PropertySource mPropertySource;
    private final BuildInfo mBuildInfo;

    public DeviceHelper(Context context, PropertySource propertySource, BuildInfo buildInfo) {
        this.mContext = context;
        this.mPropertySource = propertySource;
        this.mBuildInfo = buildInfo;
    }

    public String getUserLanguage() {
        return Locale.getDefault().getLanguage();
    }

    public String getUserAgent() {
        String httpAgent = this.mPropertySource.getHttpAgent();
        if (httpAgent == null || httpAgent.startsWith("Apache-HttpClient/UNAVAILABLE (java")) {
            String dalvik = this.mPropertySource.getJVMVersion();
            if (dalvik == null) {
                dalvik = "0.0.0";
            }
            String android = this.mBuildInfo.getRelease();
            String model = this.mBuildInfo.getModel();
            String build = this.mBuildInfo.getBuildId();
            httpAgent = String.format(Locale.US, "Dalvik/%s (Linux; U; Android %s; %s Build/%s)", dalvik, android, model, build);
        }
        return httpAgent;
    }

    @TargetApi(value=17)
    public int[] getResolution() {
        DisplayMetrics dm;
        Display display;
        int width = -1;
        int height = -1;
        try {
            WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
            display = wm.getDefaultDisplay();
        }
        catch (NullPointerException e) {
            Timber.tag((String)LOGGER_TAG).e((Throwable)e, "Window service was not available from this context", new Object[0]);
            return null;
        }
        if (Build.VERSION.SDK_INT >= 17) {
            dm = new DisplayMetrics();
            display.getRealMetrics(dm);
            width = dm.widthPixels;
            height = dm.heightPixels;
        } else if (Build.VERSION.SDK_INT >= 14) {
            try {
                Method getRawWidth = Display.class.getMethod("getRawWidth", new Class[0]);
                Method getRawHeight = Display.class.getMethod("getRawHeight", new Class[0]);
                width = (Integer)getRawWidth.invoke((Object)display, new Object[0]);
                height = (Integer)getRawHeight.invoke((Object)display, new Object[0]);
            }
            catch (Exception e) {
                Timber.tag((String)LOGGER_TAG).w((Throwable)e, "Reflection of getRawWidth/getRawHeight failed on API14-16 unexpectedly.", new Object[0]);
            }
        }
        if (width == -1 || height == -1) {
            dm = new DisplayMetrics();
            display.getMetrics(dm);
            width = dm.widthPixels;
            height = dm.heightPixels;
        }
        return new int[]{width, height};
    }
}

