/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.sdk.extra;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.piwik.sdk.tools.CurrencyFormatter;

public class EcommerceItems {
    private Map<String, JSONArray> mItems = new HashMap<String, JSONArray>();

    public void addItem(Item item) {
        this.mItems.put(item.mSku, item.toJson());
    }

    public void remove(String sku) {
        this.mItems.remove(sku);
    }

    public void remove(Item item) {
        this.mItems.remove(item.mSku);
    }

    public void clear() {
        this.mItems.clear();
    }

    public String toJson() {
        JSONArray jsonItems = new JSONArray();
        for (JSONArray item : this.mItems.values()) {
            jsonItems.put((Object)item);
        }
        return jsonItems.toString();
    }

    public static class Item {
        private final String mSku;
        private String mCategory;
        private Integer mPrice;
        private Integer mQuantity;
        private String mName;

        public Item(String sku) {
            this.mSku = sku;
        }

        public Item name(String name) {
            this.mName = name;
            return this;
        }

        public Item category(String category) {
            this.mCategory = category;
            return this;
        }

        public Item price(int price) {
            this.mPrice = price;
            return this;
        }

        public Item quantity(int quantity) {
            this.mQuantity = quantity;
            return this;
        }

        public String getSku() {
            return this.mSku;
        }

        public String getCategory() {
            return this.mCategory;
        }

        public Integer getPrice() {
            return this.mPrice;
        }

        public Integer getQuantity() {
            return this.mQuantity;
        }

        public String getName() {
            return this.mName;
        }

        protected JSONArray toJson() {
            JSONArray item = new JSONArray();
            item.put((Object)this.mSku);
            if (this.mName != null) {
                item.put((Object)this.mName);
            }
            if (this.mCategory != null) {
                item.put((Object)this.mCategory);
            }
            if (this.mPrice != null) {
                item.put((Object)CurrencyFormatter.priceString(this.mPrice));
            }
            if (this.mQuantity != null) {
                item.put((Object)String.valueOf(this.mQuantity));
            }
            return item;
        }
    }
}

